/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.commands.argument;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.tardis.mod.misc.Disguise;
import net.tardis.mod.registries.DisguiseRegistry;

public class DisguiseArgument
implements ArgumentType<ResourceLocation> {
    private static final Collection<String> EXAMPLES = Stream.of(DisguiseRegistry.OAK_TREE.get()).map(disguise -> disguise != null ? disguise.getRegistryName().toString() : "").collect(Collectors.toList());
    private static final DynamicCommandExceptionType INVALID_DISGUISE_EXCEPTION = new DynamicCommandExceptionType(disguise -> new TranslationTextComponent("argument.tardis.disguise.invalid", new Object[]{disguise}));

    public ResourceLocation parse(StringReader reader) throws CommandSyntaxException {
        return ResourceLocation.func_195826_a((StringReader)reader);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        Set disguises = DisguiseRegistry.DISGUISE_REGISTRY.get().getKeys();
        return context.getSource() instanceof ISuggestionProvider ? ISuggestionProvider.func_212476_a(disguises.stream(), (SuggestionsBuilder)builder) : Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static DisguiseArgument getDisguiseArgument() {
        return new DisguiseArgument();
    }

    public static Disguise getDisguise(CommandContext<CommandSource> context, String name) throws CommandSyntaxException {
        ResourceLocation resourcelocation = (ResourceLocation)context.getArgument(name, ResourceLocation.class);
        Disguise mission = (Disguise)DisguiseRegistry.DISGUISE_REGISTRY.get().getValue(resourcelocation);
        if (mission == null) {
            throw INVALID_DISGUISE_EXCEPTION.create((Object)resourcelocation);
        }
        return mission;
    }
}

