/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.renderers.layers;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.client.models.misc.VortexMItemLayerModel;
import net.tardis.mod.helper.PlayerHelper;
import net.tardis.mod.items.TItems;

public class VortexMRenderLayer
extends LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
    private final IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> renderPlayer;
    private ItemStack stack = new ItemStack((IItemProvider)TItems.VORTEX_MANIP.get());
    public static VortexMItemLayerModel MODEL = new VortexMItemLayerModel(1.0f);
    public static final ResourceLocation TEXTURE = new ResourceLocation("tardis", "textures/item/vm_entity.png");

    public VortexMRenderLayer(IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> entityRendererIn) {
        super(entityRendererIn);
        this.renderPlayer = entityRendererIn;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean hasSmallArms(AbstractClientPlayerEntity player) {
        return player.func_175154_l().equals("slim");
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, AbstractClientPlayerEntity entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entityIn.field_71071_by.func_70431_c(this.stack)) {
            ItemStack heldStack = PlayerHelper.getHeldOrNearestStack((PlayerEntity)entityIn, this.stack);
            this.renderVMOnOppositeArm(entityIn, heldStack, limbSwing, limbSwingAmount, partialTicks, entityIn.func_184591_cq(), matrixStackIn, bufferIn, packedLightIn);
        }
    }

    private void renderVMOnOppositeArm(AbstractClientPlayerEntity entityIn, ItemStack stack, float limbSwing, float limbSwingAmount, float partialTicks, HandSide primarySide, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn) {
        boolean slim = VortexMRenderLayer.hasSmallArms(entityIn);
        boolean isPrimaryRightHand = primarySide == HandSide.RIGHT;
        matrixStackIn.func_227860_a_();
        if (slim) {
            matrixStackIn.func_227862_a_(0.825f, 1.0f, 1.0f);
            matrixStackIn.func_227861_a_(isPrimaryRightHand ? 0.05 : -0.05, 0.0, 0.0);
        }
        if (!isPrimaryRightHand) {
            VortexMRenderLayer.MODEL.getVMRoot().field_78808_h = (float)(-Math.PI);
            MODEL.getArmRoot().func_78793_a(3.0f, 2.0f, 0.0f);
        } else {
            VortexMRenderLayer.MODEL.getVMRoot().field_78808_h = 0.0f;
            MODEL.getArmRoot().func_78793_a(5.0f, 2.0f, 0.0f);
        }
        this.translateHand(isPrimaryRightHand ? HandSide.LEFT : HandSide.RIGHT, matrixStackIn);
        MODEL.func_225598_a_(matrixStackIn, bufferIn.getBuffer(RenderType.func_228644_e_((ResourceLocation)TEXTURE)), combinedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        stack.getCapability(Capabilities.VORTEX_MANIP).ifPresent(cap -> {
            VortexMRenderLayer.MODEL.getLid().field_78796_g = cap.getOpen() ? -45.0f : 0.0f;
        });
        matrixStackIn.func_227865_b_();
    }

    public void translateHand(HandSide sideIn, MatrixStack matrixStackIn) {
        this.getArmForSide(sideIn).func_228307_a_(matrixStackIn);
    }

    public ModelRenderer getArmForSide(HandSide side) {
        return side == HandSide.LEFT ? ((PlayerModel)this.func_215332_c()).field_178724_i : ((PlayerModel)this.func_215332_c()).field_178723_h;
    }
}

