/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.renderers.layers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.tardis.mod.client.ClientHelper;

public class LaserHurtRenderLayer<E extends LivingEntity, M extends EntityModel<E>>
extends LayerRenderer<E, M> {
    private final IEntityRenderer<E, M> renderEntity;
    public static final ResourceLocation TEXTURE = new ResourceLocation("textures/entity/creeper/creeper_armor.png");

    public LaserHurtRenderLayer(IEntityRenderer<E, M> entityRendererIn) {
        super(entityRendererIn);
        this.renderEntity = entityRendererIn;
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, E entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (ClientHelper.ENTITIES_HURT_BY_LASER.contains(entityIn)) {
            if (((LivingEntity)entityIn).field_70737_aN != 0) {
                EntityModel model = this.renderEntity.func_217764_d();
                if (model != null) {
                    matrixStackIn.func_227860_a_();
                    float swirl = (float)((LivingEntity)entityIn).field_70173_aa + partialTicks;
                    IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228636_a_((ResourceLocation)this.getTexture(), (float)0.0f, (float)(swirl * 0.01f)));
                    boolean isPlayer = false;
                    if (entityIn instanceof PlayerEntity) {
                        isPlayer = true;
                    }
                    float scale = isPlayer ? 1.1f : 1.05f;
                    matrixStackIn.func_227862_a_(scale, scale, scale);
                    model.func_212843_a_(entityIn, limbSwing, limbSwingAmount, partialTicks);
                    this.func_215332_c().func_217111_a(model);
                    model.func_225597_a_(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                    model.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 0.5f, 0.5f, 0.5f, 1.0f);
                    matrixStackIn.func_227865_b_();
                }
            } else {
                ClientHelper.ENTITIES_HURT_BY_LASER.remove(entityIn);
            }
        }
    }

    public ResourceLocation getTexture() {
        return TEXTURE;
    }
}

