/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.renderers.exteriors;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.LivingEntity;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3f;
import net.tardis.mod.blocks.exteriors.ExteriorBlock;
import net.tardis.mod.enums.EnumMatterState;
import net.tardis.mod.helper.PlayerHelper;
import net.tardis.mod.items.TItems;
import net.tardis.mod.tileentities.exteriors.ExteriorTile;

public abstract class ExteriorRenderer<T extends ExteriorTile>
extends TileEntityRenderer<T> {
    public ExteriorRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(T tile, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        matrixStackIn.func_227860_a_();
        ExteriorRenderer.applyTransforms(matrixStackIn, tile);
        float alpha = 1.0f;
        if (((ExteriorTile)tile).getMatterState() != EnumMatterState.SOLID && ((ExteriorTile)tile).getExteriorAnimation() != null) {
            alpha = ((ExteriorTile)tile).getExteriorAnimation().getAlpha();
        }
        this.renderExterior(tile, partialTicks, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, alpha);
        matrixStackIn.func_227865_b_();
        if (Minecraft.func_71410_x().field_71439_g != null && PlayerHelper.InEitherHand((LivingEntity)Minecraft.func_71410_x().field_71439_g, stack -> stack.func_77973_b() == TItems.DEBUG.get())) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.0, 0.0, 0.0);
            IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
            IVertexBuilder builder = buffer.getBuffer(RenderType.func_228659_m_());
            WorldRenderer.func_228430_a_((MatrixStack)matrixStackIn, (IVertexBuilder)builder, (AxisAlignedBB)((ExteriorTile)tile).getDoorAABB(), (float)1.0f, (float)0.0f, (float)0.0f, (float)0.75f);
            matrixStackIn.func_227865_b_();
        }
    }

    public boolean floatInAir() {
        return true;
    }

    public <E extends ExteriorTile> void renderExteriorAsEntity(E tile, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        this.render(tile, partialTicks, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
    }

    public abstract void renderExterior(T var1, float var2, MatrixStack var3, IRenderTypeBuffer var4, int var5, int var6, float var7);

    public static boolean isInverted(ExteriorTile tile) {
        return tile.getCustomName().contains("Dinnerbone") || tile.getCustomName().contains("Grumm") || tile.getCustomName().contains("boti");
    }

    public static void applyTransforms(MatrixStack matrixStack, ExteriorTile tile) {
        matrixStack.func_227861_a_(0.5, -0.5, 0.5);
        matrixStack.func_227863_a_(Vector3f.field_229182_e_.func_229187_a_(180.0f));
        if (tile.func_195044_w() != null && tile.func_195044_w().func_177230_c() instanceof ExteriorBlock) {
            Direction face = (Direction)tile.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(face.func_185119_l() - 180.0f));
        }
        if (ExteriorRenderer.isInverted(tile)) {
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            matrixStack.func_227861_a_(0.0, 1.75, 0.0);
        }
        if (tile.func_145831_w() != null && tile.func_145831_w().func_180495_p(tile.func_174877_v().func_177979_c(2)).func_196958_f()) {
            double offY = Math.cos((double)Minecraft.func_71410_x().field_71441_e.func_82737_E() * 0.05) * 0.06;
            double offX = Math.cos((double)Minecraft.func_71410_x().field_71441_e.func_82737_E() * 0.05) * 0.07;
            double offZ = Math.cos((double)Minecraft.func_71410_x().field_71441_e.func_82737_E() * 0.05) * 0.07;
            matrixStack.func_227861_a_(offX, offY, offZ);
        }
    }
}

