/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.renderers.exteriors;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import net.tardis.mod.client.models.exteriors.DisguiseDoorModel;
import net.tardis.mod.client.renderers.boti.BOTIRenderer;
import net.tardis.mod.client.renderers.boti.PortalInfo;
import net.tardis.mod.client.renderers.exteriors.ExteriorRenderer;
import net.tardis.mod.enums.EnumDoorState;
import net.tardis.mod.helper.Helper;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.misc.Disguise;
import net.tardis.mod.tileentities.exteriors.DisguiseExteriorTile;

public class DisguiseExteriorTileRenderer
extends ExteriorRenderer<DisguiseExteriorTile> {
    public static final ResourceLocation TEXTURE = Helper.createRL("textures/exteriors/disguise.png");
    public static final DisguiseDoorModel MODEL = new DisguiseDoorModel();

    public DisguiseExteriorTileRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    @Override
    public void render(DisguiseExteriorTile tile, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        matrixStackIn.func_227860_a_();
        Disguise disguise = tile.disguise;
        if (disguise != null) {
            matrixStackIn.func_227860_a_();
            Minecraft.func_71410_x().func_175602_ab().renderModel(disguise.getTopState(), tile.func_174877_v(), (IBlockDisplayReader)tile.func_145831_w(), matrixStackIn, bufferIn.getBuffer(RenderTypeLookup.func_228390_a_((BlockState)disguise.getTopState())), false, tile.func_145831_w().field_73012_v, tile.getModelData());
            matrixStackIn.func_227865_b_();
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.0, -1.0, 0.0);
            Minecraft.func_71410_x().func_175602_ab().renderModel(disguise.getBottomState(), tile.func_174877_v().func_177977_b(), (IBlockDisplayReader)tile.func_145831_w(), matrixStackIn, bufferIn.getBuffer(RenderTypeLookup.func_228390_a_((BlockState)disguise.getBottomState())), false, tile.func_145831_w().field_73012_v, tile.getModelData());
            matrixStackIn.func_227865_b_();
        }
        matrixStackIn.func_227865_b_();
        if (tile != null && tile.getBotiWorld() != null && tile.getOpen() != EnumDoorState.CLOSED) {
            PortalInfo info = new PortalInfo();
            info.setWorldShell(tile.getBotiWorld());
            info.setPosition(tile.func_174877_v());
            Direction dir = WorldHelper.getFacingForState(tile.func_145831_w().func_180495_p(tile.func_174877_v()));
            info.setTranslate(matrix -> {
                Quaternion rot = Vector3f.field_229181_d_.func_229187_a_(WorldHelper.getAngleFromFacing(dir));
                if (dir == Direction.EAST || dir == Direction.WEST) {
                    rot.func_195890_a(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                }
                matrix.func_227863_a_(rot);
                matrix.func_227861_a_(0.0, -0.5, 0.0);
            });
            info.setTranslatePortal(matrix -> {
                matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(WorldHelper.getAngleFromFacing(tile.getBotiWorld().getPortalDirection())));
                matrix.func_227861_a_(-0.5, -0.5, -0.5);
            });
            info.setRenderPortal((matrix, buf) -> {
                MODEL.renderBones(tile, 1.0f, (MatrixStack)matrix, buf.getBuffer(RenderType.func_228634_a_((ResourceLocation)TEXTURE)), combinedLightIn, combinedOverlayIn, 1.0f);
                buf.func_228461_a_();
            });
            BOTIRenderer.addPortal(info);
        }
    }

    @Override
    public void renderExterior(DisguiseExteriorTile tile, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn, float alpha) {
    }
}

