/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.renderers.exteriors;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.tardis.mod.client.TRenderTypes;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.misc.BrokenExteriorType;
import net.tardis.mod.tileentities.BrokenExteriorTile;

public class BrokenExteriorRenderer
extends TileEntityRenderer<BrokenExteriorTile> {
    private static HashMap<BrokenExteriorType, BrokenTypeRenderer> RENDERERS = Maps.newHashMap();

    public BrokenExteriorRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(BrokenExteriorTile te, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        BrokenTypeRenderer render;
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.5, -0.5, 0.5);
        matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        if (te.func_195044_w() != null && te.func_195044_w().func_235901_b_((Property)BlockStateProperties.field_208157_J)) {
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(WorldHelper.getAngleFromFacing((Direction)te.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J))));
        }
        if ((render = RENDERERS.get((Object)te.getBrokenType())) != null) {
            render.renderer.renderBrokenExterior(matrixStackIn, bufferIn.getBuffer(TRenderTypes.getTardis(render.texture.get())), combinedLightIn, combinedOverlayIn);
        }
        matrixStackIn.func_227865_b_();
    }

    public static void registerBrokenRenderer(BrokenExteriorType ext, BrokenTypeRenderer renderer) {
        RENDERERS.put(ext, renderer);
    }

    public static interface IBrokenExteriorModel {
        public void renderBrokenExterior(MatrixStack var1, IVertexBuilder var2, int var3, int var4);
    }

    public static class BrokenTypeRenderer {
        public Supplier<ResourceLocation> texture;
        public IBrokenExteriorModel renderer;

        public BrokenTypeRenderer(Supplier<ResourceLocation> texture, IBrokenExteriorModel render) {
            this.texture = texture;
            this.renderer = render;
        }
    }
}

