/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.renderers.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3f;
import net.tardis.mod.client.models.interiordoors.IInteriorDoorRenderer;
import net.tardis.mod.client.models.interiordoors.TrunkInteriorModel;
import net.tardis.mod.entity.DoorEntity;
import net.tardis.mod.helper.PlayerHelper;
import net.tardis.mod.items.TItems;
import net.tardis.mod.misc.IDoorType;

public class DoorRenderer
extends EntityRenderer<DoorEntity> {
    public static IInteriorDoorRenderer MODEL = new TrunkInteriorModel();

    public DoorRenderer(EntityRendererManager manager) {
        super(manager);
    }

    public void render(DoorEntity entity, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        matrixStackIn.func_227860_a_();
        DoorRenderer.applyTranslations(matrixStackIn, entity.field_70177_z - 180.0f, entity.func_174811_aO());
        IDoorType type = IDoorType.EnumDoorType.TRUNK;
        if (entity.doorType != null) {
            type = entity.doorType;
        }
        ResourceLocation texture = type.getInteriorDoorRenderer().getTexture();
        type.getInteriorDoorRenderer().render(entity, matrixStackIn, bufferIn.getBuffer(RenderType.func_230168_b_((ResourceLocation)texture, (boolean)true)), packedLightIn, OverlayTexture.field_229196_a_);
        matrixStackIn.func_227865_b_();
        if (PlayerHelper.InEitherHand((LivingEntity)Minecraft.func_71410_x().field_71439_g, stack -> stack.func_77973_b() == TItems.DEBUG.get())) {
            matrixStackIn.func_227860_a_();
            IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
            IVertexBuilder builder = buffer.getBuffer(RenderType.func_228659_m_());
            WorldRenderer.func_228430_a_((MatrixStack)matrixStackIn, (IVertexBuilder)builder, (AxisAlignedBB)entity.getDoorBB(), (float)0.4f, (float)1.0f, (float)0.4f, (float)0.4f);
            matrixStackIn.func_227865_b_();
        }
    }

    public static void applyTranslations(MatrixStack matrix, float rotation, Direction facing) {
        matrix.func_227861_a_(0.0, 1.5, 0.0);
        matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation));
        if (facing == Direction.EAST || facing == Direction.WEST) {
            matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        }
        matrix.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        matrix.func_227861_a_(0.0, 0.0, 0.1);
    }

    public static void applyTranslations(MatrixStack matrix, DoorEntity door) {
        DoorRenderer.applyTranslations(matrix, door.field_70177_z - 180.0f, door.func_174811_aO());
    }

    public ResourceLocation getEntityTexture(DoorEntity entity) {
        return null;
    }
}

