/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.renderers.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.HashMap;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.tardis.mod.client.models.entity.dalek.DalekModel;
import net.tardis.mod.client.models.entity.dalek.DalekSpecialWeaponModel;
import net.tardis.mod.client.models.entity.dalek.IDalekModel;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.entity.hostile.dalek.DalekEntity;

public class DalekRenderer
extends LivingRenderer<DalekEntity, EntityModel<DalekEntity>> {
    private static HashMap<ResourceLocation, EntityModel<DalekEntity>> MODELS = new HashMap();
    private static final EntityModel<DalekEntity> dalekModel = new DalekModel();
    private static final EntityModel<DalekEntity> dalekSpecModel = new DalekSpecialWeaponModel();

    public DalekRenderer(EntityRendererManager rendererManager) {
        super(rendererManager, (EntityModel)new DalekModel(), 1.0f);
        MODELS.put(TardisConstants.DalekTypes.DALEK_DEFAULT, dalekModel);
        MODELS.put(TardisConstants.DalekTypes.DALEK_RUSTY, dalekModel);
        MODELS.put(TardisConstants.DalekTypes.DALEK_SPEC, dalekSpecModel);
    }

    public void render(DalekEntity dalek, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        this.field_77045_g = MODELS.get(dalek.getDalekType().getRegistryName());
        if (this.field_77045_g instanceof IDalekModel) {
            IDalekModel dalekModel = (IDalekModel)this.field_77045_g;
            dalekModel.setDalek(dalek);
            super.func_225623_a_((LivingEntity)dalek, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        }
    }

    protected boolean canRenderName(DalekEntity entity) {
        return entity.func_200201_e() != null;
    }

    public ResourceLocation getEntityTexture(DalekEntity entity) {
        ResourceLocation texture = entity.getDalekType().getRegistryName();
        return new ResourceLocation(texture.func_110624_b(), "textures/entity/dalek/" + entity.getTexture() + ".png");
    }
}

