/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.renderers.consoles;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.tardis.mod.client.models.consoles.XionConsoleModel;
import net.tardis.mod.controls.MonitorControl;
import net.tardis.mod.helper.Helper;
import net.tardis.mod.misc.WorldText;
import net.tardis.mod.tileentities.consoles.XionConsoleTile;

public class XionConsoleRenderer
extends TileEntityRenderer<XionConsoleTile> {
    public static final XionConsoleModel MODEL = new XionConsoleModel(tex -> RenderType.func_228638_b_((ResourceLocation)tex));
    public static final WorldText TEXT = new WorldText(0.44f, 0.25f, 0.003f, 0xFFFFFF);

    public XionConsoleRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(XionConsoleTile console, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.5, 0.335, 0.5);
        matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        ResourceLocation texture = new ResourceLocation("tardis", "textures/consoles/xion.png");
        console.getControl(MonitorControl.class).ifPresent(monitor -> {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(210.0f));
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(5.0f));
            matrixStackIn.func_227861_a_(-0.222, -1.235, -0.471875);
            TEXT.renderText(matrixStackIn, bufferIn, combinedLightIn, Helper.getConsoleText(console));
            matrixStackIn.func_227865_b_();
        });
        if (console.getVariant() != null) {
            texture = console.getVariant().getTexture();
        }
        float scale = 0.225f;
        matrixStackIn.func_227862_a_(scale, scale, scale);
        MODEL.render(console, scale, matrixStackIn, bufferIn.getBuffer(RenderType.func_228644_e_((ResourceLocation)texture)), combinedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(-1.9, -3.0, 2.44);
        matrixStackIn.func_227863_a_(Vector3f.field_229182_e_.func_229187_a_(25.0f));
        matrixStackIn.func_227863_a_(Vector3f.field_229178_a_.func_229187_a_(12.5f));
        float sonic_scale = 1.25f;
        matrixStackIn.func_227862_a_(sonic_scale, sonic_scale, sonic_scale);
        Minecraft.func_71410_x().func_175599_af().func_229110_a_(console.getSonicItem(), ItemCameraTransforms.TransformType.NONE, combinedLightIn, combinedOverlayIn, matrixStackIn, bufferIn);
        matrixStackIn.func_227865_b_();
        matrixStackIn.func_227865_b_();
    }
}

