/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.renderers.consoles;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.tardis.mod.client.models.consoles.GalvanicConsoleModel;
import net.tardis.mod.controls.MonitorControl;
import net.tardis.mod.helper.Helper;
import net.tardis.mod.misc.WorldText;
import net.tardis.mod.tileentities.consoles.GalvanicConsoleTile;

public class GalvanicConsoleRenderer
extends TileEntityRenderer<GalvanicConsoleTile> {
    public static final GalvanicConsoleModel MODEL = new GalvanicConsoleModel(tex -> RenderType.func_228638_b_((ResourceLocation)tex));
    public static final DecimalFormat FORMAT = new DecimalFormat("###");
    public static final WorldText TEXT = new WorldText(0.3f, 0.22f, 0.0025f, 0);

    public GalvanicConsoleRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(GalvanicConsoleTile console, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.5, 0.35, 0.5);
        matrixStackIn.func_227863_a_(Vector3f.field_229182_e_.func_229187_a_(180.0f));
        matrixStackIn.func_227862_a_(0.25f, 0.25f, 0.25f);
        ResourceLocation texture = new ResourceLocation("tardis", "textures/consoles/galvanic.png");
        if (console.getVariant() != null) {
            texture = console.getVariant().getTexture();
        }
        MODEL.render(console, 0.25f, matrixStackIn, bufferIn.getBuffer(RenderType.func_228644_e_((ResourceLocation)texture)), combinedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227862_a_(1.5f, 1.5f, 1.5f);
        matrixStackIn.func_227861_a_(-0.6, -1.5, 1.4);
        matrixStackIn.func_227863_a_(Vector3f.field_229182_e_.func_229187_a_(22.0f));
        matrixStackIn.func_227863_a_(Vector3f.field_229178_a_.func_229187_a_(10.0f));
        Minecraft.func_71410_x().func_175599_af().func_229110_a_(console.getSonicItem(), ItemCameraTransforms.TransformType.NONE, combinedLightIn, combinedOverlayIn, matrixStackIn, bufferIn);
        matrixStackIn.func_227865_b_();
        console.getControl(MonitorControl.class).ifPresent(monitor -> {
            matrixStackIn.func_227860_a_();
            MODEL.translateMonitorPos(matrixStackIn);
            Minecraft.func_71410_x().field_71460_t.func_228384_l_().func_205108_b();
            matrixStackIn.func_227862_a_(4.0f, 4.0f, 4.0f);
            matrixStackIn.func_227863_a_(Vector3f.field_229178_a_.func_229187_a_(90.0f));
            matrixStackIn.func_227861_a_(-0.135, -0.14, (double)-0.02f);
            TEXT.renderText(matrixStackIn, bufferIn, combinedLightIn, Helper.getConsoleText(console));
            Minecraft.func_71410_x().field_71460_t.func_228384_l_().func_205109_c();
            matrixStackIn.func_227865_b_();
        });
        matrixStackIn.func_227865_b_();
    }
}

