/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.renderers.boti;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.UUID;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.tardis.mod.boti.WorldShell;
import net.tardis.mod.misc.BiFunctionVoid;

public class PortalInfo {
    private UUID id;
    private Vector3d pos;
    private IVoidFunction<MatrixStack> translate;
    private IVoidFunction<MatrixStack> translatePortal;
    private BiFunctionVoid<MatrixStack, IRenderTypeBuffer.Impl> doorRenderer;
    private BiFunctionVoid<MatrixStack, IRenderTypeBuffer.Impl> portalRenderer;
    private WorldShell shell;

    public boolean canRenderFor(PlayerEntity player) {
        return true;
    }

    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setTranslate(IVoidFunction<MatrixStack> translate) {
        this.translate = translate;
    }

    public void setTranslatePortal(IVoidFunction<MatrixStack> translatePortal) {
        this.translatePortal = translatePortal;
    }

    public void translate(MatrixStack stack) {
        if (this.translate != null) {
            this.translate.run(stack);
        }
    }

    public void translatePortal(MatrixStack stack) {
        if (this.translatePortal != null) {
            this.translatePortal.run(stack);
        }
    }

    public void setPosition(Vector3d pos) {
        this.pos = pos;
    }

    public void setPosition(BlockPos pos) {
        this.setPosition(new Vector3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5));
    }

    public Vector3d getPosition() {
        return this.pos;
    }

    public void setWorldShell(WorldShell shell) {
        this.shell = shell;
    }

    public WorldShell getWorldShell() {
        return this.shell;
    }

    public void renderPortal(MatrixStack stack, IRenderTypeBuffer.Impl imp) {
        if (this.portalRenderer != null) {
            this.portalRenderer.run(stack, imp);
        }
    }

    public void renderDoor(MatrixStack stack, IRenderTypeBuffer.Impl imp) {
        if (this.doorRenderer != null) {
            this.doorRenderer.run(stack, imp);
        }
    }

    public void setRenderDoor(BiFunctionVoid<MatrixStack, IRenderTypeBuffer.Impl> door) {
        this.doorRenderer = door;
    }

    public void setRenderPortal(BiFunctionVoid<MatrixStack, IRenderTypeBuffer.Impl> portal) {
        this.portalRenderer = portal;
    }

    public static interface IVoidFunction<T> {
        public void run(T var1);
    }
}

