/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.renderers.boti;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.math.vector.Matrix4f;

public class BotiVBO {
    public VertexFormat format = DefaultVertexFormats.field_176600_a;
    public Map<RenderType, BufferBuilder> buffers = Maps.newHashMap();
    public Map<RenderType, VertexBuffer> vbos = Maps.newHashMap();

    public BotiVBO() {
        this.init();
    }

    public void init() {
        for (RenderType type : RenderType.func_228661_n_()) {
            this.buffers.put(type, new BufferBuilder(this.format.func_177338_f()));
            this.vbos.put(type, new VertexBuffer(this.format));
        }
    }

    public void begin(RenderType type) {
        this.getVBO(type).func_177359_a();
    }

    public VertexBuffer getVBO(RenderType type) {
        return this.vbos.getOrDefault(type, this.vbos.get(RenderType.func_228639_c_()));
    }

    public BufferBuilder getBufferBuilder(RenderType type) {
        return this.buffers.getOrDefault(type, this.buffers.get(RenderType.func_228639_c_()));
    }

    public void resetData(RenderType type) {
        this.getBufferBuilder(type).func_227833_h_();
        this.getBufferBuilder(type).func_178965_a();
    }

    public void upload(RenderType type) {
        BufferBuilder bb = this.getBufferBuilder(type);
        if (bb.func_227834_j_()) {
            bb.func_178977_d();
        }
        this.getVBO(type).func_227875_a_(bb);
    }

    public void unbind(RenderType type) {
        this.getBufferBuilder(type).func_178965_a();
        this.getBufferBuilder(type).func_227833_h_();
        VertexBuffer.func_177361_b();
    }

    public void draw(Matrix4f matrix) {
        for (RenderType type : this.vbos.keySet()) {
            this.begin(type);
            this.format.func_227892_a_(0L);
            type.func_228547_a_();
            this.getVBO(type).func_227874_a_(matrix, 7);
            type.func_228549_b_();
            this.format.func_227895_d_();
            VertexBuffer.func_177361_b();
        }
    }
}

