/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.renderers.boti;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.FluidState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.tardis.mod.Tardis;
import net.tardis.mod.boti.BotiWorld;
import net.tardis.mod.boti.WorldShell;
import net.tardis.mod.boti.stores.BlockStore;
import net.tardis.mod.boti.stores.EntityStorage;
import net.tardis.mod.boti.stores.PlayerEntityStorage;
import net.tardis.mod.client.ClientHelper;
import net.tardis.mod.client.TranslatingVertexBuilder;
import net.tardis.mod.client.renderers.boti.BotiManager;
import net.tardis.mod.client.renderers.boti.BotiTileBuffers;
import net.tardis.mod.client.renderers.boti.BotiVBO;
import net.tardis.mod.client.renderers.boti.BotiWorldRenderer;
import net.tardis.mod.client.renderers.boti.PortalInfo;
import net.tardis.mod.config.TConfig;
import net.tardis.mod.helper.Helper;
import net.tardis.mod.misc.BiFunctionVoid;
import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.GL11;

public class BOTIRenderer {
    public static final BotiManager BOTI = new BotiManager();
    public static final List<PortalInfo> PORTALS = Lists.newArrayList();
    public static final BotiVBO BOTI_VBO = new BotiVBO();
    public static final BotiTileBuffers BOTI_TILE_BUFFERS = new BotiTileBuffers();
    public static BotiWorldRenderer worldRenderer;
    private static Minecraft mc;
    private static final BufferBuilder ENTITY_BUFFER;
    public static boolean RENDERING_BOTI;

    public static void addPortal(PortalInfo info) {
        if (!RENDERING_BOTI) {
            PORTALS.add(info);
        }
    }

    public static void renderBOTI(MatrixStack ms, PortalInfo info, float partialTicks) {
        if (info.getWorldShell() == null) {
            return;
        }
        if (((Boolean)TConfig.CLIENT.enableBoti.get()).booleanValue()) {
            ms.func_227860_a_();
            mc.func_147110_a().func_147609_e();
            BOTI.setupFramebuffer();
            Vector3d skyColor = BOTIRenderer.mc.field_71441_e.func_228318_a_(BOTIRenderer.mc.field_71439_g.func_233580_cy_(), mc.func_184121_ak());
            BOTIRenderer.BOTI.fbo.func_147604_a((float)skyColor.field_72450_a, (float)skyColor.field_72448_b, (float)skyColor.field_72449_c, 0.0f);
            ms.func_227860_a_();
            info.translatePortal(ms);
            GL11.glClear((int)256);
            ClientWorld oldWorld = ClientHelper.getClientWorldCasted();
            if (info.getWorldShell().getWorld() != null) {
                info.getWorldShell().getWorld().setShell(info.getWorldShell());
                Minecraft.func_71410_x().field_71441_e = info.getWorldShell().getWorld();
            }
            FogRenderer.func_228372_a_((ActiveRenderInfo)BOTIRenderer.mc.func_175598_ae().field_217783_c, (FogRenderer.FogType)FogRenderer.FogType.FOG_TERRAIN, (float)80.0f, (boolean)false);
            BOTIRenderer.renderWorld(ms, info.getWorldShell(), 0xF000F0, OverlayTexture.field_229196_a_, partialTicks);
            Minecraft.func_71410_x().field_71441_e = oldWorld;
            FogRenderer.func_228370_a_();
            ms.func_227865_b_();
            BufferBuilder underlyingBuffer = Tessellator.func_178181_a().func_178180_c();
            IRenderTypeBuffer.Impl imBuffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)underlyingBuffer);
            info.renderDoor(ms, imBuffer);
            imBuffer.func_228461_a_();
            Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
            BOTIRenderer.setupStencil(info::renderPortal, ms, imBuffer);
            BOTIRenderer.BOTI.fbo.func_178038_a(Minecraft.func_71410_x().func_228018_at_().func_198109_k(), Minecraft.func_71410_x().func_228018_at_().func_198091_l(), true);
            BOTIRenderer.endStencil(info::renderPortal, ms, imBuffer);
            RenderSystem.loadIdentity();
            BOTI.endFBO();
            Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
            ms.func_227865_b_();
        }
    }

    public static BotiWorldRenderer verifyAndGetRenderer(BotiWorld botiWorld) {
        if (worldRenderer == null) {
            worldRenderer = new BotiWorldRenderer(Minecraft.func_71410_x(), Minecraft.func_71410_x().func_228019_au_());
            worldRenderer.setDimensionType(botiWorld.func_230315_m_(), botiWorld);
            return worldRenderer;
        }
        if (worldRenderer.getDimensionType() != botiWorld.func_230315_m_()) {
            worldRenderer.setDimensionType(botiWorld.func_230315_m_(), botiWorld);
        }
        return worldRenderer;
    }

    public static void setupStencil(BiFunctionVoid<MatrixStack, IRenderTypeBuffer.Impl> drawPortal, MatrixStack stack, IRenderTypeBuffer.Impl buffer) {
        GL11.glEnable((int)2960);
        GL11.glStencilFunc((int)519, (int)1, (int)255);
        GL11.glStencilOp((int)7680, (int)7680, (int)7681);
        GL11.glStencilMask((int)255);
        GL11.glClear((int)1024);
        RenderSystem.depthMask((boolean)false);
        drawPortal.run(stack, buffer);
        buffer.func_228461_a_();
        RenderSystem.depthMask((boolean)true);
        GL11.glStencilMask((int)0);
        GL11.glStencilFunc((int)514, (int)1, (int)255);
    }

    public static void endStencil(BiFunctionVoid<MatrixStack, IRenderTypeBuffer.Impl> drawPortal, MatrixStack stack, IRenderTypeBuffer.Impl buffer) {
        GL11.glDisable((int)2960);
        GL11.glClear((int)1024);
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        RenderSystem.depthMask((boolean)false);
        drawPortal.run(stack, buffer);
        buffer.func_228461_a_();
        RenderSystem.depthMask((boolean)true);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    public static void renderWorld(MatrixStack matrixStack, WorldShell shell, int combinedLight, int combinedOverlay, float partialTicks) {
        matrixStack.func_227860_a_();
        BOTIRenderer.mc.field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
        BlockPos offset = shell.getOffset();
        matrixStack.func_227861_a_((double)(-offset.func_177958_n()), (double)(-offset.func_177956_o()), (double)(-offset.func_177952_p()));
        if (shell.needsUpdate()) {
            shell.setNeedsUpdate(false);
            for (Object type : RenderType.func_228661_n_()) {
                BOTI_VBO.begin((RenderType)type);
                type.func_228547_a_();
                BOTI_VBO.resetData((RenderType)type);
                BufferBuilder builder = BOTI_VBO.getBufferBuilder((RenderType)type);
                if (!builder.func_227834_j_()) {
                    builder.func_181668_a(7, BOTIRenderer.BOTI_VBO.format);
                }
                boolean hasRenderedInLayer = false;
                MatrixStack testStack = new MatrixStack();
                for (Map.Entry<BlockPos, BlockStore> entry : shell.getBlockMap().entrySet()) {
                    testStack.func_227860_a_();
                    testStack.func_227861_a_((double)entry.getKey().func_177958_n(), (double)entry.getKey().func_177956_o(), (double)entry.getKey().func_177952_p());
                    if (entry.getValue().getFluidState().func_206888_e()) {
                        if (RenderTypeLookup.canRenderInLayer((BlockState)entry.getValue().getState(), (RenderType)type)) {
                            if (Helper.canRenderInBOTI(entry.getValue().getState())) {
                                if (entry.getValue().getState().hasTileEntity()) {
                                    IModelData data;
                                    TileEntity te = shell.getWorld().func_175625_s(entry.getKey());
                                    if (te != null && (data = te.getModelData()) != null) {
                                        mc.func_175602_ab().renderModel(entry.getValue().getState(), entry.getKey(), (IBlockDisplayReader)shell.getWorld(), testStack, (IVertexBuilder)builder, true, BOTIRenderer.mc.field_71441_e.field_73012_v, data);
                                    }
                                } else {
                                    mc.func_175602_ab().renderModel(entry.getValue().getState(), entry.getKey(), (IBlockDisplayReader)shell.getWorld(), testStack, (IVertexBuilder)builder, true, BOTIRenderer.mc.field_71441_e.field_73012_v, (IModelData)EmptyModelData.INSTANCE);
                                }
                            }
                            hasRenderedInLayer = true;
                        }
                    } else if (RenderTypeLookup.canRenderInLayer((FluidState)entry.getValue().getFluidState(), (RenderType)type)) {
                        Object fluidVertexBuilder = builder;
                        if (!builder.func_227834_j_()) {
                            builder.func_181668_a(7, BOTIRenderer.BOTI_VBO.format);
                        }
                        TranslatingVertexBuilder translatingBuilder = new TranslatingVertexBuilder((IVertexBuilder)fluidVertexBuilder);
                        translatingBuilder.offset = new Vector3d((double)((int)Helper.getChunkOffset(entry.getKey().func_177958_n(), 16.0f) * 16), (double)((int)Helper.getChunkOffset(entry.getKey().func_177956_o(), 16.0f) * 16), (double)((int)Helper.getChunkOffset(entry.getKey().func_177952_p(), 16.0f) * 16));
                        fluidVertexBuilder = translatingBuilder;
                        if (Helper.canRenderInBOTI(entry.getValue().getState())) {
                            mc.func_175602_ab().func_228794_a_(entry.getKey(), (IBlockDisplayReader)shell.getWorld(), (IVertexBuilder)fluidVertexBuilder, entry.getValue().getFluidState());
                        }
                        hasRenderedInLayer = true;
                    }
                    testStack.func_227865_b_();
                }
                if (hasRenderedInLayer) {
                    BOTI_VBO.upload((RenderType)type);
                }
                BOTI_VBO.unbind((RenderType)type);
                type.func_228549_b_();
            }
        } else {
            matrixStack.func_227860_a_();
            Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
            BOTI_VBO.draw(matrix);
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227861_a_((double)offset.func_177958_n(), (double)offset.func_177956_o(), (double)offset.func_177952_p());
        IRenderTypeBuffer.Impl entityRenderer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)ENTITY_BUFFER);
        for (EntityStorage e : shell.getEntities()) {
            Entity entity = e.getOrCreateEntity((World)shell.getWorld());
            if (entity == null || !Helper.canRenderInBOTI(entity)) continue;
            matrixStack.func_227860_a_();
            Vector3d pos = e.createPosVec().func_178786_a((double)offset.func_177958_n(), (double)offset.func_177956_o(), (double)offset.func_177952_p());
            matrixStack.func_227861_a_(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(e.yaw));
            if (e instanceof PlayerEntityStorage) {
                BOTIRenderer.renderPlayer((AbstractClientPlayerEntity)entity, matrixStack, (IRenderTypeBuffer)entityRenderer, shell);
            } else {
                EntityRenderer renderer = mc.func_175598_ae().func_78713_a(entity);
                if (renderer != null) {
                    try {
                        renderer.func_225623_a_(entity, entity.func_70079_am(), 0.0f, matrixStack, (IRenderTypeBuffer)entityRenderer, LightTexture.func_228451_a_((int)shell.func_217298_h(entity.func_233580_cy_()), (int)15));
                    }
                    catch (Exception error) {
                        error.printStackTrace();
                    }
                }
            }
            matrixStack.func_227865_b_();
        }
        entityRenderer.func_228461_a_();
        matrixStack.func_227861_a_((double)(-offset.func_177958_n()), (double)(-offset.func_177956_o()), (double)(-offset.func_177952_p()));
        IRenderTypeBuffer.Impl tileRenderer = BOTI_TILE_BUFFERS.getBufferSource();
        for (Map.Entry<BlockPos, TileEntity> entry : shell.getTiles().entrySet()) {
            if (!Helper.canRenderInBOTI(entry.getValue().func_195044_w())) continue;
            if (entry.getValue().func_200662_C() == null || !entry.getValue().func_200662_C().func_223045_a(shell.getWorld().func_180495_p(entry.getKey()).func_177230_c())) {
                entry.getValue().func_226984_a_((World)shell.getWorld(), entry.getKey());
                entry.getValue().func_145836_u();
                continue;
            }
            try {
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_((double)entry.getKey().func_177958_n(), (double)entry.getKey().func_177956_o(), (double)entry.getKey().func_177952_p());
                int light = combinedLight;
                if (shell.getBlockMap().containsKey(entry.getKey())) {
                    light = LightTexture.func_228451_a_((int)shell.getWorld().func_226658_a_(LightType.BLOCK, entry.getKey()), (int)shell.getWorld().func_226658_a_(LightType.SKY, entry.getKey()));
                }
                BOTIRenderer.renderTile(entry.getValue(), partialTicks, matrixStack, (IRenderTypeBuffer)tileRenderer, light, combinedOverlay);
                matrixStack.func_227865_b_();
            }
            catch (Exception e) {
                matrixStack.func_227861_a_((double)entry.getKey().func_177958_n(), (double)entry.getKey().func_177956_o(), (double)entry.getKey().func_177952_p());
                Tardis.LOGGER.catching(Level.DEBUG, (Throwable)e);
            }
        }
        tileRenderer.func_228461_a_();
        matrixStack.func_227861_a_((double)offset.func_177958_n(), (double)offset.func_177956_o(), (double)offset.func_177952_p());
        matrixStack.func_227865_b_();
    }

    public static <T extends AbstractClientPlayerEntity> void renderPlayer(T player, MatrixStack matrix, IRenderTypeBuffer buffer, WorldShell shell) {
        try {
            EntityRenderer renderer = mc.func_175598_ae().func_78713_a(player);
            if (renderer != null) {
                renderer.func_225623_a_(player, player.func_70079_am(), 0.0f, matrix, buffer, LightTexture.func_228451_a_((int)shell.func_217298_h(player.func_233580_cy_()), (int)15));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static <T extends TileEntity> void renderTile(T te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        TileEntityRenderer render = TileEntityRendererDispatcher.field_147556_a.func_147547_b(te);
        if (render != null) {
            render.func_225616_a_(te, partialTicks, matrixStack, buffer, combinedLight, combinedOverlay);
        }
    }

    static {
        mc = Minecraft.func_71410_x();
        ENTITY_BUFFER = new BufferBuilder(DefaultVertexFormats.field_227849_i_.func_181719_f());
        RENDERING_BOTI = false;
    }
}

