/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.models.interiordoors;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.client.models.interiordoors.AbstractInteriorDoorModel;
import net.tardis.mod.client.renderers.boti.BOTIRenderer;
import net.tardis.mod.client.renderers.boti.PortalInfo;
import net.tardis.mod.client.renderers.entity.DoorRenderer;
import net.tardis.mod.entity.DoorEntity;
import net.tardis.mod.enums.EnumDoorState;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.misc.IDoorType;
import net.tardis.mod.tileentities.ConsoleTile;

public class TelephoneInteriorModel
extends AbstractInteriorDoorModel {
    public static final ResourceLocation TEXTURE = new ResourceLocation("tardis", "textures/exteriors/interior/telephone_red.png");
    private final ModelRenderer BOTI;
    private final ModelRenderer door;
    private final ModelRenderer bone2;
    private final ModelRenderer bone;
    private final ModelRenderer bone3;
    private final ModelRenderer bone4;
    private final ModelRenderer bb_main;

    public TelephoneInteriorModel() {
        this.field_78090_t = 128;
        this.field_78089_u = 128;
        this.BOTI = new ModelRenderer((Model)this);
        this.BOTI.func_78793_a(-3.0f, 57.0f, -2.0f);
        this.BOTI.func_78784_a(32, 32).func_228303_a_(-4.0f, -66.0f, 6.5f, 14.0f, 33.0f, 1.0f, 0.0f, false);
        this.door = new ModelRenderer((Model)this);
        this.door.func_78793_a(-7.0f, 7.5f, 6.0f);
        this.door.func_78784_a(0, 39).func_228303_a_(0.0f, -16.5f, 0.0f, 14.0f, 33.0f, 1.0f, 0.0f, false);
        this.door.func_78784_a(32, 15).func_228303_a_(0.0f, -10.5f, -1.0f, 1.0f, 4.0f, 1.0f, 0.0f, false);
        this.door.func_78784_a(32, 15).func_228303_a_(0.0f, 6.5f, -1.0f, 1.0f, 4.0f, 1.0f, 0.0f, false);
        this.door.func_78784_a(32, 0).func_228303_a_(0.0f, 10.5f, -0.5f, 14.0f, 6.0f, 1.0f, 0.0f, false);
        this.door.func_78784_a(32, 11).func_228303_a_(11.0f, -4.0f, -1.0f, 2.0f, 3.0f, 1.0f, 0.0f, false);
        this.bone2 = new ModelRenderer((Model)this);
        this.bone2.func_78793_a(0.0f, 24.0f, 0.0f);
        this.bone2.func_78784_a(62, 62).func_228303_a_(7.0f, -39.0f, 6.5f, 2.0f, 39.0f, 2.0f, 0.0f, false);
        this.bone2.func_78784_a(59, 59).func_228303_a_(-9.0f, 0.025f, 5.5f, 18.0f, 0.0f, 3.0f, 0.0f, false);
        this.bone2.func_78784_a(50, 66).func_228303_a_(7.0f, -35.0f, 5.5f, 1.0f, 35.0f, 1.0f, 0.0f, false);
        this.bone = new ModelRenderer((Model)this);
        this.bone.func_78793_a(8.0f, -20.0f, -9.0f);
        this.bone2.func_78792_a(this.bone);
        this.setRotationAngle(this.bone, 0.0f, -0.7854f, 0.0f);
        this.bone.func_78784_a(42, 66).func_228303_a_(10.253f, -19.0f, 10.253f, 1.0f, 39.0f, 1.0f, 0.0f, false);
        this.bone.func_78784_a(42, 66).func_228303_a_(10.6673f, -19.0f, 10.253f, 1.0f, 39.0f, 1.0f, 0.0f, false);
        this.bone3 = new ModelRenderer((Model)this);
        this.bone3.func_78793_a(0.0f, 24.0f, 0.0f);
        this.bone3.func_78784_a(62, 62).func_228303_a_(-9.0f, -39.0f, 6.5f, 2.0f, 39.0f, 2.0f, 0.0f, false);
        this.bone3.func_78784_a(46, 66).func_228303_a_(-8.0f, -35.0f, 5.5f, 1.0f, 35.0f, 1.0f, 0.0f, false);
        this.bone4 = new ModelRenderer((Model)this);
        this.bone4.func_78793_a(-8.0f, -20.0f, -9.0f);
        this.bone3.func_78792_a(this.bone4);
        this.setRotationAngle(this.bone4, 0.0f, 0.7854f, 0.0f);
        this.bone4.func_78784_a(34, 66).func_228303_a_(-11.253f, -19.0f, 10.253f, 1.0f, 39.0f, 1.0f, 0.0f, false);
        this.bone4.func_78784_a(34, 66).func_228303_a_(-11.6673f, -19.0f, 10.253f, 1.0f, 39.0f, 1.0f, 0.0f, false);
        this.bb_main = new ModelRenderer((Model)this);
        this.bb_main.func_78793_a(0.0f, 24.0f, 0.0f);
        this.bb_main.func_78784_a(62, 48).func_228303_a_(-7.0f, -35.0f, 5.5f, 14.0f, 2.0f, 2.0f, 0.0f, false);
        this.bb_main.func_78784_a(62, 41).func_228303_a_(-8.0f, -39.0f, 5.5f, 16.0f, 4.0f, 3.0f, 0.0f, false);
        this.bb_main.func_78784_a(32, 7).func_228303_a_(-6.0f, -38.25f, 5.0f, 12.0f, 3.0f, 1.0f, 0.0f, false);
    }

    public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }

    @Override
    public void renderBones(DoorEntity door, MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, -0.9);
        this.door.field_78796_g = (float)Math.toRadians(IDoorType.EnumDoorType.TELEPHONE.getRotationForState(door.getOpenState()));
        this.renderDoorWhenClosed(door, matrixStack, buffer, packedLight, packedOverlay, this.door);
        this.bone2.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        this.bone3.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        this.bb_main.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        matrixStack.func_227865_b_();
    }

    @Override
    public void renderBoti(DoorEntity door, MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay) {
        if (Minecraft.func_71410_x().field_71441_e != null && door.getOpenState() != EnumDoorState.CLOSED) {
            Minecraft.func_71410_x().field_71441_e.getCapability(Capabilities.TARDIS_DATA).ifPresent(data -> {
                PortalInfo info = new PortalInfo();
                info.setPosition(door.func_213303_ch());
                info.setWorldShell(data.getBotiWorld());
                info.setTranslate(matrix -> {
                    DoorRenderer.applyTranslations(matrix, door);
                    matrix.func_227861_a_(0.0, 0.0, -0.9);
                });
                info.setTranslatePortal(matrix -> {
                    matrix.func_227863_a_(Vector3f.field_229182_e_.func_229187_a_(180.0f));
                    matrix.func_227861_a_(0.5, -1.5625, 0.3);
                    matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(WorldHelper.getAngleFromFacing(data.getBotiWorld().getPortalDirection())));
                });
                info.setRenderPortal((matrix, buf) -> {
                    matrix.func_227860_a_();
                    this.BOTI.func_228308_a_(matrix, buf.getBuffer(RenderType.func_228638_b_((ResourceLocation)this.getTexture())), packedLight, packedLight);
                    matrix.func_227865_b_();
                });
                info.setRenderDoor((matrix, buf) -> {
                    matrix.func_227860_a_();
                    this.door.func_228308_a_(matrix, buf.getBuffer(RenderType.func_228638_b_((ResourceLocation)this.getTexture())), packedLight, packedOverlay);
                    matrix.func_227865_b_();
                });
                BOTIRenderer.addPortal(info);
            });
        }
    }

    @Override
    public ResourceLocation getTexture() {
        ConsoleTile tile = TardisHelper.getConsoleInWorld((World)Minecraft.func_71410_x().field_71441_e).orElse(null);
        if (tile != null) {
            int index = tile.getExteriorManager().getExteriorVariant();
            if (tile.getExteriorType().getVariants() != null && index < tile.getExteriorType().getVariants().length) {
                return tile.getExteriorType().getVariants()[index].getInteriorDoorTexture();
            }
        }
        return TEXTURE;
    }

    @Override
    public boolean doesDoorOpenIntoBotiWindow() {
        return true;
    }
}

