/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.models.interiordoors;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.client.models.interiordoors.AbstractInteriorDoorModel;
import net.tardis.mod.client.renderers.boti.BOTIRenderer;
import net.tardis.mod.client.renderers.boti.PortalInfo;
import net.tardis.mod.client.renderers.entity.DoorRenderer;
import net.tardis.mod.entity.DoorEntity;
import net.tardis.mod.enums.EnumDoorState;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.misc.IDoorType;

public class TTCapsuleInteriorModel
extends AbstractInteriorDoorModel {
    public static final ResourceLocation TEXTURE = new ResourceLocation("tardis", "textures/exteriors/interior/tt_capsule.png");
    private final ModelRenderer boti;
    private final ModelRenderer bb_main;
    private final ModelRenderer frame;
    private final ModelRenderer roof;
    private final ModelRenderer walls;
    private final ModelRenderer bone22;
    private final ModelRenderer bone8;
    private final ModelRenderer bone7;
    private final ModelRenderer left_door_rotate_90;
    private final ModelRenderer right_door_rotate_90;

    public TTCapsuleInteriorModel() {
        this.field_78090_t = 128;
        this.field_78089_u = 128;
        this.boti = new ModelRenderer((Model)this);
        this.boti.func_78793_a(0.0f, 24.0f, 0.0f);
        this.boti.func_78784_a(0, 0).func_228303_a_(-9.0f, -32.0f, 7.0f, 18.0f, 32.0f, 1.0f, 0.0f, false);
        this.bb_main = new ModelRenderer((Model)this);
        this.bb_main.func_78793_a(0.0f, 24.0f, 11.5f);
        this.frame = new ModelRenderer((Model)this);
        this.frame.func_78793_a(0.0f, 3.0f, 0.0f);
        this.bb_main.func_78792_a(this.frame);
        this.roof = new ModelRenderer((Model)this);
        this.roof.func_78793_a(0.0f, -32.0f, 0.0f);
        this.frame.func_78792_a(this.roof);
        this.roof.func_78784_a(0, 33).func_228303_a_(-9.0f, -8.0f, -6.5f, 18.0f, 5.0f, 3.0f, 0.0f, false);
        this.walls = new ModelRenderer((Model)this);
        this.walls.func_78793_a(0.0f, 0.0f, 0.0f);
        this.frame.func_78792_a(this.walls);
        this.bone22 = new ModelRenderer((Model)this);
        this.bone22.func_78793_a(3.0f, -3.0f, 9.0f);
        this.walls.func_78792_a(this.bone22);
        this.bone8 = new ModelRenderer((Model)this);
        this.bone8.func_78793_a(-3.0f, 0.0f, -9.0f);
        this.bone22.func_78792_a(this.bone8);
        this.setRotationAngle(this.bone8, 0.0f, -1.5708f, 0.0f);
        this.bone8.func_78784_a(16, 41).func_228303_a_(-6.5f, -32.0f, 7.0f, 2.0f, 32.0f, 2.0f, 0.0f, false);
        this.bone7 = new ModelRenderer((Model)this);
        this.bone7.func_78793_a(-3.0f, 0.0f, -9.0f);
        this.bone22.func_78792_a(this.bone7);
        this.setRotationAngle(this.bone7, 0.0f, 1.5708f, 0.0f);
        this.bone7.func_78784_a(40, 40).func_228303_a_(4.5f, -32.0f, 7.0f, 2.0f, 32.0f, 2.0f, 0.0f, false);
        this.left_door_rotate_90 = new ModelRenderer((Model)this);
        this.left_door_rotate_90.func_78793_a(7.0f, -14.5f, -5.0f);
        this.bb_main.func_78792_a(this.left_door_rotate_90);
        this.left_door_rotate_90.func_78784_a(0, 41).func_228303_a_(-7.0f, -17.5f, -0.525f, 7.0f, 32.0f, 1.0f, 0.0f, false);
        this.right_door_rotate_90 = new ModelRenderer((Model)this);
        this.right_door_rotate_90.func_78793_a(-7.0f, -14.5f, -5.0f);
        this.bb_main.func_78792_a(this.right_door_rotate_90);
        this.right_door_rotate_90.func_78784_a(38, 0).func_228303_a_(0.0f, -17.5f, -0.525f, 7.0f, 32.0f, 1.0f, 0.0f, false);
    }

    public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }

    @Override
    public void renderBones(DoorEntity door, MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay) {
        matrixStack.func_227860_a_();
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        matrixStack.func_227861_a_(0.0, 0.0, 0.12);
        this.right_door_rotate_90.field_78796_g = 0.0f;
        this.left_door_rotate_90.field_78796_g = 0.0f;
        float rot = -((float)Math.toRadians(IDoorType.EnumDoorType.TT_CAPSULE.getRotationForState(door.getOpenState())));
        if (door.getOpenState() == EnumDoorState.ONE) {
            this.right_door_rotate_90.field_78796_g = 0.0f;
            this.left_door_rotate_90.field_78796_g = rot;
        } else {
            this.left_door_rotate_90.field_78796_g = rot;
            this.right_door_rotate_90.field_78796_g = -rot;
        }
        this.bb_main.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        matrixStack.func_227865_b_();
    }

    @Override
    public void renderBoti(DoorEntity door, MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay) {
        if (Minecraft.func_71410_x().field_71441_e != null && door.getOpenState() != EnumDoorState.CLOSED) {
            Minecraft.func_71410_x().field_71441_e.getCapability(Capabilities.TARDIS_DATA).ifPresent(data -> {
                matrixStack.func_227860_a_();
                PortalInfo info = new PortalInfo();
                info.setPosition(door.func_213303_ch());
                info.setWorldShell(data.getBotiWorld());
                info.setTranslate(matrix -> DoorRenderer.applyTranslations(matrix, door.field_70177_z - 180.0f, door.func_174811_aO()));
                info.setTranslatePortal(matrix -> {
                    matrix.func_227863_a_(Vector3f.field_229182_e_.func_229187_a_(180.0f));
                    matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(WorldHelper.getAngleFromFacing(data.getBotiWorld().getPortalDirection())));
                    matrix.func_227861_a_(-0.5, -1.4375, -0.5);
                });
                info.setRenderPortal((matrix, impl) -> {
                    matrix.func_227860_a_();
                    matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                    matrix.func_227861_a_(0.0, 0.0, 0.12);
                    this.boti.func_228308_a_(matrix, impl.getBuffer(RenderType.func_228638_b_((ResourceLocation)this.getTexture())), packedLight, packedOverlay);
                    matrix.func_227865_b_();
                });
                BOTIRenderer.addPortal(info);
                matrixStack.func_227865_b_();
            });
        }
    }

    @Override
    public ResourceLocation getTexture() {
        return TEXTURE;
    }
}

