/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.models.interiordoors;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.client.models.interiordoors.AbstractInteriorDoorModel;
import net.tardis.mod.client.renderers.boti.BOTIRenderer;
import net.tardis.mod.client.renderers.boti.PortalInfo;
import net.tardis.mod.client.renderers.entity.DoorRenderer;
import net.tardis.mod.client.renderers.exteriors.SteamExteriorRenderer;
import net.tardis.mod.entity.DoorEntity;
import net.tardis.mod.enums.EnumDoorState;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.misc.IDoorType;
import net.tardis.mod.tileentities.ConsoleTile;

public class SteamInteriorModel
extends AbstractInteriorDoorModel {
    private final ModelRenderer glow_front_window;
    private final ModelRenderer door;
    private final ModelRenderer hinge;
    private final ModelRenderer inner_frame;
    private final ModelRenderer floorboard;
    private final ModelRenderer roof_front;
    private final ModelRenderer peak;
    private final ModelRenderer wroughtiron_front;
    private final ModelRenderer panel_front_top;
    private final ModelRenderer outer_frame;
    private final ModelRenderer boti;

    public SteamInteriorModel() {
        this.field_78090_t = 1024;
        this.field_78089_u = 1024;
        this.glow_front_window = new ModelRenderer((Model)this);
        this.glow_front_window.func_78793_a(0.0f, 23.0556f, 0.4167f);
        this.glow_front_window.func_78784_a(516, 150).func_228303_a_(6.0f, -179.0556f, -18.1667f, 12.0f, 12.0f, 7.0f, 0.0f, false);
        this.glow_front_window.func_78784_a(470, 146).func_228303_a_(-18.0f, -179.0556f, -18.1667f, 12.0f, 12.0f, 7.0f, 0.0f, false);
        this.door = new ModelRenderer((Model)this);
        this.door.func_78793_a(26.5f, -5.0f, -14.5f);
        this.door.func_78784_a(163, 372).func_228303_a_(-50.5f, -3.0f, -2.25f, 48.0f, 20.0f, 4.0f, 0.0f, false);
        this.door.func_78784_a(258, 27).func_228303_a_(-50.5f, -123.0f, -1.25f, 48.0f, 140.0f, 0.0f, 0.0f, false);
        this.door.func_78784_a(150, 269).func_228303_a_(-50.5f, -123.0f, -2.25f, 48.0f, 8.0f, 4.0f, 0.0f, false);
        this.door.func_78784_a(150, 269).func_228303_a_(-10.5f, -115.0f, -2.25f, 8.0f, 112.0f, 4.0f, 0.0f, false);
        this.door.func_78784_a(150, 269).func_228303_a_(-50.5f, -115.0f, -2.25f, 8.0f, 112.0f, 4.0f, 0.0f, false);
        this.door.func_78784_a(150, 269).func_228303_a_(-40.5f, -113.0f, -2.25f, 28.0f, 4.0f, 4.0f, 0.0f, false);
        this.door.func_78784_a(151, 370).func_228303_a_(-40.5f, -13.0f, -2.25f, 28.0f, 8.0f, 4.0f, 0.0f, false);
        this.door.func_78784_a(148, 283).func_228303_a_(-40.5f, -109.0f, -2.25f, 4.0f, 96.0f, 4.0f, 0.0f, false);
        this.door.func_78784_a(171, 289).func_228303_a_(-16.5f, -109.0f, -2.25f, 4.0f, 96.0f, 4.0f, 0.0f, false);
        this.door.func_78784_a(253, 291).func_228303_a_(-34.5f, -107.0f, -2.25f, 16.0f, 92.0f, 4.0f, 0.0f, false);
        this.door.func_78784_a(489, 45).func_228303_a_(-48.5f, -1.0f, -3.25f, 44.0f, 16.0f, 4.0f, 0.0f, false);
        this.door.func_78784_a(498, 41).func_228303_a_(-48.5f, -68.0f, -4.25f, 4.0f, 16.0f, 8.0f, 0.0f, false);
        this.hinge = new ModelRenderer((Model)this);
        this.hinge.func_78793_a(-0.6532f, -56.6667f, 1.1099f);
        this.door.func_78792_a(this.hinge);
        this.setRotationAngle(this.hinge, 0.0f, 0.7854f, 0.0f);
        this.hinge.func_78784_a(521, 45).func_228303_a_(-2.0f, -59.3333f, -2.0f, 4.0f, 12.0f, 4.0f, 0.0f, false);
        this.hinge.func_78784_a(521, 45).func_228303_a_(-2.0f, -11.3333f, -2.0f, 4.0f, 12.0f, 4.0f, 0.0f, false);
        this.hinge.func_78784_a(521, 45).func_228303_a_(-2.0f, 52.6667f, -2.0f, 4.0f, 12.0f, 4.0f, 0.0f, false);
        this.inner_frame = new ModelRenderer((Model)this);
        this.inner_frame.func_78793_a(0.0f, 23.0556f, 0.4167f);
        this.inner_frame.func_78784_a(144, 391).func_228303_a_(-32.0f, -11.0556f, -18.1667f, 64.0f, 8.0f, 4.0f, 0.0f, false);
        this.inner_frame.func_78784_a(143, 207).func_228303_a_(-32.0f, -183.0556f, -18.1667f, 8.0f, 172.0f, 4.0f, 0.0f, false);
        this.inner_frame.func_78784_a(234, 212).func_228303_a_(24.0f, -183.0556f, -18.1667f, 8.0f, 172.0f, 4.0f, 0.0f, false);
        this.inner_frame.func_78784_a(146, 265).func_228303_a_(-32.0f, -191.0556f, -18.1667f, 64.0f, 8.0f, 4.0f, 0.0f, false);
        this.inner_frame.func_78784_a(150, 273).func_228303_a_(-24.0f, -163.0556f, -18.1667f, 48.0f, 12.0f, 4.0f, 0.0f, false);
        this.inner_frame.func_78784_a(151, 282).func_228303_a_(-32.0f, -191.0556f, -20.1667f, 64.0f, 4.0f, 8.0f, 0.0f, false);
        this.inner_frame.func_78784_a(459, 41).func_228303_a_(-20.0f, -161.0556f, -17.1667f, 40.0f, 8.0f, 4.0f, 0.0f, false);
        this.inner_frame.func_78784_a(185, 215).func_228303_a_(-29.0f, -187.0556f, -17.1667f, 4.0f, 184.0f, 4.0f, 0.0f, false);
        this.inner_frame.func_78784_a(269, 215).func_228303_a_(25.0f, -187.0556f, -17.1667f, 4.0f, 184.0f, 4.0f, 0.0f, false);
        this.inner_frame.func_78784_a(144, 211).func_228303_a_(-32.0f, -187.0556f, -20.1667f, 4.0f, 184.0f, 8.0f, 0.0f, false);
        this.inner_frame.func_78784_a(279, 213).func_228303_a_(28.0f, -187.0556f, -20.1667f, 4.0f, 184.0f, 8.0f, 0.0f, false);
        this.inner_frame.func_78784_a(143, 280).func_228303_a_(-28.0f, -159.0556f, -20.1667f, 56.0f, 4.0f, 4.0f, 0.0f, false);
        this.floorboard = new ModelRenderer((Model)this);
        this.floorboard.func_78793_a(0.0f, 0.0f, 0.0f);
        this.inner_frame.func_78792_a(this.floorboard);
        this.floorboard.func_78784_a(238, 389).func_228303_a_(-32.0f, -3.0556f, -25.1667f, 64.0f, 4.0f, 16.0f, 0.0f, false);
        this.roof_front = new ModelRenderer((Model)this);
        this.roof_front.func_78793_a(0.0f, -47.0f, -12.0f);
        this.inner_frame.func_78792_a(this.roof_front);
        this.peak = new ModelRenderer((Model)this);
        this.peak.func_78793_a(0.0f, 0.0f, 4.0f);
        this.roof_front.func_78792_a(this.peak);
        this.wroughtiron_front = new ModelRenderer((Model)this);
        this.wroughtiron_front.func_78793_a(0.0f, 47.9444f, 11.5833f);
        this.roof_front.func_78792_a(this.wroughtiron_front);
        this.panel_front_top = new ModelRenderer((Model)this);
        this.panel_front_top.func_78793_a(0.0f, 0.0f, 0.0f);
        this.inner_frame.func_78792_a(this.panel_front_top);
        this.panel_front_top.func_78784_a(78, 223).func_228303_a_(-24.0f, -183.0556f, -17.1667f, 48.0f, 20.0f, 4.0f, 0.0f, false);
        this.outer_frame = new ModelRenderer((Model)this);
        this.outer_frame.func_78793_a(0.0f, 24.0f, 0.0f);
        this.outer_frame.func_78784_a(64, 205).func_228303_a_(-40.0f, -192.0f, -17.75f, 8.0f, 192.0f, 12.0f, 0.0f, false);
        this.outer_frame.func_78784_a(45, 205).func_228303_a_(32.0f, -192.0f, -17.75f, 8.0f, 192.0f, 12.0f, 0.0f, false);
        this.outer_frame.func_78784_a(91, 256).func_228303_a_(-40.0f, -200.0f, -17.75f, 80.0f, 8.0f, 12.0f, 0.0f, false);
        this.boti = new ModelRenderer((Model)this);
        this.boti.func_78793_a(0.0f, 24.0f, 0.0f);
        this.boti.func_78784_a(12, 14).func_228303_a_(-36.0f, -164.0f, -23.75f, 72.0f, 160.0f, 8.0f, 0.0f, false);
    }

    public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }

    @Override
    public void renderBones(DoorEntity door, MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay) {
        matrixStack.func_227860_a_();
        this.translateModel(matrixStack);
        this.door.field_78796_g = (float)Math.toRadians(IDoorType.EnumDoorType.STEAM.getRotationForState(door.getOpenState()));
        this.glow_front_window.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        this.door.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        this.inner_frame.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        this.outer_frame.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        matrixStack.func_227865_b_();
    }

    @Override
    public void renderBoti(DoorEntity door, MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay) {
        if (Minecraft.func_71410_x().field_71441_e != null && door.getOpenState() != EnumDoorState.CLOSED) {
            Minecraft.func_71410_x().field_71441_e.getCapability(Capabilities.TARDIS_DATA).ifPresent(data -> {
                PortalInfo info = new PortalInfo();
                info.setPosition(door.func_213303_ch());
                info.setWorldShell(data.getBotiWorld());
                info.setTranslate(matrix -> DoorRenderer.applyTranslations(matrix, door));
                info.setTranslatePortal(matrix -> {
                    matrix.func_227861_a_(0.0, 1.25, 0.1);
                    matrix.func_227863_a_(Vector3f.field_229182_e_.func_229187_a_(180.0f));
                    matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(WorldHelper.getAngleFromFacing(data.getBotiWorld().getPortalDirection())));
                    matrix.func_227861_a_(-0.5, 0.0, -0.5);
                });
                info.setRenderPortal((matrix, buf) -> {
                    matrix.func_227860_a_();
                    this.translateModel((MatrixStack)matrix);
                    matrix.func_227861_a_(0.0, 0.0, -0.03);
                    this.boti.func_228308_a_(matrix, buf.getBuffer(RenderType.func_228638_b_((ResourceLocation)this.getTexture())), packedLight, packedOverlay);
                    matrix.func_227865_b_();
                });
                BOTIRenderer.addPortal(info);
            });
        }
    }

    @Override
    public ResourceLocation getTexture() {
        ConsoleTile tile = TardisHelper.getConsoleInWorld((World)Minecraft.func_71410_x().field_71441_e).orElse(null);
        if (tile != null) {
            int index = tile.getExteriorManager().getExteriorVariant();
            if (tile.getExteriorType().getVariants() != null && index < tile.getExteriorType().getVariants().length) {
                return tile.getExteriorType().getVariants()[index].getTexture();
            }
        }
        return SteamExteriorRenderer.TEXTURE;
    }

    public void translateModel(MatrixStack stack) {
        stack.func_227861_a_(0.0, 1.12, -0.2);
        stack.func_227862_a_(0.25f, 0.25f, 0.25f);
    }
}

