/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.models.interiordoors;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.client.TRenderTypes;
import net.tardis.mod.client.models.interiordoors.AbstractInteriorDoorModel;
import net.tardis.mod.client.renderers.boti.BOTIRenderer;
import net.tardis.mod.client.renderers.boti.PortalInfo;
import net.tardis.mod.client.renderers.entity.DoorRenderer;
import net.tardis.mod.entity.DoorEntity;
import net.tardis.mod.enums.EnumDoorState;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.misc.IDoorType;

public class SafeInteriorModel
extends AbstractInteriorDoorModel {
    public static final ResourceLocation TEXTURE = new ResourceLocation("tardis", "textures/exteriors/interior/safe.png");
    private final ModelRenderer door;
    private final ModelRenderer bb_main;
    private final ModelRenderer boti;

    public SafeInteriorModel() {
        this.field_78090_t = 128;
        this.field_78089_u = 128;
        this.door = new ModelRenderer((Model)this);
        this.door.func_78793_a(-7.0f, 8.0f, 6.0f);
        this.door.func_78784_a(30, 35).func_228303_a_(0.0f, -16.0f, -0.05f, 14.0f, 32.0f, 1.0f, 0.0f, false);
        this.door.func_78784_a(36, 14).func_228303_a_(-0.5f, -14.0f, -1.075f, 2.0f, 6.0f, 2.0f, 0.0f, false);
        this.door.func_78784_a(36, 14).func_228303_a_(-0.5f, 8.0f, -1.075f, 2.0f, 6.0f, 2.0f, 0.0f, false);
        this.door.func_78784_a(36, 30).func_228303_a_(5.0f, -9.0f, -0.55f, 1.0f, 4.0f, 1.0f, 0.0f, false);
        this.door.func_78784_a(36, 30).func_228303_a_(5.0f, 5.0f, -0.55f, 1.0f, 4.0f, 1.0f, 0.0f, false);
        this.door.func_78784_a(36, 8).func_228303_a_(6.5f, -2.5f, -0.55f, 5.0f, 5.0f, 1.0f, 0.0f, false);
        this.door.func_78784_a(36, 4).func_228303_a_(0.0f, -8.5f, -0.075f, 14.0f, 3.0f, 1.0f, 0.0f, false);
        this.door.func_78784_a(36, 4).func_228303_a_(0.0f, 5.5f, -0.075f, 14.0f, 3.0f, 1.0f, 0.0f, false);
        this.boti = new ModelRenderer((Model)this);
        this.boti.func_78793_a(0.0f, 24.0f, 0.0f);
        this.boti.func_78784_a(0, 35).func_228303_a_(-7.0f, -32.0f, 6.975f, 14.0f, 32.0f, 1.0f, 0.0f, false);
        this.bb_main = new ModelRenderer((Model)this);
        this.bb_main.func_78793_a(0.0f, 24.0f, 0.0f);
        this.bb_main.func_78784_a(0, 0).func_228303_a_(-8.0f, -33.0f, 6.0f, 16.0f, 33.0f, 2.0f, 0.0f, false);
    }

    @Override
    public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
    }

    public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }

    @Override
    public void renderBones(DoorEntity door, MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay) {
        matrixStack.func_227860_a_();
        RenderSystem.disableCull();
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        matrixStack.func_227861_a_(0.0, 0.0, 0.085);
        this.door.field_78796_g = (float)Math.toRadians(IDoorType.EnumDoorType.SAFE.getRotationForState(door.getOpenState()));
        this.door.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        this.bb_main.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        RenderSystem.enableCull();
        matrixStack.func_227865_b_();
    }

    @Override
    public void renderBoti(DoorEntity door, MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay) {
        if (Minecraft.func_71410_x().field_71441_e != null && door.getOpenState() != EnumDoorState.CLOSED) {
            Minecraft.func_71410_x().field_71441_e.getCapability(Capabilities.TARDIS_DATA).ifPresent(data -> {
                PortalInfo info = new PortalInfo();
                info.setWorldShell(data.getBotiWorld());
                info.setPosition(door.func_213303_ch());
                info.setTranslate(matrix -> {
                    DoorRenderer.applyTranslations(matrix, door.field_70177_z - 180.0f, door.func_174811_aO());
                    matrix.func_227861_a_(0.0, 1.0, -1.05);
                    matrix.func_227863_a_(Vector3f.field_229182_e_.func_229187_a_(180.0f));
                });
                info.setTranslatePortal(matrix -> {
                    matrix.func_227861_a_(0.0, -0.75, 1.0);
                    matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(WorldHelper.getAngleFromFacing(data.getBotiWorld().getPortalDirection())));
                    matrix.func_227861_a_(-0.5, 0.0, -0.5);
                });
                info.setRenderPortal((matrix, buf) -> {
                    matrix.func_227860_a_();
                    this.boti.func_228308_a_(matrix, buf.getBuffer(TRenderTypes.getTardis(this.getTexture())), packedLight, packedOverlay);
                    matrix.func_227865_b_();
                });
                info.setRenderDoor((matrix, buf) -> {
                    matrix.func_227860_a_();
                    matrix.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
                    matrix.func_227861_a_(0.0, 1.5, 0.0);
                    matrix.func_227862_a_(0.25f, 0.25f, 0.25f);
                    this.door.func_228308_a_(matrix, buf.getBuffer(TRenderTypes.getTardis(this.getTexture())), packedLight, packedOverlay);
                    matrix.func_227865_b_();
                });
                BOTIRenderer.addPortal(info);
            });
        }
    }

    @Override
    public ResourceLocation getTexture() {
        return TEXTURE;
    }

    @Override
    public boolean doesDoorOpenIntoBotiWindow() {
        return true;
    }
}

