/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.models.interiordoors;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.client.models.interiordoors.AbstractInteriorDoorModel;
import net.tardis.mod.client.renderers.boti.BOTIRenderer;
import net.tardis.mod.client.renderers.boti.PortalInfo;
import net.tardis.mod.client.renderers.entity.DoorRenderer;
import net.tardis.mod.entity.DoorEntity;
import net.tardis.mod.enums.EnumDoorState;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.misc.IDoorType;

public class PoliceBoxInteriorModel
extends AbstractInteriorDoorModel {
    public static final ResourceLocation TEXTURE = new ResourceLocation("tardis", "textures/exteriors/police_box.png");
    private final ModelRenderer Newbery;
    private final ModelRenderer CornerPosts;
    private final ModelRenderer UpperSignage;
    private final ModelRenderer Trim;
    private final ModelRenderer RoofStacks;
    private final ModelRenderer Lamp;
    private final ModelRenderer LeftDoor;
    private final ModelRenderer bone4;
    private final ModelRenderer bone5;
    private final ModelRenderer RightDoor;
    private final ModelRenderer bone6;
    private final ModelRenderer boti;

    public PoliceBoxInteriorModel() {
        this.field_78090_t = 512;
        this.field_78089_u = 512;
        this.Newbery = new ModelRenderer((Model)this);
        this.Newbery.func_78793_a(0.0f, 24.0f, 0.0f);
        this.CornerPosts = new ModelRenderer((Model)this);
        this.CornerPosts.func_78793_a(0.0f, 0.0f, 0.0f);
        this.Newbery.func_78792_a(this.CornerPosts);
        this.CornerPosts.func_78784_a(82, 131).func_228303_a_(15.5f, -69.0f, -20.5f, 5.0f, 70.0f, 5.0f, 0.0f, false);
        this.CornerPosts.func_78784_a(82, 131).func_228303_a_(-20.5f, -69.0f, -20.5f, 5.0f, 70.0f, 5.0f, 0.0f, false);
        this.UpperSignage = new ModelRenderer((Model)this);
        this.UpperSignage.func_78793_a(0.0f, 0.0f, 0.0f);
        this.Newbery.func_78792_a(this.UpperSignage);
        this.UpperSignage.func_78784_a(160, 138).func_228303_a_(-18.5f, -66.0f, -22.5f, 37.0f, 4.0f, 4.0f, 0.0f, false);
        this.Trim = new ModelRenderer((Model)this);
        this.Trim.func_78793_a(0.0f, 0.0f, 0.0f);
        this.Newbery.func_78792_a(this.Trim);
        this.Trim.func_78784_a(210, 212).func_228303_a_(14.5f, -61.0f, -18.5f, 4.0f, 62.0f, 2.0f, 0.0f, false);
        this.Trim.func_78784_a(210, 212).func_228303_a_(-18.5f, -61.0f, -18.5f, 4.0f, 62.0f, 2.0f, 0.0f, false);
        this.Trim.func_78784_a(149, 127).func_228303_a_(-18.5f, -62.0f, -18.5f, 37.0f, 1.0f, 2.0f, 0.0f, false);
        this.RoofStacks = new ModelRenderer((Model)this);
        this.RoofStacks.func_78793_a(0.0f, 0.0f, 0.0f);
        this.Newbery.func_78792_a(this.RoofStacks);
        this.RoofStacks.func_78784_a(35, 228).func_228303_a_(-19.5f, -69.0f, -19.5f, 39.0f, 3.0f, 3.0f, 0.0f, false);
        this.Lamp = new ModelRenderer((Model)this);
        this.Lamp.func_78793_a(0.0f, 0.0f, 0.0f);
        this.Newbery.func_78792_a(this.Lamp);
        this.LeftDoor = new ModelRenderer((Model)this);
        this.LeftDoor.func_78793_a(14.5f, -3.0f, -17.5f);
        this.Newbery.func_78792_a(this.LeftDoor);
        this.LeftDoor.func_78784_a(45, 135).func_228303_a_(-12.0f, 2.0f, 0.0f, 10.0f, 2.0f, 2.0f, 0.0f, true);
        this.LeftDoor.func_78784_a(0, 120).func_228303_a_(-12.0f, -13.0f, 0.0f, 10.0f, 2.0f, 2.0f, 0.0f, true);
        this.LeftDoor.func_78784_a(0, 120).func_228303_a_(-12.0f, -28.0f, 0.0f, 10.0f, 2.0f, 2.0f, 0.0f, true);
        this.LeftDoor.func_78784_a(0, 120).func_228303_a_(-12.0f, -43.0f, 0.0f, 10.0f, 2.0f, 2.0f, 0.0f, true);
        this.LeftDoor.func_78784_a(0, 120).func_228303_a_(-12.0f, -58.0f, 0.0f, 10.0f, 2.0f, 2.0f, 0.0f, true);
        this.LeftDoor.func_78784_a(10, 215).func_228303_a_(-15.0f, -58.0f, 0.0f, 3.0f, 62.0f, 2.0f, 0.0f, true);
        this.LeftDoor.func_78784_a(234, 146).func_228303_a_(-15.0f, -58.0f, -1.0f, 1.0f, 62.0f, 1.0f, 0.0f, true);
        this.LeftDoor.func_78784_a(230, 146).func_228303_a_(-15.0f, -58.0f, 2.0f, 1.0f, 62.0f, 1.0f, 0.0f, true);
        this.LeftDoor.func_78784_a(232, 224).func_228303_a_(-2.0f, -58.0f, 0.0f, 2.0f, 62.0f, 2.0f, 0.0f, true);
        this.LeftDoor.func_78784_a(20, 0).func_228303_a_(-12.0f, -26.0f, 1.1f, 10.0f, 28.0f, 0.0f, 0.0f, true);
        this.LeftDoor.func_78784_a(0, 131).func_228303_a_(-12.0f, -26.0f, 0.9f, 10.0f, 28.0f, 0.0f, 0.0f, true);
        this.bone4 = new ModelRenderer((Model)this);
        this.bone4.func_78793_a(-14.5f, -47.0f, 1.0f);
        this.LeftDoor.func_78792_a(this.bone4);
        this.bone4.func_78784_a(0, 106).func_228303_a_(2.5f, -9.0f, 0.0f, 10.0f, 13.0f, 1.0f, 0.0f, true);
        this.bone5 = new ModelRenderer((Model)this);
        this.bone5.func_78793_a(-2.0f, -32.0f, 0.0f);
        this.LeftDoor.func_78792_a(this.bone5);
        this.bone5.func_78784_a(0, 64).func_228303_a_(-10.0f, -9.0f, 0.0f, 10.0f, 13.0f, 1.0f, 0.0f, true);
        this.RightDoor = new ModelRenderer((Model)this);
        this.RightDoor.func_78793_a(-14.5f, -3.0f, -17.5f);
        this.Newbery.func_78792_a(this.RightDoor);
        this.RightDoor.func_78784_a(45, 135).func_228303_a_(2.0f, 2.0f, 0.0f, 10.0f, 2.0f, 2.0f, 0.0f, true);
        this.RightDoor.func_78784_a(0, 120).func_228303_a_(2.0f, -13.0f, 0.0f, 10.0f, 2.0f, 2.0f, 0.0f, true);
        this.RightDoor.func_78784_a(0, 120).func_228303_a_(2.0f, -28.0f, 0.0f, 10.0f, 2.0f, 2.0f, 0.0f, true);
        this.RightDoor.func_78784_a(0, 120).func_228303_a_(2.0f, -43.0f, 0.0f, 10.0f, 2.0f, 2.0f, 0.0f, true);
        this.RightDoor.func_78784_a(0, 120).func_228303_a_(2.0f, -58.0f, 0.0f, 10.0f, 2.0f, 2.0f, 0.0f, true);
        this.RightDoor.func_78784_a(232, 224).func_228303_a_(12.0f, -58.0f, 0.0f, 2.0f, 62.0f, 2.0f, 0.0f, true);
        this.RightDoor.func_78784_a(232, 224).func_228303_a_(0.0f, -58.0f, 0.0f, 2.0f, 62.0f, 2.0f, 0.0f, true);
        this.RightDoor.func_78784_a(0, 0).func_228303_a_(2.0f, -41.0f, 1.1f, 10.0f, 43.0f, 0.0f, 0.0f, true);
        this.RightDoor.func_78784_a(0, 131).func_228303_a_(2.0f, -41.0f, 0.9f, 10.0f, 43.0f, 0.0f, 0.0f, true);
        this.bone6 = new ModelRenderer((Model)this);
        this.bone6.func_78793_a(14.5f, -43.0f, 1.0f);
        this.RightDoor.func_78792_a(this.bone6);
        this.bone6.func_78784_a(0, 106).func_228303_a_(-12.5f, -13.0f, 0.0f, 10.0f, 13.0f, 1.0f, 0.0f, true);
        this.boti = new ModelRenderer((Model)this);
        this.boti.func_78793_a(0.0f, 24.0f, 0.0f);
        this.boti.func_78784_a(0, 297).func_228303_a_(-14.55f, -61.0f, -16.45f, 29.0f, 62.0f, 2.0f, 0.0f, false);
    }

    public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }

    @Override
    public void renderBones(DoorEntity door, MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay) {
        matrixStack.func_227860_a_();
        this.translateToDoor(matrixStack);
        EnumDoorState state = door.getOpenState();
        switch (state) {
            case ONE: {
                this.RightDoor.field_78796_g = (float)Math.toRadians(IDoorType.EnumDoorType.POLICE_BOX.getRotationForState(EnumDoorState.ONE));
                this.LeftDoor.field_78796_g = (float)Math.toRadians(IDoorType.EnumDoorType.POLICE_BOX.getRotationForState(EnumDoorState.CLOSED));
                break;
            }
            case BOTH: {
                this.RightDoor.field_78796_g = (float)Math.toRadians(IDoorType.EnumDoorType.POLICE_BOX.getRotationForState(EnumDoorState.ONE));
                this.LeftDoor.field_78796_g = (float)Math.toRadians(IDoorType.EnumDoorType.POLICE_BOX.getRotationForState(EnumDoorState.BOTH));
                break;
            }
            case CLOSED: {
                this.RightDoor.field_78796_g = (float)Math.toRadians(IDoorType.EnumDoorType.POLICE_BOX.getRotationForState(EnumDoorState.CLOSED));
                this.LeftDoor.field_78796_g = (float)Math.toRadians(IDoorType.EnumDoorType.POLICE_BOX.getRotationForState(EnumDoorState.CLOSED));
                break;
            }
        }
        this.Newbery.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        matrixStack.func_227865_b_();
    }

    @Override
    public void renderBoti(DoorEntity door, MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay) {
        if (Minecraft.func_71410_x().field_71441_e != null && door.getOpenState() != EnumDoorState.CLOSED) {
            Minecraft.func_71410_x().field_71441_e.getCapability(Capabilities.TARDIS_DATA).ifPresent(data -> {
                PortalInfo info = new PortalInfo();
                info.setPosition(door.func_213303_ch());
                info.setWorldShell(data.getBotiWorld());
                info.setTranslate(matrix -> DoorRenderer.applyTranslations(matrix, door));
                info.setTranslatePortal(matrix -> {
                    matrix.func_227861_a_(0.0, 1.5, 0.0);
                    matrix.func_227863_a_(Vector3f.field_229182_e_.func_229187_a_(180.0f));
                    matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(WorldHelper.getAngleFromFacing(data.getBotiWorld().getPortalDirection())));
                    matrix.func_227861_a_(-0.5, 0.0, -0.5);
                });
                info.setRenderPortal((matrix, buf) -> {
                    matrix.func_227860_a_();
                    matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                    matrix.func_227861_a_(0.0, 0.72, 1.05);
                    matrix.func_227862_a_(0.5f, 0.5f, 0.5f);
                    this.boti.func_228308_a_(matrix, buf.getBuffer(RenderType.func_228638_b_((ResourceLocation)this.getTexture())), packedLight, packedOverlay);
                    matrix.func_227865_b_();
                });
                BOTIRenderer.addPortal(info);
            });
        }
    }

    @Override
    public ResourceLocation getTexture() {
        return TEXTURE;
    }

    public void translateToDoor(MatrixStack matrix) {
        matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        matrix.func_227861_a_(0.0, 0.72, 1.05);
        matrix.func_227862_a_(0.5f, 0.5f, 0.5f);
    }
}

