/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.models.interiordoors;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.client.TRenderTypes;
import net.tardis.mod.client.models.interiordoors.AbstractInteriorDoorModel;
import net.tardis.mod.client.renderers.boti.BOTIRenderer;
import net.tardis.mod.client.renderers.boti.PortalInfo;
import net.tardis.mod.client.renderers.entity.DoorRenderer;
import net.tardis.mod.client.renderers.exteriors.JapanExteriorRenderer;
import net.tardis.mod.entity.DoorEntity;
import net.tardis.mod.enums.EnumDoorState;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.misc.IDoorType;

public class JapanInteriorModel
extends AbstractInteriorDoorModel {
    private final ModelRenderer Posts;
    private final ModelRenderer cube_r1;
    private final ModelRenderer Signage;
    private final ModelRenderer panels;
    private final ModelRenderer door;
    private final ModelRenderer boti;

    public JapanInteriorModel() {
        this.field_78090_t = 256;
        this.field_78089_u = 256;
        this.Posts = new ModelRenderer((Model)this);
        this.Posts.func_78793_a(-12.0f, 20.0f, 10.0f);
        this.Posts.func_78784_a(131, 31).func_228303_a_(22.0f, -37.0f, -18.0f, 3.0f, 41.0f, 3.0f, 0.0f, false);
        this.cube_r1 = new ModelRenderer((Model)this);
        this.cube_r1.func_78793_a(12.0f, 4.0f, -5.0f);
        this.Posts.func_78792_a(this.cube_r1);
        this.setRotationAngle(this.cube_r1, 0.0f, 1.5708f, 0.0f);
        this.cube_r1.func_78784_a(131, 31).func_228303_a_(10.0f, -41.0f, -13.0f, 3.0f, 41.0f, 3.0f, 0.0f, false);
        this.Signage = new ModelRenderer((Model)this);
        this.Signage.func_78793_a(14.0f, -18.0f, -14.0f);
        this.Signage.func_78784_a(32, 78).func_228303_a_(-26.0f, 3.0f, 5.0f, 24.0f, 4.0f, 3.0f, 0.0f, false);
        this.panels = new ModelRenderer((Model)this);
        this.panels.func_78793_a(9.0f, 20.0f, -12.0f);
        this.panels.func_78784_a(118, 87).func_228303_a_(-19.0f, -31.0f, 5.0f, 10.0f, 35.0f, 1.0f, 0.0f, false);
        this.door = new ModelRenderer((Model)this);
        this.door.func_78793_a(0.0f, 20.0f, 10.0f);
        this.door.func_78784_a(96, 87).func_228303_a_(0.0f, -31.0f, -16.0f, 10.0f, 35.0f, 1.0f, 0.0f, false);
        this.boti = new ModelRenderer((Model)this);
        this.boti.func_78793_a(0.0f, 24.0f, 0.0f);
        this.boti.func_78784_a(209, 35).func_228303_a_(-11.0f, -35.0f, -9.0f, 22.0f, 35.0f, 1.0f, 0.0f, false);
    }

    public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }

    @Override
    public void renderBones(DoorEntity door, MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay) {
        matrixStack.func_227860_a_();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(IDoorType.EnumDoorType.JAPAN.getRotationForState(door.getOpenState()), 0.0, 0.0);
        this.renderDoorWhenClosed(door, matrixStack, buffer, packedLight, packedOverlay, this.door);
        matrixStack.func_227865_b_();
        this.Posts.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        this.Signage.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        this.panels.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        matrixStack.func_227865_b_();
    }

    @Override
    public void renderBoti(DoorEntity door, MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay) {
        if (Minecraft.func_71410_x().field_71441_e != null && door.getOpenState() != EnumDoorState.CLOSED) {
            Minecraft.func_71410_x().field_71441_e.getCapability(Capabilities.TARDIS_DATA).ifPresent(data -> {
                PortalInfo info = new PortalInfo();
                info.setWorldShell(data.getBotiWorld());
                info.setPosition(door.func_213303_ch());
                info.setTranslate(matrix -> {
                    DoorRenderer.applyTranslations(matrix, door.field_70177_z - 180.0f, door.func_174811_aO());
                    matrix.func_227861_a_(0.0, 0.75, 0.0);
                    matrix.func_227863_a_(Vector3f.field_229182_e_.func_229187_a_(180.0f));
                });
                info.setTranslatePortal(matrix -> {
                    matrix.func_227861_a_(0.0, -0.75, 0.0);
                    matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(WorldHelper.getAngleFromFacing(data.getBotiWorld().getPortalDirection())));
                    matrix.func_227861_a_(-0.5, 0.0, -0.5);
                });
                info.setRenderPortal((matrix, buf) -> {
                    matrix.func_227860_a_();
                    this.boti.func_228308_a_(matrix, buf.getBuffer(TRenderTypes.getTardis(this.getTexture())), packedLight, packedOverlay);
                    matrix.func_227865_b_();
                });
                info.setRenderDoor((matrix, buf) -> {
                    matrix.func_227860_a_();
                    matrix.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
                    matrix.func_227861_a_(0.0, 1.5, 0.0);
                    matrix.func_227862_a_(0.25f, 0.25f, 0.25f);
                    this.door.func_228308_a_(matrix, buf.getBuffer(RenderType.func_228644_e_((ResourceLocation)this.getTexture())), packedLight, packedOverlay);
                    matrix.func_227865_b_();
                });
                BOTIRenderer.addPortal(info);
            });
        }
    }

    @Override
    public ResourceLocation getTexture() {
        return JapanExteriorRenderer.TEXTURE;
    }

    @Override
    public boolean doesDoorOpenIntoBotiWindow() {
        return true;
    }
}

