/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.models.interiordoors;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.client.models.interiordoors.AbstractInteriorDoorModel;
import net.tardis.mod.client.renderers.boti.BOTIRenderer;
import net.tardis.mod.client.renderers.boti.PortalInfo;
import net.tardis.mod.client.renderers.entity.DoorRenderer;
import net.tardis.mod.client.renderers.exteriors.FortuneExteriorRenderer;
import net.tardis.mod.entity.DoorEntity;
import net.tardis.mod.enums.EnumDoorState;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.misc.IDoorType;
import net.tardis.mod.misc.TexVariant;
import net.tardis.mod.tileentities.ConsoleTile;

public class FortuneInteriorModel
extends AbstractInteriorDoorModel {
    private final ModelRenderer door;
    private final ModelRenderer latch;
    private final ModelRenderer frame;
    private final ModelRenderer latch2;
    private final ModelRenderer boti;

    public FortuneInteriorModel() {
        this.field_78090_t = 512;
        this.field_78089_u = 512;
        this.door = new ModelRenderer((Model)this);
        this.door.func_78793_a(-24.0f, 24.0f, 28.0f);
        this.door.func_78784_a(253, 106).func_228303_a_(40.0f, -154.0f, 0.0f, 8.0f, 148.0f, 4.0f, 0.0f, false);
        this.door.func_78784_a(179, 110).func_228303_a_(2.0f, -151.6f, 2.0f, 44.0f, 144.0f, 1.0f, 0.0f, false);
        this.door.func_78784_a(256, 108).func_228303_a_(0.0f, -154.0f, 0.0f, 8.0f, 148.0f, 4.0f, 0.0f, false);
        this.door.func_78784_a(224, 241).func_228303_a_(8.0f, -18.0f, 0.0f, 32.0f, 12.0f, 4.0f, 0.0f, false);
        this.door.func_78784_a(292, 125).func_228303_a_(8.0f, -154.0f, 0.0f, 32.0f, 12.0f, 4.0f, 0.0f, false);
        this.door.func_78784_a(139, 105).func_228303_a_(8.0f, -112.4f, 0.0f, 32.0f, 4.0f, 4.0f, 0.0f, false);
        this.door.func_78784_a(139, 105).func_228303_a_(8.0f, -54.0f, 0.0f, 32.0f, 4.0f, 4.0f, 0.0f, false);
        this.latch = new ModelRenderer((Model)this);
        this.latch.func_78793_a(0.0f, 0.0f, 0.0f);
        this.door.func_78792_a(this.latch);
        this.latch.func_78784_a(166, 8).func_228303_a_(42.0f, -88.0f, -2.0f, 4.0f, 8.0f, 8.0f, 0.0f, false);
        this.latch.func_78784_a(110, 16).func_228303_a_(42.0f, -78.0f, 1.0f, 4.0f, 4.0f, 4.0f, 0.0f, false);
        this.frame = new ModelRenderer((Model)this);
        this.frame.func_78793_a(-24.0f, 24.0f, 21.0f);
        this.frame.func_78784_a(256, 108).func_228303_a_(-4.0f, -154.0f, 4.75f, 4.0f, 148.0f, 6.0f, 0.0f, false);
        this.frame.func_78784_a(256, 108).func_228303_a_(48.0f, -154.0f, 4.75f, 4.0f, 148.0f, 6.0f, 0.0f, false);
        this.frame.func_78784_a(224, 241).func_228303_a_(-2.0f, -8.0f, 3.0f, 52.0f, 2.0f, 4.0f, 0.0f, false);
        this.frame.func_78784_a(339, 131).func_228303_a_(-4.0f, -158.25f, 4.5f, 56.0f, 4.0f, 6.0f, 0.0f, false);
        this.latch2 = new ModelRenderer((Model)this);
        this.latch2.func_78793_a(0.0f, 0.0f, 0.0f);
        this.frame.func_78792_a(this.latch2);
        this.boti = new ModelRenderer((Model)this);
        this.boti.func_78793_a(0.0f, 22.75f, 7.0f);
        this.boti.func_78784_a(1, 97).func_228303_a_(-24.0f, -153.0f, 25.0f, 48.0f, 149.0f, 4.0f, 0.0f, false);
    }

    public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }

    @Override
    public void renderBones(DoorEntity door, MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 1.2, -0.05);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        matrixStack.func_227862_a_(0.25f, 0.25f, 0.25f);
        this.door.field_78796_g = (float)Math.toRadians(IDoorType.EnumDoorType.FORTUNE.getRotationForState(door.getOpenState()));
        this.renderDoorWhenClosed(door, matrixStack, buffer, packedLight, packedOverlay, this.door);
        this.frame.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        matrixStack.func_227865_b_();
    }

    @Override
    public void renderBoti(DoorEntity door, MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay) {
        if (Minecraft.func_71410_x().field_71441_e != null && door.getOpenState() != EnumDoorState.CLOSED) {
            Minecraft.func_71410_x().field_71441_e.getCapability(Capabilities.TARDIS_DATA).ifPresent(data -> {
                PortalInfo info = new PortalInfo();
                info.setPosition(door.func_213303_ch());
                info.setWorldShell(data.getBotiWorld());
                info.setTranslate(matrix -> {
                    DoorRenderer.applyTranslations(matrix, door.field_70177_z - 180.0f, door.func_174811_aO());
                    matrixStack.func_227861_a_(0.0, 1.2, -0.05);
                });
                info.setTranslatePortal(matrix -> {
                    matrix.func_227863_a_(Vector3f.field_229182_e_.func_229187_a_(180.0f));
                    matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(WorldHelper.getAngleFromFacing(data.getBotiWorld().getPortalDirection())));
                    matrix.func_227861_a_(-0.5, -0.25, -0.5);
                });
                info.setRenderDoor((matrix, buf) -> {
                    matrix.func_227860_a_();
                    matrix.func_227861_a_(0.0, 0.0, -0.05);
                    matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                    matrix.func_227862_a_(0.25f, 0.25f, 0.25f);
                    this.door.func_228308_a_(matrix, buf.getBuffer(RenderType.func_228638_b_((ResourceLocation)this.getTexture())), packedLight, packedOverlay);
                    matrix.func_227865_b_();
                });
                info.setRenderPortal((matrix, buf) -> {
                    matrix.func_227860_a_();
                    matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                    matrix.func_227862_a_(0.25f, 0.25f, 0.25f);
                    this.boti.func_228308_a_(matrix, buf.getBuffer(RenderType.func_228638_b_((ResourceLocation)this.getTexture())), packedLight, packedOverlay);
                    matrix.func_227865_b_();
                });
                BOTIRenderer.addPortal(info);
            });
        }
    }

    @Override
    public ResourceLocation getTexture() {
        ConsoleTile tile = TardisHelper.getConsoleInWorld((World)Minecraft.func_71410_x().field_71441_e).orElse(null);
        if (tile != null) {
            int index = tile.getExteriorManager().getExteriorVariant();
            TexVariant[] vars = tile.getExteriorType().getVariants();
            if (vars != null && index < vars.length) {
                return vars[index].getTexture();
            }
        }
        return FortuneExteriorRenderer.TEXTURE;
    }

    @Override
    public boolean doesDoorOpenIntoBotiWindow() {
        return true;
    }
}

