/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.models.interiordoors;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.client.models.interiordoors.AbstractInteriorDoorModel;
import net.tardis.mod.client.renderers.boti.BOTIRenderer;
import net.tardis.mod.client.renderers.boti.PortalInfo;
import net.tardis.mod.client.renderers.entity.DoorRenderer;
import net.tardis.mod.entity.DoorEntity;
import net.tardis.mod.enums.EnumDoorState;
import net.tardis.mod.helper.Helper;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.misc.IDoorType;

public class ApertureInteriorModel
extends AbstractInteriorDoorModel {
    public static final ResourceLocation TEXTURE = Helper.createRL("textures/exteriors/interior/aperture.png");
    private final ModelRenderer left_door;
    private final ModelRenderer right_door;
    private final ModelRenderer frame;
    private final ModelRenderer bone2;
    private final ModelRenderer bone3;
    private final ModelRenderer BOTI;

    public ApertureInteriorModel() {
        this.field_78090_t = 128;
        this.field_78089_u = 128;
        this.left_door = new ModelRenderer((Model)this);
        this.left_door.func_78793_a(5.0f, 8.5f, 7.25f);
        this.setRotationAngle(this.left_door, 0.0f, -1.0908f, 0.0f);
        this.left_door.func_78784_a(34, 34).func_228303_a_(-5.0f, -14.5f, -1.0f, 5.0f, 29.0f, 1.0f, 0.0f, false);
        this.right_door = new ModelRenderer((Model)this);
        this.right_door.func_78793_a(-5.0f, 8.5f, 7.25f);
        this.setRotationAngle(this.right_door, 0.0f, 0.8727f, 0.0f);
        this.right_door.func_78784_a(8, 33).func_228303_a_(0.0f, -14.5f, -1.0f, 5.0f, 29.0f, 1.0f, 0.0f, false);
        this.frame = new ModelRenderer((Model)this);
        this.frame.func_78793_a(0.0f, 26.0f, 14.35f);
        this.frame.func_78784_a(0, 0).func_228303_a_(-6.0f, -34.0f, -7.35f, 12.0f, 32.0f, 1.0f, 0.0f, false);
        this.frame.func_78784_a(26, 3).func_228303_a_(-6.0f, -34.0f, -8.35f, 12.0f, 2.0f, 1.0f, 0.0f, false);
        this.frame.func_78784_a(26, 0).func_228303_a_(-6.0f, -3.0f, -8.65f, 12.0f, 1.0f, 2.0f, 0.0f, false);
        this.bone2 = new ModelRenderer((Model)this);
        this.bone2.func_78793_a(-5.9952f, -18.0f, -6.3481f);
        this.frame.func_78792_a(this.bone2);
        this.setRotationAngle(this.bone2, 0.0f, -0.5236f, 0.0f);
        this.bone2.func_78784_a(0, 33).func_228303_a_(-2.0f, -16.0f, -2.0f, 2.0f, 32.0f, 2.0f, 0.0f, false);
        this.bone3 = new ModelRenderer((Model)this);
        this.bone3.func_78793_a(6.0048f, -18.0f, -6.3481f);
        this.frame.func_78792_a(this.bone3);
        this.setRotationAngle(this.bone3, 0.0f, -1.0472f, 0.0f);
        this.bone3.func_78784_a(26, 26).func_228303_a_(-2.0f, -16.0f, -2.0f, 2.0f, 32.0f, 2.0f, 0.0f, false);
        this.BOTI = new ModelRenderer((Model)this);
        this.BOTI.func_78793_a(0.0f, 24.0f, 8.6f);
        this.BOTI.func_78784_a(58, 0).func_228303_a_(-6.0f, -32.0f, -1.85f, 12.0f, 32.0f, 1.0f, -0.025f, false);
    }

    public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }

    @Override
    public ResourceLocation getTexture() {
        return TEXTURE;
    }

    @Override
    public void renderBones(DoorEntity door, MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay) {
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        EnumDoorState open = door.getOpenState();
        if (open == EnumDoorState.CLOSED) {
            this.right_door.field_78796_g = 0.0f;
            this.left_door.field_78796_g = 0.0f;
        } else if (open == EnumDoorState.ONE) {
            this.left_door.field_78796_g = -((float)Math.toRadians(IDoorType.EnumDoorType.APERTURE.getRotationForState(open)));
            this.right_door.field_78796_g = 0.0f;
        } else if (open == EnumDoorState.BOTH) {
            this.left_door.field_78796_g = -((float)Math.toRadians(IDoorType.EnumDoorType.APERTURE.getRotationForState(open)));
            this.right_door.field_78796_g = (float)Math.toRadians(IDoorType.EnumDoorType.APERTURE.getRotationForState(open));
        }
        this.left_door.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        this.right_door.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        this.frame.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
    }

    @Override
    public void renderBoti(DoorEntity door, MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay) {
        if (Minecraft.func_71410_x().field_71441_e != null && door.getOpenState() != EnumDoorState.CLOSED) {
            Minecraft.func_71410_x().field_71441_e.getCapability(Capabilities.TARDIS_DATA).ifPresent(data -> {
                PortalInfo info = new PortalInfo();
                info.setPosition(door.func_213303_ch());
                info.setWorldShell(data.getBotiWorld());
                info.setTranslate(matrix -> {
                    DoorRenderer.applyTranslations(matrix, door);
                    matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                });
                info.setTranslatePortal(matrix -> {
                    matrix.func_227863_a_(Vector3f.field_229182_e_.func_229187_a_(180.0f));
                    matrix.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(180.0f));
                    matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(WorldHelper.getAngleFromFacing(data.getBotiWorld().getPortalDirection())));
                    matrix.func_227861_a_(-0.3, -1.4062, -0.5);
                });
                info.setRenderPortal((matrix, buf) -> {
                    matrix.func_227860_a_();
                    this.BOTI.func_228308_a_(matrix, buf.getBuffer(RenderType.func_228640_c_((ResourceLocation)this.getTexture())), packedLight, packedOverlay);
                    matrix.func_227865_b_();
                });
                BOTIRenderer.addPortal(info);
            });
        }
    }
}

