/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.models.exteriors;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.tardis.mod.client.TRenderTypes;
import net.tardis.mod.client.models.exteriors.ExteriorModel;
import net.tardis.mod.client.renderers.boti.BOTIRenderer;
import net.tardis.mod.client.renderers.boti.PortalInfo;
import net.tardis.mod.client.renderers.exteriors.BrokenExteriorRenderer;
import net.tardis.mod.client.renderers.exteriors.ExteriorRenderer;
import net.tardis.mod.client.renderers.exteriors.TTCapsuleExteriorRenderer;
import net.tardis.mod.enums.EnumDoorState;
import net.tardis.mod.enums.EnumMatterState;
import net.tardis.mod.helper.Helper;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.misc.IDoorType;
import net.tardis.mod.tileentities.exteriors.ExteriorTile;

public class TTCapsuleExteriorModel
extends ExteriorModel
implements BrokenExteriorRenderer.IBrokenExteriorModel {
    private final ModelRenderer right_door_rotate_90;
    private final ModelRenderer left_door_rotate_90;
    private final ModelRenderer base;
    private final ModelRenderer bone2;
    private final ModelRenderer bone3;
    private final ModelRenderer bone4;
    private final ModelRenderer walls;
    private final ModelRenderer bone22;
    private final ModelRenderer bone8;
    private final ModelRenderer bone7;
    private final ModelRenderer roof;
    private final ModelRenderer bone;
    private final ModelRenderer bone5;
    private final ModelRenderer bone6;
    private final ModelRenderer boti;

    public TTCapsuleExteriorModel() {
        this.field_78090_t = 128;
        this.field_78089_u = 128;
        this.right_door_rotate_90 = new ModelRenderer((Model)this);
        this.right_door_rotate_90.func_78793_a(-6.0f, 6.5f, -5.0f);
        this.right_door_rotate_90.func_78784_a(14, 35).func_228303_a_(0.0f, -14.5f, -0.525f, 6.0f, 29.0f, 1.0f, 0.0f, false);
        this.left_door_rotate_90 = new ModelRenderer((Model)this);
        this.left_door_rotate_90.func_78793_a(6.0f, 6.5f, -5.0f);
        this.left_door_rotate_90.func_78784_a(0, 30).func_228303_a_(-6.0f, -14.5f, -0.525f, 6.0f, 29.0f, 1.0f, 0.0f, false);
        this.base = new ModelRenderer((Model)this);
        this.base.func_78793_a(0.0f, 24.0f, 0.0f);
        this.base.func_78784_a(26, 0).func_228303_a_(-3.0f, -3.0f, 0.0f, 6.0f, 3.0f, 9.0f, 0.0f, false);
        this.base.func_78784_a(38, 25).func_228303_a_(-5.0f, -3.0f, 7.0f, 2.0f, 3.0f, 1.0f, 0.0f, false);
        this.base.func_78784_a(58, 47).func_228303_a_(-7.0f, -3.0f, 3.0f, 4.0f, 3.0f, 4.0f, 0.0f, false);
        this.base.func_78784_a(38, 21).func_228303_a_(3.0f, -3.0f, 7.0f, 2.0f, 3.0f, 1.0f, 0.0f, false);
        this.bone2 = new ModelRenderer((Model)this);
        this.bone2.func_78793_a(0.0f, 0.0f, 0.0f);
        this.base.func_78792_a(this.bone2);
        this.setRotationAngle(this.bone2, 0.0f, -1.5708f, 0.0f);
        this.bone2.func_78784_a(26, 12).func_228303_a_(-3.0f, -3.0f, 3.0f, 6.0f, 3.0f, 6.0f, 0.0f, false);
        this.bone2.func_78784_a(38, 25).func_228303_a_(-5.0f, -3.0f, 7.0f, 2.0f, 3.0f, 1.0f, 0.0f, false);
        this.bone2.func_78784_a(58, 47).func_228303_a_(-7.0f, -3.0f, 3.0f, 4.0f, 3.0f, 4.0f, 0.0f, false);
        this.bone2.func_78784_a(38, 21).func_228303_a_(3.0f, -3.0f, 7.0f, 2.0f, 3.0f, 1.0f, 0.0f, false);
        this.bone3 = new ModelRenderer((Model)this);
        this.bone3.func_78793_a(0.0f, 0.0f, 0.0f);
        this.bone2.func_78792_a(this.bone3);
        this.setRotationAngle(this.bone3, 0.0f, -1.5708f, 0.0f);
        this.bone3.func_78784_a(26, 0).func_228303_a_(-3.0f, -3.0f, 0.0f, 6.0f, 3.0f, 9.0f, 0.0f, false);
        this.bone3.func_78784_a(38, 25).func_228303_a_(-5.0f, -3.0f, 7.0f, 2.0f, 3.0f, 1.0f, 0.0f, false);
        this.bone3.func_78784_a(58, 47).func_228303_a_(-7.0f, -3.0f, 3.0f, 4.0f, 3.0f, 4.0f, 0.0f, false);
        this.bone3.func_78784_a(38, 21).func_228303_a_(3.0f, -3.0f, 7.0f, 2.0f, 3.0f, 1.0f, 0.0f, false);
        this.bone4 = new ModelRenderer((Model)this);
        this.bone4.func_78793_a(0.0f, 0.0f, 0.0f);
        this.bone3.func_78792_a(this.bone4);
        this.setRotationAngle(this.bone4, 0.0f, -1.5708f, 0.0f);
        this.bone4.func_78784_a(26, 12).func_228303_a_(-3.0f, -3.0f, 3.0f, 6.0f, 3.0f, 6.0f, 0.0f, false);
        this.bone4.func_78784_a(38, 25).func_228303_a_(-5.0f, -3.0f, 7.0f, 2.0f, 3.0f, 1.0f, 0.0f, false);
        this.bone4.func_78784_a(58, 47).func_228303_a_(-7.0f, -3.0f, 3.0f, 4.0f, 3.0f, 4.0f, 0.0f, false);
        this.bone4.func_78784_a(38, 21).func_228303_a_(3.0f, -3.0f, 7.0f, 2.0f, 3.0f, 1.0f, 0.0f, false);
        this.walls = new ModelRenderer((Model)this);
        this.walls.func_78793_a(0.0f, 24.0f, 0.0f);
        this.bone22 = new ModelRenderer((Model)this);
        this.bone22.func_78793_a(3.0f, -3.0f, 9.0f);
        this.walls.func_78792_a(this.bone22);
        this.bone22.func_78784_a(40, 40).func_228303_a_(-5.5f, -29.0f, -1.5f, 5.0f, 29.0f, 1.0f, 0.0f, false);
        this.bone22.func_78784_a(0, 60).func_228303_a_(-7.5f, -29.0f, -2.5f, 2.0f, 29.0f, 1.0f, 0.0f, false);
        this.bone22.func_78784_a(52, 52).func_228303_a_(1.5f, -29.0f, -4.5f, 2.0f, 29.0f, 2.0f, 0.0f, false);
        this.bone22.func_78784_a(52, 52).func_228303_a_(-9.5f, -29.0f, -4.5f, 2.0f, 29.0f, 2.0f, 0.0f, true);
        this.bone22.func_78784_a(52, 12).func_228303_a_(-0.5f, -29.0f, -2.5f, 2.0f, 29.0f, 1.0f, 0.0f, false);
        this.bone8 = new ModelRenderer((Model)this);
        this.bone8.func_78793_a(-3.0f, 0.0f, -9.0f);
        this.bone22.func_78792_a(this.bone8);
        this.setRotationAngle(this.bone8, 0.0f, -1.5708f, 0.0f);
        this.bone8.func_78784_a(28, 35).func_228303_a_(-2.5f, -29.0f, 7.5f, 5.0f, 29.0f, 1.0f, 0.0f, false);
        this.bone8.func_78784_a(0, 60).func_228303_a_(-4.5f, -29.0f, 6.5f, 2.0f, 29.0f, 1.0f, 0.0f, false);
        this.bone8.func_78784_a(58, 0).func_228303_a_(-6.5f, -29.0f, 5.5f, 2.0f, 29.0f, 1.0f, 0.0f, false);
        this.bone8.func_78784_a(52, 12).func_228303_a_(2.5f, -29.0f, 6.5f, 2.0f, 29.0f, 1.0f, 0.0f, false);
        this.bone7 = new ModelRenderer((Model)this);
        this.bone7.func_78793_a(-3.0f, 0.0f, -9.0f);
        this.bone22.func_78792_a(this.bone7);
        this.setRotationAngle(this.bone7, 0.0f, 1.5708f, 0.0f);
        this.bone7.func_78784_a(28, 35).func_228303_a_(-2.5f, -29.0f, 7.5f, 5.0f, 29.0f, 1.0f, 0.0f, true);
        this.bone7.func_78784_a(0, 60).func_228303_a_(2.5f, -29.0f, 6.5f, 2.0f, 29.0f, 1.0f, 0.0f, true);
        this.bone7.func_78784_a(58, 0).func_228303_a_(4.5f, -29.0f, 5.5f, 2.0f, 29.0f, 1.0f, 0.0f, true);
        this.bone7.func_78784_a(52, 12).func_228303_a_(-4.5f, -29.0f, 6.5f, 2.0f, 29.0f, 1.0f, 0.0f, true);
        this.roof = new ModelRenderer((Model)this);
        this.roof.func_78793_a(0.0f, -8.0f, 0.0f);
        this.roof.func_78784_a(17, 21).func_228303_a_(-3.0f, -5.0f, 0.0f, 6.0f, 5.0f, 9.0f, 0.0f, false);
        this.roof.func_78784_a(26, 12).func_228303_a_(-5.0f, -5.0f, 7.0f, 2.0f, 5.0f, 1.0f, 0.0f, false);
        this.roof.func_78784_a(60, 60).func_228303_a_(-7.0f, -5.0f, 3.0f, 4.0f, 5.0f, 4.0f, 0.0f, false);
        this.roof.func_78784_a(26, 0).func_228303_a_(3.0f, -5.0f, 7.0f, 2.0f, 5.0f, 1.0f, 0.0f, false);
        this.bone = new ModelRenderer((Model)this);
        this.bone.func_78793_a(0.0f, 0.0f, 0.0f);
        this.roof.func_78792_a(this.bone);
        this.setRotationAngle(this.bone, 0.0f, -1.5708f, 0.0f);
        this.bone.func_78784_a(52, 36).func_228303_a_(-3.0f, -5.0f, 3.0f, 6.0f, 5.0f, 6.0f, 0.0f, false);
        this.bone.func_78784_a(26, 12).func_228303_a_(-5.0f, -5.0f, 7.0f, 2.0f, 5.0f, 1.0f, 0.0f, false);
        this.bone.func_78784_a(60, 60).func_228303_a_(-7.0f, -5.0f, 3.0f, 4.0f, 5.0f, 4.0f, 0.0f, false);
        this.bone.func_78784_a(26, 0).func_228303_a_(3.0f, -5.0f, 7.0f, 2.0f, 5.0f, 1.0f, 0.0f, false);
        this.bone5 = new ModelRenderer((Model)this);
        this.bone5.func_78793_a(0.0f, 0.0f, 0.0f);
        this.bone.func_78792_a(this.bone5);
        this.setRotationAngle(this.bone5, 0.0f, -1.5708f, 0.0f);
        this.bone5.func_78784_a(17, 21).func_228303_a_(-3.0f, -5.0f, 0.0f, 6.0f, 5.0f, 9.0f, 0.0f, false);
        this.bone5.func_78784_a(26, 12).func_228303_a_(-5.0f, -5.0f, 7.0f, 2.0f, 5.0f, 1.0f, 0.0f, false);
        this.bone5.func_78784_a(60, 60).func_228303_a_(-7.0f, -5.0f, 3.0f, 4.0f, 5.0f, 4.0f, 0.0f, false);
        this.bone5.func_78784_a(26, 0).func_228303_a_(3.0f, -5.0f, 7.0f, 2.0f, 5.0f, 1.0f, 0.0f, false);
        this.bone6 = new ModelRenderer((Model)this);
        this.bone6.func_78793_a(0.0f, 0.0f, 0.0f);
        this.bone5.func_78792_a(this.bone6);
        this.setRotationAngle(this.bone6, 0.0f, -1.5708f, 0.0f);
        this.bone6.func_78784_a(52, 36).func_228303_a_(-3.0f, -5.0f, 3.0f, 6.0f, 5.0f, 6.0f, 0.0f, false);
        this.bone6.func_78784_a(26, 12).func_228303_a_(-5.0f, -5.0f, 7.0f, 2.0f, 5.0f, 1.0f, 0.0f, false);
        this.bone6.func_78784_a(60, 60).func_228303_a_(-7.0f, -5.0f, 3.0f, 4.0f, 5.0f, 4.0f, 0.0f, false);
        this.bone6.func_78784_a(26, 0).func_228303_a_(3.0f, -5.0f, 7.0f, 2.0f, 5.0f, 1.0f, 0.0f, false);
        this.boti = new ModelRenderer((Model)this);
        this.boti.func_78793_a(0.0f, 24.0f, -1.0f);
        this.boti.func_78784_a(0, 0).func_228303_a_(-6.0f, -32.0f, -3.525f, 12.0f, 29.0f, 1.0f, 0.0f, false);
    }

    @Override
    public void func_225597_a_(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    @Override
    public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.right_door_rotate_90.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        this.left_door_rotate_90.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        this.base.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        this.walls.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        this.roof.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        this.boti.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
    }

    public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }

    @Override
    public void renderBones(ExteriorTile exterior, float scale, MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float alpha) {
        this.right_door_rotate_90.field_78796_g = 0.0f;
        this.left_door_rotate_90.field_78796_g = 0.0f;
        float rot = (float)Math.toRadians(IDoorType.EnumDoorType.TT_CAPSULE.getRotationForState(exterior.getOpen()));
        if (exterior.getOpen() == EnumDoorState.ONE) {
            this.right_door_rotate_90.field_78796_g = -rot;
            this.left_door_rotate_90.field_78796_g = 0.0f;
        } else {
            this.left_door_rotate_90.field_78796_g = rot;
            this.right_door_rotate_90.field_78796_g = -rot;
        }
        this.right_door_rotate_90.func_228309_a_(matrixStack, buffer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        this.left_door_rotate_90.func_228309_a_(matrixStack, buffer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        this.base.func_228309_a_(matrixStack, buffer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        this.walls.func_228309_a_(matrixStack, buffer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        this.roof.func_228309_a_(matrixStack, buffer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, alpha);
    }

    @Override
    public void renderBoti(ExteriorTile exterior, float scale, MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float alpha) {
        if (exterior.getBotiWorld() != null && exterior.getMatterState() == EnumMatterState.SOLID && exterior.getOpen() != EnumDoorState.CLOSED) {
            PortalInfo info = new PortalInfo();
            info.setPosition(exterior.func_174877_v());
            info.setWorldShell(exterior.getBotiWorld());
            info.setTranslate(matrix -> {
                matrix.func_227861_a_(-0.5, 1.0, -0.5);
                ExteriorRenderer.applyTransforms(matrix, exterior);
            });
            info.setTranslatePortal(matrix -> {
                matrix.func_227863_a_(Vector3f.field_229182_e_.func_229187_a_(180.0f));
                matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(WorldHelper.getAngleFromFacing(exterior.getBotiWorld().getPortalDirection())));
                matrix.func_227861_a_(-0.5, -1.25, -0.5);
            });
            info.setRenderPortal((matrix, buf) -> {
                matrix.func_227860_a_();
                this.boti.func_228308_a_(matrix, buf.getBuffer(TRenderTypes.getTardis(Helper.getVariantTextureOr(exterior.getVariant(), TTCapsuleExteriorRenderer.TEXTURE))), packedLight, packedOverlay);
                matrix.func_227865_b_();
            });
            info.setRenderDoor((matrix, buf) -> {
                matrix.func_227860_a_();
                ResourceLocation tex = Helper.getVariantTextureOr(exterior.getVariant(), TTCapsuleExteriorRenderer.TEXTURE);
                this.left_door_rotate_90.func_228308_a_(matrix, buf.getBuffer(RenderType.func_228638_b_((ResourceLocation)tex)), packedLight, packedOverlay);
                this.right_door_rotate_90.func_228308_a_(matrix, buf.getBuffer(RenderType.func_228638_b_((ResourceLocation)tex)), packedLight, packedOverlay);
                matrix.func_227865_b_();
            });
            BOTIRenderer.addPortal(info);
        }
    }

    @Override
    public void renderBrokenExterior(MatrixStack matrix, IVertexBuilder buffer, int packedLight, int packedOverlay) {
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.0, -1.0, 0.0);
        this.right_door_rotate_90.func_228308_a_(matrix, buffer, packedLight, packedOverlay);
        this.left_door_rotate_90.func_228308_a_(matrix, buffer, packedLight, packedOverlay);
        this.base.func_228308_a_(matrix, buffer, packedLight, packedOverlay);
        this.walls.func_228308_a_(matrix, buffer, packedLight, packedOverlay);
        this.roof.func_228308_a_(matrix, buffer, packedLight, packedOverlay);
        matrix.func_227865_b_();
    }
}

