/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.models.exteriors;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.vector.Vector3f;
import net.tardis.mod.client.TRenderTypes;
import net.tardis.mod.client.models.exteriors.ExteriorModel;
import net.tardis.mod.client.renderers.boti.BOTIRenderer;
import net.tardis.mod.client.renderers.boti.PortalInfo;
import net.tardis.mod.client.renderers.exteriors.BrokenExteriorRenderer;
import net.tardis.mod.client.renderers.exteriors.ExteriorRenderer;
import net.tardis.mod.client.renderers.exteriors.SafeExteriorRenderer;
import net.tardis.mod.enums.EnumDoorState;
import net.tardis.mod.enums.EnumMatterState;
import net.tardis.mod.helper.Helper;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.misc.IDoorType;
import net.tardis.mod.tileentities.exteriors.ExteriorTile;

public class SafeExteriorModel
extends ExteriorModel
implements BrokenExteriorRenderer.IBrokenExteriorModel {
    private final ModelRenderer BOTI;
    private final ModelRenderer door;
    private final ModelRenderer bb_main;

    public SafeExteriorModel() {
        this.field_78090_t = 128;
        this.field_78089_u = 128;
        this.BOTI = new ModelRenderer((Model)this);
        this.BOTI.func_78793_a(0.0f, 24.0f, 0.0f);
        this.BOTI.func_78784_a(79, 1).func_228303_a_(-8.0f, -34.0f, -6.0f, 16.0f, 34.0f, 1.0f, -0.025f, false);
        this.door = new ModelRenderer((Model)this);
        this.door.func_78793_a(7.0f, 7.0f, -6.5f);
        this.door.func_78784_a(30, 48).func_228303_a_(-14.0f, -16.0f, -0.5f, 14.0f, 32.0f, 1.0f, 0.0f, false);
        this.door.func_78784_a(60, 26).func_228303_a_(-1.5f, -14.0f, -1.475f, 2.0f, 6.0f, 2.0f, 0.0f, false);
        this.door.func_78784_a(60, 26).func_228303_a_(-1.5f, 8.0f, -1.475f, 2.0f, 6.0f, 2.0f, 0.0f, false);
        this.door.func_78784_a(60, 34).func_228303_a_(-6.0f, -9.0f, -1.0f, 1.0f, 4.0f, 3.0f, 0.0f, false);
        this.door.func_78784_a(60, 34).func_228303_a_(-6.0f, 5.0f, -1.0f, 1.0f, 4.0f, 3.0f, 0.0f, false);
        this.door.func_78784_a(60, 10).func_228303_a_(-11.5f, -2.5f, -1.5f, 5.0f, 5.0f, 3.0f, 0.0f, false);
        this.door.func_78784_a(60, 60).func_228303_a_(-14.0f, -8.5f, -0.475f, 14.0f, 3.0f, 2.0f, 0.0f, false);
        this.door.func_78784_a(60, 60).func_228303_a_(-14.0f, 5.5f, -0.475f, 14.0f, 3.0f, 2.0f, 0.0f, false);
        this.bb_main = new ModelRenderer((Model)this);
        this.bb_main.func_78793_a(0.0f, 24.0f, 0.0f);
        this.bb_main.func_78784_a(0, 0).func_228303_a_(-8.0f, -34.0f, -7.0f, 16.0f, 34.0f, 14.0f, 0.0f, false);
        this.bb_main.func_78784_a(46, 0).func_228303_a_(-7.0f, -10.0f, 7.0f, 14.0f, 9.0f, 1.0f, 0.0f, false);
        this.bb_main.func_78784_a(0, 0).func_228303_a_(7.0f, -31.0f, -3.0f, 1.0f, 3.0f, 6.0f, 0.0f, false);
        this.bb_main.func_78784_a(0, 0).func_228303_a_(-8.0f, -31.0f, -3.0f, 1.0f, 3.0f, 6.0f, 0.0f, true);
    }

    public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }

    @Override
    public void renderBones(ExteriorTile exterior, float scale, MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float alpha) {
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(1.0f, 1.0f, 1.0f);
        matrixStack.func_227861_a_(0.0, -0.75, 0.0);
        this.door.field_78796_g = (float)Math.toRadians(IDoorType.EnumDoorType.SAFE.getRotationForState(exterior.getOpen()));
        this.door.func_228309_a_(matrixStack, buffer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        this.bb_main.func_228309_a_(matrixStack, buffer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        matrixStack.func_227865_b_();
    }

    @Override
    public void renderBoti(ExteriorTile exterior, float scale, MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float alpha) {
        if (exterior.getBotiWorld() != null && exterior.getMatterState() == EnumMatterState.SOLID && exterior.getOpen() != EnumDoorState.CLOSED) {
            PortalInfo info = new PortalInfo();
            info.setPosition(exterior.func_174877_v());
            info.setWorldShell(exterior.getBotiWorld());
            info.setTranslate(matrix -> {
                matrix.func_227861_a_(-0.5, 0.0, -0.5);
                ExteriorRenderer.applyTransforms(matrix, exterior);
                matrix.func_227861_a_(0.0, -1.0, 0.0);
            });
            info.setTranslatePortal(matrix -> {
                matrix.func_227863_a_(Vector3f.field_229182_e_.func_229187_a_(180.0f));
                matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(WorldHelper.getAngleFromFacing(exterior.getBotiWorld().getPortalDirection())));
                matrix.func_227861_a_(-0.5, -1.5, -0.5);
            });
            info.setRenderPortal((matrix, buf) -> {
                matrix.func_227860_a_();
                this.BOTI.func_228308_a_(matrix, buf.getBuffer(TRenderTypes.getTardis(Helper.getVariantTextureOr(exterior.getVariant(), SafeExteriorRenderer.TEXTURE))), packedLight, packedOverlay);
                matrix.func_227865_b_();
            });
            BOTIRenderer.addPortal(info);
        }
    }

    @Override
    public void renderBrokenExterior(MatrixStack matrix, IVertexBuilder buffer, int packedLight, int packedOverlay) {
        matrix.func_227860_a_();
        float scale = 1.0f;
        matrix.func_227862_a_(scale, scale, scale);
        matrix.func_227861_a_(0.0, -0.75, 0.0);
        matrix.func_227861_a_(0.0, -0.26, 0.0);
        this.door.func_228308_a_(matrix, buffer, packedLight, packedOverlay);
        this.bb_main.func_228308_a_(matrix, buffer, packedLight, packedOverlay);
        matrix.func_227865_b_();
    }
}

