/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.models.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.tardis.mod.helper.TRenderHelper;

public class TBaseArmorModel<T extends LivingEntity>
extends BipedModel<T> {
    T entity;

    public TBaseArmorModel(float modelSize) {
        this(RenderType::func_228640_c_, modelSize, 0.0f, 64, 32);
    }

    public TBaseArmorModel(Function<ResourceLocation, RenderType> renderTypeIn, float modelSize, float yOffsetIn, int textureWidthIn, int textureHeightIn) {
        super(RenderType::func_228640_c_, modelSize, yOffsetIn, textureWidthIn, textureHeightIn);
    }

    public void func_225598_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.entity != null) {
            this.field_217114_e = this.entity.func_70631_g_();
            this.field_228270_o_ = this.entity.func_225608_bj_();
            if (this.entity instanceof PlayerEntity && this.entity != null) {
                PlayerEntity player = (PlayerEntity)this.entity;
                this.field_228270_o_ = !player.field_71075_bZ.field_75100_b && player.func_225608_bj_();
            }
            this.field_217113_d = this.entity.func_184218_aH() && this.entity.func_184187_bx() != null && this.entity.func_184187_bx().shouldRiderSit();
        }
        super.func_225598_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    public void func_225597_a_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.entity = entity;
        this.field_217112_c = entity.func_70678_g(TRenderHelper.getRenderPartialTicks());
        if (entity instanceof ArmorStandEntity) {
            this.setRotationAnglesArmorStand(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
        if (entity instanceof SkeletonEntity) {
            this.setRotationAnglesSkeleton(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        } else if (entity instanceof ZombieEntity) {
            this.setRotationAnglesZombie(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        } else {
            super.func_225597_a_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }

    public void setRotationAnglesZombie(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.func_225597_a_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        float f6 = MathHelper.func_76126_a((float)(this.field_217112_c * (float)Math.PI));
        float f7 = MathHelper.func_76126_a((float)((1.0f - (1.0f - this.field_217112_c) * (1.0f - this.field_217112_c)) * 3.141593f));
        this.field_178723_h.field_78808_h = 0.0f;
        this.field_178724_i.field_78808_h = 0.0f;
        this.field_178723_h.field_78796_g = -(0.1f - f6 * 0.6f);
        this.field_178724_i.field_78796_g = 0.1f - f6 * 0.6f;
        this.field_178723_h.field_78795_f = -1.570796f;
        this.field_178724_i.field_78795_f = -1.570796f;
        this.field_178723_h.field_78795_f -= f6 * 1.2f - f7 * 0.4f;
        this.field_178724_i.field_78795_f -= f6 * 1.2f - f7 * 0.4f;
        this.field_178723_h.field_78808_h += MathHelper.func_76134_b((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        this.field_178724_i.field_78808_h -= MathHelper.func_76134_b((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        this.field_178723_h.field_78795_f += MathHelper.func_76126_a((float)(ageInTicks * 0.067f)) * 0.05f;
        this.field_178724_i.field_78795_f -= MathHelper.func_76126_a((float)(ageInTicks * 0.067f)) * 0.05f;
    }

    public void setRotationAnglesArmorStand(T ent, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (ent instanceof ArmorStandEntity) {
            ArmorStandEntity entityarmorstand = (ArmorStandEntity)ent;
            this.field_78116_c.field_78795_f = 0.01745329f * entityarmorstand.func_175418_s().func_179415_b();
            this.field_78116_c.field_78796_g = 0.01745329f * entityarmorstand.func_175418_s().func_179416_c();
            this.field_78116_c.field_78808_h = 0.01745329f * entityarmorstand.func_175418_s().func_179413_d();
            this.field_78116_c.func_78793_a(0.0f, 1.0f, 0.0f);
            this.field_78115_e.field_78795_f = 0.01745329f * entityarmorstand.func_175408_t().func_179415_b();
            this.field_78115_e.field_78796_g = 0.01745329f * entityarmorstand.func_175408_t().func_179416_c();
            this.field_78115_e.field_78808_h = 0.01745329f * entityarmorstand.func_175408_t().func_179413_d();
            this.field_178724_i.field_78795_f = 0.01745329f * entityarmorstand.func_175404_u().func_179415_b();
            this.field_178724_i.field_78796_g = 0.01745329f * entityarmorstand.func_175404_u().func_179416_c();
            this.field_178724_i.field_78808_h = 0.01745329f * entityarmorstand.func_175404_u().func_179413_d();
            this.field_178723_h.field_78795_f = 0.01745329f * entityarmorstand.func_175411_v().func_179415_b();
            this.field_178723_h.field_78796_g = 0.01745329f * entityarmorstand.func_175411_v().func_179416_c();
            this.field_178723_h.field_78808_h = 0.01745329f * entityarmorstand.func_175411_v().func_179413_d();
            this.field_178722_k.field_78795_f = 0.01745329f * entityarmorstand.func_175403_w().func_179415_b();
            this.field_178722_k.field_78796_g = 0.01745329f * entityarmorstand.func_175403_w().func_179416_c();
            this.field_178722_k.field_78808_h = 0.01745329f * entityarmorstand.func_175403_w().func_179413_d();
            this.field_178722_k.func_78793_a(1.9f, 11.0f, 0.0f);
            this.field_178721_j.field_78795_f = 0.01745329f * entityarmorstand.func_175407_x().func_179415_b();
            this.field_178721_j.field_78796_g = 0.01745329f * entityarmorstand.func_175407_x().func_179416_c();
            this.field_178721_j.field_78808_h = 0.01745329f * entityarmorstand.func_175407_x().func_179413_d();
            this.field_178721_j.func_78793_a(-1.9f, 11.0f, 0.0f);
            this.field_178720_f.func_217177_a(this.field_78116_c);
        }
    }

    public void setRotationAnglesSkeleton(T ent, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        SkeletonEntity skele;
        super.func_225597_a_(ent, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ItemStack itemstack = ent.func_184614_ca();
        if (ent instanceof SkeletonEntity && (skele = (SkeletonEntity)ent).func_213398_dR() && (itemstack.func_190926_b() || !(itemstack.func_77973_b() instanceof BowItem))) {
            float f = MathHelper.func_76126_a((float)(this.field_217112_c * (float)Math.PI));
            float f1 = MathHelper.func_76126_a((float)((1.0f - (1.0f - this.field_217112_c) * (1.0f - this.field_217112_c)) * (float)Math.PI));
            this.field_178723_h.field_78808_h = 0.0f;
            this.field_178724_i.field_78808_h = 0.0f;
            this.field_178723_h.field_78796_g = -(0.1f - f * 0.6f);
            this.field_178724_i.field_78796_g = 0.1f - f * 0.6f;
            this.field_178723_h.field_78795_f = -1.5707964f;
            this.field_178724_i.field_78795_f = -1.5707964f;
            this.field_178723_h.field_78795_f -= f * 1.2f - f1 * 0.4f;
            this.field_178724_i.field_78795_f -= f * 1.2f - f1 * 0.4f;
            this.field_178723_h.field_78808_h += MathHelper.func_76134_b((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
            this.field_178724_i.field_78808_h -= MathHelper.func_76134_b((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
            this.field_178723_h.field_78795_f += MathHelper.func_76126_a((float)(ageInTicks * 0.067f)) * 0.05f;
            this.field_178724_i.field_78795_f -= MathHelper.func_76126_a((float)(ageInTicks * 0.067f)) * 0.05f;
        }
    }
}

