/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.guis.vm;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.LockIconButton;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.tardis.mod.client.ClientHelper;
import net.tardis.mod.client.guis.INeedWorlds;
import net.tardis.mod.client.guis.vm.VortexMFunctionScreen;
import net.tardis.mod.client.guis.widgets.TextButton;
import net.tardis.mod.config.TConfig;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.helper.TextHelper;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.VMTeleportMessage;

public class VortexMTeleportGui
extends VortexMFunctionScreen
implements INeedWorlds {
    private final TranslationTextComponent title = new TranslationTextComponent("gui.vm.teleport.title");
    private final TranslationTextComponent tp_type = new TranslationTextComponent("gui.vm.teleport.tp_type");
    private final TranslationTextComponent warning = new TranslationTextComponent("gui.vm.teleport.precise_warning");
    private final TranslationTextComponent TP_TOP = new TranslationTextComponent("gui.vm.teleport.setting.top");
    private final TranslationTextComponent TP_PRECISE = new TranslationTextComponent("gui.vm.teleport.setting.precise");
    private final TranslationTextComponent TP_BUTTON = new TranslationTextComponent("gui.vm.teleport.tp");
    private TextFieldWidget xCoord;
    private TextFieldWidget yCoord;
    private TextFieldWidget zCoord;
    private Button selectedDim;
    private LockIconButton dimensionToggle;
    private Button teleport;
    private Button back;
    private Button teleportSetting;
    private boolean preciseTeleport = false;
    private boolean useCurrentDim = true;
    private int settingId = 0;
    private List<RegistryKey<World>> worldKeys = new ArrayList<RegistryKey<World>>();
    private RegistryKey<World> selectedWorld;
    private int index = 0;

    public VortexMTeleportGui(ITextComponent title) {
        super(title);
    }

    public VortexMTeleportGui() {
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.selectedWorld = this.field_230706_i_.field_71439_g.field_70170_p.func_234923_W_();
        int btnH = 20;
        int n = this.getMinX() + 35;
        int n2 = this.getMaxY() + 40;
        this.field_230712_o_.getClass();
        this.xCoord = new TextFieldWidget(this.field_230712_o_, n, n2, 50, 9 + 2, (ITextComponent)new TranslationTextComponent(""));
        int n3 = this.getMinX() + 105;
        int n4 = this.getMaxY() + 40;
        this.field_230712_o_.getClass();
        this.yCoord = new TextFieldWidget(this.field_230712_o_, n3, n4, 50, 9 + 2, (ITextComponent)new TranslationTextComponent(""));
        int n5 = this.getMinX() + 175;
        int n6 = this.getMaxY() + 40;
        this.field_230712_o_.getClass();
        this.zCoord = new TextFieldWidget(this.field_230712_o_, n5, n6, 50, 9 + 2, (ITextComponent)new TranslationTextComponent(""));
        this.teleport = new Button(this.getMinX() + 95, this.getMaxY() + 125, this.field_230712_o_.func_78256_a(this.TP_BUTTON.getString()) + 10, 20, (ITextComponent)this.TP_BUTTON, new Button.IPressable(){

            public void onPress(Button button) {
                VortexMTeleportGui.this.checkPosInput();
            }
        });
        this.back = new TextButton(this.getMaxX() + 5, this.getMaxY() + 5, TardisConstants.Translations.GUI_BACK, new Button.IPressable(){

            public void onPress(Button button) {
                ClientHelper.openGUI(5, null);
            }
        });
        int n7 = this.getMinX() + 20;
        int n8 = this.getMaxY() + 85;
        this.field_230712_o_.getClass();
        this.teleportSetting = new Button(n7, n8, 55, 9 + 11, (ITextComponent)this.TP_TOP, new Button.IPressable(){

            public void onPress(Button button) {
                VortexMTeleportGui.this.incrementId();
                switch (VortexMTeleportGui.this.settingId) {
                    case 0: {
                        VortexMTeleportGui.this.teleportSetting.func_238482_a_((ITextComponent)VortexMTeleportGui.this.TP_TOP);
                        VortexMTeleportGui.this.setTeleportType(!VortexMTeleportGui.this.preciseTeleport);
                        break;
                    }
                    case 1: {
                        VortexMTeleportGui.this.teleportSetting.func_238482_a_((ITextComponent)VortexMTeleportGui.this.TP_PRECISE);
                        VortexMTeleportGui.this.setTeleportType(!VortexMTeleportGui.this.preciseTeleport);
                    }
                }
            }
        });
        this.dimensionToggle = new LockIconButton(this.getMinX() + 95, this.getMaxY() + 85, new Button.IPressable(){

            public void onPress(Button button) {
                boolean currentSetting = VortexMTeleportGui.this.useCurrentDim;
                VortexMTeleportGui.this.useCurrentDim = !currentSetting;
                VortexMTeleportGui.this.dimensionToggle.func_175229_b(VortexMTeleportGui.this.useCurrentDim);
                if (!VortexMTeleportGui.this.useCurrentDim) {
                    ((VortexMTeleportGui)VortexMTeleportGui.this).selectedDim.field_230693_o_ = true;
                } else {
                    ((VortexMTeleportGui)VortexMTeleportGui.this).selectedDim.field_230693_o_ = false;
                    VortexMTeleportGui.this.selectedWorld = ((VortexMTeleportGui)VortexMTeleportGui.this).field_230706_i_.field_71439_g.field_70170_p.func_234923_W_();
                    VortexMTeleportGui.this.selectedDim.func_238482_a_((ITextComponent)new StringTextComponent(VortexMTeleportGui.this.selectedWorld.func_240901_a_().toString()));
                }
            }
        });
        int n9 = this.getMinX() + 120;
        int n10 = this.getMaxY() + 85;
        this.field_230712_o_.getClass();
        this.selectedDim = new Button(n9, n10, 120, 9 + 11, (ITextComponent)new StringTextComponent(""), new Button.IPressable(){

            public void onPress(Button button) {
                VortexMTeleportGui.this.modIndex(1);
            }
        });
        this.field_230710_m_.clear();
        this.func_230480_a_((Widget)this.teleport);
        this.func_230480_a_((Widget)this.xCoord);
        this.func_230480_a_((Widget)this.yCoord);
        this.func_230480_a_((Widget)this.zCoord);
        this.func_230480_a_((Widget)this.back);
        this.func_230480_a_((Widget)this.teleportSetting);
        this.func_230480_a_((Widget)this.dimensionToggle);
        this.func_230480_a_((Widget)this.selectedDim);
        this.xCoord.func_146195_b(true);
        this.dimensionToggle.func_175229_b(this.useCurrentDim);
        this.selectedDim.field_230693_o_ = !this.dimensionToggle.func_175230_c();
        this.selectedDim.func_238482_a_((ITextComponent)new StringTextComponent(this.selectedWorld.func_240901_a_().toString()));
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        VortexMTeleportGui.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)this.title.getString(), (int)(this.getMinX() + 135), (int)(this.getMaxY() + 20), (int)0xFFFFFF);
        VortexMTeleportGui.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)"X:", (int)(this.getMinX() + 28), (int)(this.getMaxY() + 41), (int)0xFFFFFF);
        VortexMTeleportGui.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)"Y:", (int)(this.getMinX() + 98), (int)(this.getMaxY() + 41), (int)0xFFFFFF);
        VortexMTeleportGui.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)"Z:", (int)(this.getMinX() + 168), (int)(this.getMaxY() + 41), (int)0xFFFFFF);
        VortexMTeleportGui.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)this.tp_type.getString(), (int)(this.getMinX() + 50), (int)(this.getMaxY() + 70), (int)0xFFFFFF);
        VortexMTeleportGui.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)TardisConstants.Translations.TARGET_DIM.getString(), (int)(this.getMinX() + 150), (int)(this.getMaxY() + 70), (int)0xFFFFFF);
        this.displayTextBoxCoords(this.xCoord, COORD_TYPE.X);
        this.displayTextBoxCoords(this.yCoord, COORD_TYPE.Y);
        this.displayTextBoxCoords(this.zCoord, COORD_TYPE.Z);
    }

    @Override
    public boolean func_231178_ax__() {
        return true;
    }

    @Override
    public void func_231175_as__() {
        super.func_231175_as__();
    }

    @Override
    public boolean func_231177_au__() {
        return true;
    }

    private void checkPosInput() {
        boolean withinRange;
        boolean isValid = this.isStringNumeric(this.xCoord.func_146179_b(), COORD_TYPE.X) && this.isStringNumeric(this.yCoord.func_146179_b(), COORD_TYPE.Y) && this.isStringNumeric(this.zCoord.func_146179_b(), COORD_TYPE.Z);
        boolean bl = withinRange = this.isWithinConfigRange(this.xCoord.func_146179_b(), COORD_TYPE.X) && this.isWithinConfigRange(this.yCoord.func_146179_b(), COORD_TYPE.Y) && this.isWithinConfigRange(this.zCoord.func_146179_b(), COORD_TYPE.Z);
        if (isValid && withinRange) {
            BlockPos tpPos = new BlockPos(this.getInt(this.xCoord.func_146179_b(), COORD_TYPE.X), this.getInt(this.yCoord.func_146179_b(), COORD_TYPE.Y), this.getInt(this.zCoord.func_146179_b(), COORD_TYPE.Z));
            Network.sendToServer(new VMTeleportMessage(tpPos, this.selectedWorld, this.preciseTeleport, !this.useCurrentDim));
        }
    }

    private boolean isStringNumeric(String input, COORD_TYPE type) {
        if (input != null && !input.isEmpty()) {
            try {
                Integer.parseInt(input);
                return true;
            }
            catch (NumberFormatException nfe) {
                this.field_230706_i_.field_71439_g.func_146105_b((ITextComponent)TextHelper.createVortexManipMessage((IFormattableTextComponent)new TranslationTextComponent("message.vm.invalidInput", new Object[]{type.toString()})), false);
                return false;
            }
        }
        return input.isEmpty();
    }

    private int getInt(String num, COORD_TYPE type) {
        if (this.isStringNumeric(num, type)) {
            if (num.isEmpty()) {
                return this.getDefaultCoordInt(type);
            }
            return Integer.parseInt(num);
        }
        return this.getDefaultCoordInt(type);
    }

    private void displayTextBoxCoords(TextFieldWidget widget, COORD_TYPE type) {
        if (widget.func_230999_j_()) {
            widget.func_195612_c("");
        } else if (widget.func_146179_b().isEmpty()) {
            widget.func_195612_c(Integer.toString(this.getDefaultCoordInt(type)));
        }
    }

    private int getDefaultCoordInt(COORD_TYPE type) {
        switch (type) {
            case X: {
                return (int)this.field_230706_i_.field_71439_g.func_226277_ct_();
            }
            case Y: {
                return (int)this.field_230706_i_.field_71439_g.func_226278_cu_();
            }
            case Z: {
                return (int)this.field_230706_i_.field_71439_g.func_226281_cx_();
            }
        }
        return 0;
    }

    public boolean getTeleportType() {
        return this.preciseTeleport;
    }

    public void setTeleportType(boolean type) {
        this.preciseTeleport = type;
    }

    public boolean isWithinConfigRange(String num, COORD_TYPE type) {
        if (this.getInt(num, type) - this.getDefaultCoordInt(type) <= (Integer)TConfig.SERVER.vmTeleportRange.get()) {
            return true;
        }
        this.field_230706_i_.field_71439_g.func_146105_b((ITextComponent)TextHelper.createVortexManipMessage((IFormattableTextComponent)new TranslationTextComponent("message.vm.illegalPos", new Object[]{TConfig.SERVER.vmTeleportRange.get(), type.toString()})), false);
        return false;
    }

    public void incrementId() {
        this.settingId = this.settingId + 1 > 1 ? 0 : ++this.settingId;
    }

    @Override
    public int getMinY() {
        return super.getMinY();
    }

    @Override
    public int getMinX() {
        return super.getMinX();
    }

    @Override
    public int getMaxX() {
        return super.getMaxX();
    }

    @Override
    public int getMaxY() {
        return super.getMaxY();
    }

    @Override
    public int texWidth() {
        return super.texWidth();
    }

    @Override
    public int texHeight() {
        return super.texHeight();
    }

    private void modIndex(int amount) {
        int temp = this.index + amount;
        if (temp < this.worldKeys.size() && temp > 0) {
            this.index = temp;
        }
        if (temp > this.worldKeys.size() - 1) {
            this.index = 0;
        } else if (temp < 0) {
            this.index = this.worldKeys.size() - 1;
        }
        if (!this.worldKeys.isEmpty()) {
            this.selectedWorld = this.worldKeys.get(this.index);
            StringTextComponent text = new StringTextComponent(this.selectedWorld != null ? this.selectedWorld.func_240901_a_().toString() : "");
            this.selectedDim.func_238482_a_((ITextComponent)text);
        }
    }

    @Override
    public void setWorldsFromServer(List<RegistryKey<World>> worlds) {
        this.worldKeys.clear();
        this.worldKeys.addAll(worlds);
    }

    public static enum COORD_TYPE {
        X,
        Y,
        Z;

    }
}

