/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.guis.monitors;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.tardis.mod.client.guis.monitors.IMonitorGui;
import net.tardis.mod.client.guis.monitors.MonitorScreen;
import net.tardis.mod.client.guis.monitors.WaypointMonitorScreen;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.WaypointOpenMessage;
import net.tardis.mod.network.packets.WaypointSaveMessage;
import net.tardis.mod.tileentities.ConsoleTile;

public class WaypointNewMonitorScreen
extends MonitorScreen {
    private final TranslationTextComponent title = new TranslationTextComponent("gui.tardis.waypoint.new.title");
    private final TranslationTextComponent desc = new TranslationTextComponent("gui.tardis.waypoint.new.desc");
    private final TranslationTextComponent suggestion = new TranslationTextComponent("gui.tardis.waypoint.new.suggestion");
    private TextFieldWidget waypointName;

    public WaypointNewMonitorScreen(IMonitorGui mon) {
        super(mon, "waypoint_new");
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.field_230710_m_.clear();
        this.func_230480_a_((Widget)this.createButton(this.parent.getMinX(), this.parent.getMinY(), (TextComponent)TardisConstants.Translations.GUI_CANCEL, but -> {
            Minecraft.func_71410_x().func_147108_a((Screen)new WaypointMonitorScreen(this.parent, "waypoints"));
            Network.sendToServer(new WaypointOpenMessage(null));
        }));
        this.func_230480_a_((Widget)this.createButton(this.parent.getMinX(), this.parent.getMinY(), (TextComponent)TardisConstants.Translations.GUI_SAVE, but -> {
            Network.sendToServer(new WaypointSaveMessage(this.waypointName.func_146179_b().isEmpty() ? "EmptyName" : this.waypointName.func_146179_b()));
            Minecraft.func_71410_x().func_147108_a(null);
        }));
        int centerX = this.parent.getMinX() + (this.parent.getMaxX() - this.parent.getMinX()) / 2;
        int width = 150;
        this.waypointName = new TextFieldWidget(this.field_230712_o_, centerX - width / 2, this.parent.getMaxY() + 40, width, 20, (ITextComponent)new TranslationTextComponent("Test"));
        this.func_230480_a_((Widget)this.waypointName);
        this.waypointName.func_195612_c(this.suggestion.getString());
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int p_render_1_, int p_render_2_, float p_render_3_) {
        super.func_230430_a_(matrixStack, p_render_1_, p_render_2_, p_render_3_);
        int centerX = this.parent.getMinX() + (this.parent.getMaxX() - this.parent.getMinX()) / 2;
        WaypointNewMonitorScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)this.title.getString(), (int)centerX, (int)(this.parent.getMaxY() + 10), (int)0xFFFFFF);
        WaypointNewMonitorScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)this.desc.getString(), (int)centerX, (int)(this.parent.getMaxY() + 30), (int)0xFFFFFF);
        if (this.waypointName.func_230999_j_()) {
            this.waypointName.func_195612_c("");
        } else if (this.waypointName.func_146179_b().isEmpty()) {
            this.waypointName.func_195612_c(this.suggestion.getString());
        }
        TileEntity te = this.field_230706_i_.field_71441_e.func_175625_s(TardisHelper.TARDIS_POS);
        if (te instanceof ConsoleTile && te != null) {
            ConsoleTile con = (ConsoleTile)te;
            int width = 150;
            this.field_230712_o_.func_238421_b_(matrixStack, TardisConstants.Translations.LOCATION.getString() + WorldHelper.formatBlockPos(con.getCurrentLocation()), (float)(centerX - width / 2), (float)(this.parent.getMaxY() + 70), 0xFFFFFF);
            this.field_230712_o_.func_238421_b_(matrixStack, TardisConstants.Translations.DIMENSION.getString() + WorldHelper.formatDimName(con.getCurrentDimension()), (float)(centerX - width / 2), (float)(this.parent.getMaxY() + 80), 0xFFFFFF);
            this.field_230712_o_.func_238421_b_(matrixStack, TardisConstants.Translations.FACING.getString() + con.getExteriorFacingDirection().func_176742_j(), (float)(centerX - width / 2), (float)(this.parent.getMaxY() + 90), 0xFFFFFF);
        }
    }
}

