/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.guis.monitors;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.tardis.mod.client.guis.monitors.IMonitorGui;
import net.tardis.mod.client.guis.monitors.MonitorConfirmScreen;
import net.tardis.mod.client.guis.monitors.MonitorScreen;
import net.tardis.mod.client.guis.monitors.WaypointNewMonitorScreen;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.misc.SpaceTimeCoord;
import net.tardis.mod.misc.WaypointWrapper;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.WaypointDeleteMessage;
import net.tardis.mod.network.packets.WaypointLoadMessage;
import net.tardis.mod.network.packets.WaypointOpenMessage;

public class WaypointMonitorScreen
extends MonitorScreen {
    private List<WaypointWrapper> list = new ArrayList<WaypointWrapper>();
    private WaypointWrapper coord;
    private int index = 0;
    private boolean hasBanks = false;
    private TranslationTextComponent waypoint_title = new TranslationTextComponent("gui.tardis.waypoint.title");
    private TranslationTextComponent waypoint_name = new TranslationTextComponent("gui.tardis.waypoint.name");
    private TranslationTextComponent waypoint_bank_position = new TranslationTextComponent("gui.tardis.waypoint.waypoint_bank_position");

    public WaypointMonitorScreen(IMonitorGui monitor, String menu) {
        super(monitor, menu);
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_((Widget)this.createButton(this.parent.getMinX(), this.parent.getMinY(), (TextComponent)TardisConstants.Translations.GUI_PREV, press -> this.change(-1)));
        this.func_230480_a_((Widget)this.createButton(this.parent.getMinX(), this.parent.getMinY(), (TextComponent)TardisConstants.Translations.GUI_SELECT, press -> {
            if (this.coord != null) {
                Network.sendToServer(new WaypointLoadMessage(this.coord.bankPos, this.coord.index));
            }
            Minecraft.func_71410_x().func_147108_a(null);
        }));
        this.func_230480_a_((Widget)this.createButton(this.parent.getMinX(), this.parent.getMinY(), (TextComponent)MonitorScreen.nextTranslation, press -> this.change(1)));
        this.func_230480_a_((Widget)this.createButton(this.parent.getMinX(), this.parent.getMinY() - 5, (TextComponent)new StringTextComponent("> " + new TranslationTextComponent("gui.tardis.waypoint.new").getString()), pres -> Minecraft.func_71410_x().func_147108_a((Screen)new WaypointNewMonitorScreen(this.parent))));
        this.func_230480_a_((Widget)this.createButton(this.parent.getMinX(), this.parent.getMinY() - 6, (TextComponent)new StringTextComponent("> " + new TranslationTextComponent("gui.tardis.waypoint.delete").getString()), pres -> this.confirmAction()));
        this.change(0);
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float p_render_3_) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, p_render_3_);
        WaypointMonitorScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)this.waypoint_title.getString(), (int)(this.parent.getMinX() + (this.parent.getMaxX() - this.parent.getMinX()) / 2), (int)this.parent.getMaxY(), (int)0xFFFFFF);
        if (this.coord != null) {
            String waypointName = this.coord.coord.getName().isEmpty() ? this.waypoint_name.func_230532_e_().func_230529_a_((ITextComponent)new TranslationTextComponent("message.tardis.generic_none").func_230532_e_()).getString() : this.waypoint_name.func_230532_e_().func_240702_b_(this.coord.coord.getName()).getString();
            this.field_230712_o_.func_238421_b_(matrixStack, waypointName, (float)this.parent.getMinX(), (float)(this.parent.getMaxY() + 23), 0xFFFFFF);
            String string = TardisConstants.Translations.LOCATION.getString() + WorldHelper.formatBlockPos(this.coord.coord.getPos());
            float f = this.parent.getMinX();
            int n = this.parent.getMaxY();
            this.field_230712_o_.getClass();
            this.field_230712_o_.func_238421_b_(matrixStack, string, f, (float)(n + (9 * 4 - 3)), 0xFFFFFF);
            String string2 = TardisConstants.Translations.DIMENSION.getString() + WorldHelper.formatDimName(this.coord.coord.getDim());
            float f2 = this.parent.getMinX();
            int n2 = this.parent.getMaxY();
            this.field_230712_o_.getClass();
            this.field_230712_o_.func_238421_b_(matrixStack, string2, f2, (float)(n2 + (9 * 5 - 3)), 0xFFFFFF);
            String string3 = TardisConstants.Translations.FACING.getString() + this.coord.coord.getFacing().func_176742_j();
            float f3 = this.parent.getMinX();
            int n3 = this.parent.getMaxY();
            this.field_230712_o_.getClass();
            this.field_230712_o_.func_238421_b_(matrixStack, string3, f3, (float)(n3 + (9 * 6 - 3)), 0xFFFFFF);
            String waypointBankPos = this.waypoint_bank_position.func_230532_e_().func_240702_b_(WorldHelper.formatBlockPos(this.coord.bankPos)).getString();
            float f4 = this.parent.getMinX();
            int n4 = this.parent.getMaxY();
            this.field_230712_o_.getClass();
            this.field_230712_o_.func_238421_b_(matrixStack, waypointBankPos, f4, (float)(n4 + (9 * 7 - 3)), 0xFFFFFF);
        } else if (this.hasBanks) {
            this.field_230712_o_.func_238421_b_(matrixStack, new TranslationTextComponent("gui.tardis.waypoint.no_saved").getString(), (float)this.parent.getMinX(), (float)(this.parent.getMaxY() + 23), 0xFFFFFF);
        } else {
            this.field_230712_o_.func_238421_b_(matrixStack, new TranslationTextComponent("gui.tardis.waypoint.no_banks").getString(), (float)this.parent.getMinX(), (float)(this.parent.getMaxY() + 23), 0xFFFFFF);
        }
    }

    public void change(int i) {
        if (this.list == null || this.list.isEmpty()) {
            this.index = 0;
            return;
        }
        this.index = this.index + i >= this.list.size() ? 0 : (this.index + i < 0 ? this.list.size() - 1 : (this.index += i));
        this.coord = this.list.get(this.index);
    }

    public void setWaypoints(Map<BlockPos, List<SpaceTimeCoord>> map) {
        this.list.clear();
        if (map == null) {
            this.hasBanks = false;
            return;
        }
        this.hasBanks = map.size() > 0;
        for (Map.Entry<BlockPos, List<SpaceTimeCoord>> entry : map.entrySet()) {
            int index = 0;
            for (SpaceTimeCoord coord : entry.getValue()) {
                this.list.add(new WaypointWrapper(entry.getKey(), coord, index));
                ++index;
            }
        }
        this.list.removeIf(wrap -> wrap.coord.equals(SpaceTimeCoord.UNIVERAL_CENTER));
        this.change(0);
    }

    private void confirmAction() {
        if (this.coord == null) {
            return;
        }
        this.getMinecraft().func_147108_a((Screen)new MonitorConfirmScreen(this.parent, this.menu, shouldChange -> {
            if (shouldChange) {
                Network.sendToServer(new WaypointDeleteMessage(this.coord.bankPos, this.index));
                this.field_230706_i_.func_147108_a(null);
            } else {
                Network.sendToServer(new WaypointOpenMessage(null));
                this.field_230706_i_.func_147108_a((Screen)new WaypointMonitorScreen(this.parent, "waypoints"));
            }
        }, new TranslationTextComponent("gui.tardis.waypoint.delete.confirm_title"), new TranslationTextComponent("gui.tardis.waypoint.delete.confirm_message"), TardisConstants.Translations.GUI_CONFIRM, TardisConstants.Translations.GUI_CANCEL));
    }
}

