/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.guis.monitors;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.tardis.mod.client.ClientHelper;
import net.tardis.mod.client.guis.monitors.IMonitorGui;
import net.tardis.mod.client.guis.monitors.InteriorHumsScreen;
import net.tardis.mod.client.guis.monitors.MonitorScreen;
import net.tardis.mod.client.guis.monitors.SoundSchemeMonitorScreen;
import net.tardis.mod.client.guis.widgets.IntSliderWidget;
import net.tardis.mod.client.guis.widgets.TextButton;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.misc.TexVariant;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.ConsoleVariantMessage;
import net.tardis.mod.tileentities.ConsoleTile;

public class InteriorEditScreen
extends MonitorScreen {
    private final ConsoleTile tile;
    private final TranslationTextComponent lightLevelText = new TranslationTextComponent("gui.tardis.protocol.interior_properties.interior_light_level");
    private final TranslationTextComponent console_variant = new TranslationTextComponent("gui.tardis.protocol.interior_properties.console_variant");
    public IntSliderWidget lightSlider;
    private TextButton texVarButton;
    private int texIndex = 0;
    private TexVariant selected;

    public InteriorEditScreen(IMonitorGui gui, String submenu) {
        super(gui, submenu);
        this.tile = TardisHelper.getConsoleInWorld((World)Minecraft.func_71410_x().field_71441_e).orElse(null);
        if (this.tile != null) {
            int index = 0;
            for (TexVariant v : this.tile.getTextureVariants()) {
                if (v == this.tile.getVariant()) break;
                ++index;
            }
            this.texIndex = index;
        }
    }

    public void func_231158_b_(Minecraft p_init_1_, int p_init_2_, int p_init_3_) {
        super.func_231158_b_(p_init_1_, p_init_2_, p_init_3_);
        if (this.parent instanceof Screen) {
            ((Screen)this.parent).func_231158_b_(p_init_1_, p_init_2_, p_init_3_);
        }
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        double sliderVal = 0.1;
        TileEntity te = this.field_230706_i_.field_71441_e.func_175625_s(TardisHelper.TARDIS_POS);
        if (te instanceof ConsoleTile) {
            sliderVal = (double)((ConsoleTile)te).getInteriorManager().getLight() / 15.0;
        }
        this.lightSlider = new IntSliderWidget(this.parent.getMinX(), this.parent.getMinY() - 10, 100, 20, (ITextComponent)new TranslationTextComponent("gui.tardis.protocol.interior_properties.interior_light_level.slider"), sliderVal);
        this.func_230480_a_((Widget)this.lightSlider);
        this.func_230480_a_((Widget)new TextButton(this.parent.getMinX(), this.parent.getMinY() - 30, "> " + new TranslationTextComponent("gui.tardis.protocol.interior_properties.hum").getString(), but -> Minecraft.func_71410_x().func_147108_a((Screen)new InteriorHumsScreen(this.parent, "interior_hum"))));
        if (this.tile.getTextureVariants().length > 0) {
            this.modTexture(0);
            this.texVarButton = new TextButton(this.parent.getMinX(), this.parent.getMinY() - 40, this.console_variant.getString() + this.selected.getTranslation().getString(), but -> this.modTexture(1));
            this.func_230480_a_((Widget)this.texVarButton);
        }
        this.addSubmenu((TextComponent)new TranslationTextComponent("gui.tardis.protocol.interior_properties.sound_scheme"), but -> ClientHelper.openGui(new SoundSchemeMonitorScreen(this.parent, "sound_scheme")));
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        for (Widget w : this.field_230710_m_) {
            w.func_230431_b_(matrixStack, mouseX, mouseY, partialTicks);
        }
        InteriorEditScreen.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)this.lightLevelText.func_150261_e(), (int)this.parent.getMinX(), (int)(this.parent.getMinY() - 20), (int)0xFFFFFF);
    }

    @Override
    public int getUsedHeight() {
        return 50;
    }

    public void modTexture(int i) {
        this.texIndex = this.texIndex + i >= this.tile.getTextureVariants().length ? 0 : (this.texIndex + i < 0 ? this.tile.getTextureVariants().length - 1 : (this.texIndex += i));
        this.selected = this.tile.getTextureVariants()[this.texIndex];
        if (this.texVarButton != null) {
            this.texVarButton.func_238482_a_((ITextComponent)new TranslationTextComponent(this.console_variant.getString() + this.selected.getTranslation().getString()));
        }
        Network.sendToServer(new ConsoleVariantMessage(this.texIndex));
    }
}

