/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.guis.monitors;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.tardis.mod.ars.ConsoleRoom;
import net.tardis.mod.client.ClientHelper;
import net.tardis.mod.client.guis.monitors.IMonitorGui;
import net.tardis.mod.client.guis.monitors.MonitorConfirmScreen;
import net.tardis.mod.client.guis.monitors.MonitorScreen;
import net.tardis.mod.client.guis.widgets.TextButton;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.ChangeInteriorMessage;

public class InteriorChangeScreen
extends MonitorScreen {
    private List<ConsoleRoom> rooms = new ArrayList<ConsoleRoom>();
    private int index = 0;

    public InteriorChangeScreen(IMonitorGui mon, String menu) {
        super(mon, menu);
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_((Widget)new TextButton(this.parent.getMinX(), this.parent.getMinY(), TardisConstants.Translations.GUI_PREV.getString(), button -> this.modIndex(-1)));
        int n = this.parent.getMinX();
        int n2 = this.parent.getMinY();
        this.field_230706_i_.field_71466_p.getClass();
        this.func_230480_a_((Widget)new TextButton(n, n2 - (int)(9.0 * 1.25), TardisConstants.Translations.GUI_SELECT.getString(), button -> this.confirmAction()));
        int n3 = this.parent.getMinX();
        int n4 = this.parent.getMinY();
        this.field_230706_i_.field_71466_p.getClass();
        this.func_230480_a_((Widget)new TextButton(n3, n4 - (int)(9.0 * 1.25 * 2.0), TardisConstants.Translations.GUI_NEXT.getString(), button -> this.modIndex(1)));
        this.rooms.clear();
        TardisHelper.getConsoleInWorld((World)Minecraft.func_71410_x().field_71441_e).ifPresent(tile -> {
            this.rooms.addAll(tile.getUnlockManager().getUnlockedConsoleRooms());
            if (!this.rooms.contains(tile.getConsoleRoom())) {
                this.rooms.add(tile.getConsoleRoom());
            }
            int temp = 0;
            for (ConsoleRoom r : this.rooms) {
                if (r == tile.getConsoleRoom()) {
                    this.index = temp;
                    break;
                }
                ++temp;
            }
        });
        this.modIndex(0);
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        ConsoleRoom room = this.getRoomFromIndex();
        if (room != null) {
            InteriorChangeScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)(room.isDataPack() ? room.getDisplayName().func_150268_i() : room.getDisplayName().getString()), (int)(this.parent.getMinX() + (this.parent.getMaxX() - this.parent.getMinX()) / 2), (int)(this.parent.getMaxY() + 90), (int)0xFFFFFF);
            if (room.isUsingRemoteImage().get().booleanValue()) {
                this.field_230706_i_.func_110434_K().func_110577_a(this.getTextureForRoom(room));
            } else {
                this.field_230706_i_.func_110434_K().func_110577_a(room.getTexture());
            }
            float asp = 1.77777f;
            int centerX = this.parent.getMinX() + (this.parent.getMaxX() - this.parent.getMinX()) / 2;
            int width = 150;
            int height = (int)((float)width / asp);
            InteriorChangeScreen.func_238463_a_((MatrixStack)matrixStack, (int)(centerX - width / 2), (int)this.parent.getMaxY(), (float)0.0f, (float)0.0f, (int)width, (int)height, (int)width, (int)height);
        }
    }

    private ConsoleRoom getRoomFromIndex() {
        if (this.index < 0 || this.index >= this.rooms.size()) {
            return ConsoleRoom.ARCHITECT;
        }
        return this.rooms.get(this.index);
    }

    private void modIndex(int i) {
        this.index = this.index + i >= this.rooms.size() ? 0 : (this.index + i < 0 ? this.rooms.size() - 1 : (this.index += i));
    }

    private void confirmAction() {
        this.getMinecraft().func_147108_a((Screen)new MonitorConfirmScreen(this.parent, this.menu, shouldChange -> {
            if (shouldChange && this.getRoomFromIndex() != null) {
                Network.sendToServer(new ChangeInteriorMessage(this.getRoomFromIndex().getRegistryName(), false));
                this.field_230706_i_.func_147108_a(null);
            } else {
                this.field_230706_i_.func_147108_a((Screen)new InteriorChangeScreen(this.parent, this.menu));
            }
        }, new TranslationTextComponent("gui.tardis.interior.change.warning_message"), new TranslationTextComponent("gui.tardis.interior.change.confirm_message"), TardisConstants.Translations.GUI_CONFIRM, TardisConstants.Translations.GUI_CANCEL));
    }

    public ResourceLocation getTextureForRoom(ConsoleRoom consoleRoom) {
        if (ClientHelper.INTERIOR_PREVIEW_TEXTURES.containsKey(consoleRoom)) {
            return ClientHelper.INTERIOR_PREVIEW_TEXTURES.get(consoleRoom);
        }
        Thread thread = new Thread(() -> {
            try {
                ClientHelper.INTERIOR_PREVIEW_TEXTURES.put(consoleRoom, ClientHelper.urlToTexture(new URL(consoleRoom.getImageUrl().get())));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        });
        thread.run();
        return ClientHelper.INTERIOR_PREVIEW_TEXTURES.get(consoleRoom);
    }
}

