/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.guis.monitors;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.text.TextComponent;
import net.minecraft.world.World;
import net.tardis.mod.client.guis.monitors.IMonitorGui;
import net.tardis.mod.client.guis.monitors.MonitorScreen;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.exterior.AbstractExterior;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.ExteriorChangeMessage;
import net.tardis.mod.registries.ExteriorRegistry;
import net.tardis.mod.tileentities.ConsoleTile;

public class ExteriorScreen
extends MonitorScreen {
    private List<AbstractExterior> unlockedExteriors = Lists.newArrayList();
    private int index = 0;

    public ExteriorScreen(IMonitorGui monitor, String type) {
        super(monitor, type);
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.unlockedExteriors.clear();
        ConsoleTile console = TardisHelper.getConsoleInWorld((World)this.field_230706_i_.field_71441_e).orElse(null);
        if (console != null) {
            for (AbstractExterior ext : console.getUnlockManager().getUnlockedExteriors()) {
                if (this.unlockedExteriors.contains((Object)ext)) continue;
                this.unlockedExteriors.add(ext);
            }
        }
        this.func_230480_a_((Widget)this.createButton(this.parent.getMinX(), this.parent.getMinY(), (TextComponent)TardisConstants.Translations.GUI_PREV, but -> this.modIndex(-1)));
        this.func_230480_a_((Widget)this.createButton(this.parent.getMinX(), this.parent.getMinY(), (TextComponent)TardisConstants.Translations.GUI_SELECT, but -> {
            Network.sendToServer(new ExteriorChangeMessage(this.getExteriorFromIndex().getRegistryName()));
            Minecraft.func_71410_x().func_147108_a(null);
        }));
        this.func_230480_a_((Widget)this.createButton(this.parent.getMinX(), this.parent.getMinY(), (TextComponent)TardisConstants.Translations.GUI_NEXT, but -> this.modIndex(1)));
        int temp = 0;
        for (AbstractExterior ext : this.unlockedExteriors) {
            if (ext == console.getExteriorType()) {
                this.index = temp;
            }
            ++temp;
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int p_render_1_, int p_render_2_, float p_render_3_) {
        super.func_230430_a_(matrixStack, p_render_1_, p_render_2_, p_render_3_);
        AbstractExterior ext = this.getExteriorFromIndex();
        if (ext != null) {
            this.field_230706_i_.func_110434_K().func_110577_a(ext.getBlueprintPreviewTexture());
            int centerX = this.parent.getMinX() + (this.parent.getMaxX() - this.parent.getMinX()) / 2;
            int width = 100;
            int height = 100;
            ExteriorScreen.func_238463_a_((MatrixStack)matrixStack, (int)(centerX - width / 2), (int)this.parent.getMaxY(), (float)0.0f, (float)0.0f, (int)width, (int)height, (int)width, (int)height);
        }
    }

    public int modIndex(int mod) {
        if (this.index + mod >= this.unlockedExteriors.size()) {
            this.index = 0;
            return 0;
        }
        if (this.index + mod < 0) {
            this.index = this.unlockedExteriors.size() - 1;
            return this.index;
        }
        return this.index += mod;
    }

    public AbstractExterior getExteriorFromIndex() {
        if (this.index < 0 || this.index >= this.unlockedExteriors.size()) {
            this.index = 0;
            return (AbstractExterior)ExteriorRegistry.STEAMPUNK.get();
        }
        return this.unlockedExteriors.get(this.index);
    }
}

