/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.guis.monitors;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.TextComponent;
import net.minecraft.world.World;
import net.tardis.mod.client.guis.monitors.IMonitorGui;
import net.tardis.mod.client.guis.monitors.MonitorScreen;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.misc.Console;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.ConsoleChangeMessage;
import net.tardis.mod.registries.ConsoleRegistry;
import net.tardis.mod.tileentities.ConsoleTile;

public class ConsoleSelectionScreen
extends MonitorScreen {
    private List<Console> consoles = Lists.newArrayList();
    private int index = 0;

    public ConsoleSelectionScreen(IMonitorGui gui, String name) {
        super(gui, name);
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        ConsoleTile currentConsole = (ConsoleTile)Minecraft.func_71410_x().field_71441_e.func_175625_s(TardisHelper.TARDIS_POS);
        if (currentConsole == null) {
            Minecraft.func_71410_x().func_147108_a(null);
            return;
        }
        this.consoles.clear();
        this.consoles.addAll(currentConsole.getUnlockManager().getUnlockedConsoles());
        this.addSubmenu((TextComponent)TardisConstants.Translations.GUI_PREV, button -> this.modIndex(-1));
        this.addSubmenu((TextComponent)TardisConstants.Translations.GUI_SELECT, button -> {
            Network.sendToServer(new ConsoleChangeMessage(this.getSelectedConsole().getRegistryName()));
            this.field_230706_i_.func_147108_a(null);
        });
        this.addSubmenu((TextComponent)TardisConstants.Translations.GUI_NEXT, button -> this.modIndex(1));
        TardisHelper.getConsoleInWorld((World)this.getMinecraft().field_71441_e).ifPresent(tile -> {
            int temp = 0;
            for (Console console : this.consoles) {
                if (console.getState().func_177230_c() == this.getMinecraft().field_71441_e.func_180495_p(tile.func_174877_v()).func_177230_c()) {
                    this.index = temp;
                    break;
                }
                ++temp;
            }
        });
    }

    private Console getSelectedConsole() {
        if (this.index >= this.consoles.size() || this.index < 0) {
            return (Console)ConsoleRegistry.STEAM.get();
        }
        return this.consoles.get(this.index);
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int p_render_1_, int p_render_2_, float p_render_3_) {
        super.func_230430_a_(matrixStack, p_render_1_, p_render_2_, p_render_3_);
        this.getMinecraft().func_110434_K().func_110577_a(this.getSelectedConsole().getPreviewTexture());
        ConsoleSelectionScreen.func_238463_a_((MatrixStack)matrixStack, (int)((this.parent.getMaxX() - this.parent.getMinX()) / 2 + this.parent.getMinX() - 50), (int)this.parent.getMaxY(), (float)0.0f, (float)0.0f, (int)100, (int)100, (int)100, (int)100);
    }

    public void modIndex(int mod) {
        this.index = this.index + mod > this.consoles.size() - 1 ? 0 : (this.index + mod < 0 ? this.consoles.size() - 1 : (this.index += mod));
    }
}

