/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.guis.monitors;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.tardis.mod.client.guis.monitors.ConsoleSelectionScreen;
import net.tardis.mod.client.guis.monitors.ExteriorPropMonitorScreen;
import net.tardis.mod.client.guis.monitors.ExteriorScreen;
import net.tardis.mod.client.guis.monitors.IMonitorGui;
import net.tardis.mod.client.guis.monitors.InfoDisplayScreen;
import net.tardis.mod.client.guis.monitors.InteriorChangeScreen;
import net.tardis.mod.client.guis.monitors.InteriorEditScreen;
import net.tardis.mod.client.guis.monitors.MonitorConfirmScreen;
import net.tardis.mod.client.guis.monitors.MonitorScreen;
import net.tardis.mod.client.guis.monitors.WaypointMonitorScreen;
import net.tardis.mod.client.guis.widgets.TextButton;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.ChangeInteriorMessage;
import net.tardis.mod.network.packets.ProtocolMessage;
import net.tardis.mod.network.packets.WaypointOpenMessage;
import net.tardis.mod.protocols.Protocol;
import net.tardis.mod.registries.ProtocolRegistry;
import net.tardis.mod.tileentities.ConsoleTile;

public abstract class BaseMonitorScreen
extends Screen
implements IMonitorGui {
    public static TranslationTextComponent TITLE = new TranslationTextComponent("gui.tardis.monitor.tardis.steam");
    protected ConsoleTile tile;
    private int id;
    private String menu = "main";

    public BaseMonitorScreen(ITextComponent titleIn) {
        super(titleIn);
    }

    public BaseMonitorScreen() {
        super((ITextComponent)TITLE);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        TardisHelper.getConsoleInWorld((World)this.field_230706_i_.field_71441_e).ifPresent(tile -> {
            this.tile = tile;
        });
        this.id = 0;
        this.field_230710_m_.clear();
        if (this.tile != null) {
            ProtocolRegistry.PROTOCOL_REGISTRY.get().getEntries().forEach(entry -> {
                if (((Protocol)((Object)((Object)entry.getValue()))).getSubmenu().equals(this.menu)) {
                    this.func_230480_a_((Widget)this.addButton(this.getMinX(), this.getMinY(), ((RegistryKey)entry.getKey()).func_240901_a_()));
                }
            });
            this.addSubmenu((TextComponent)new TranslationTextComponent("gui.tardis.protocol.exterior_properties"), but -> Minecraft.func_71410_x().func_147108_a((Screen)new ExteriorPropMonitorScreen(this)));
            this.addSubmenu((TextComponent)new TranslationTextComponent("gui.tardis.protocol.interior_properties"), button -> Minecraft.func_71410_x().func_147108_a((Screen)new InteriorEditScreen(this, "interior")));
            this.addSubmenu((TextComponent)new TranslationTextComponent("gui.tardis.protocol.security"), "security");
            this.addSubmenu((TextComponent)new TranslationTextComponent("gui.tardis.protocol.exterior"), but -> Minecraft.func_71410_x().func_147108_a((Screen)new ExteriorScreen(this, "exterior")));
            this.addSubmenu((TextComponent)new TranslationTextComponent("gui.tardis.protocol.console"), button -> Minecraft.func_71410_x().func_147108_a((Screen)new ConsoleSelectionScreen(this, "console")));
            boolean isCancellingInteriorChange = this.tile.getInteriorManager().isInteriorStillRegenerating();
            if (isCancellingInteriorChange) {
                this.addSubmenu((TextComponent)new TranslationTextComponent("gui.tardis.protocol.interior"), button -> this.cancelInteriorChangeScreen());
            } else {
                this.addSubmenu((TextComponent)new TranslationTextComponent("gui.tardis.protocol.interior"), button -> Minecraft.func_71410_x().func_147108_a((Screen)new InteriorChangeScreen(this, "change_interior")));
            }
            this.addSubmenu((TextComponent)new TranslationTextComponent("gui.tardis.protocol.waypoints"), but -> {
                Minecraft.func_71410_x().func_147108_a((Screen)new WaypointMonitorScreen(this, "waypoints"));
                Network.sendToServer(new WaypointOpenMessage(null));
            });
            if (this.tile.hasNavCom()) {
                this.addSubmenu((TextComponent)new TranslationTextComponent("gui.tardis.protocol.info"), button -> Minecraft.func_71410_x().func_147108_a((Screen)new InfoDisplayScreen(this, "info_display")));
            }
        }
    }

    public void addSubmenu(TextComponent com, Button.IPressable press) {
        int n = this.getMinX();
        int n2 = this.getMinY();
        this.field_230706_i_.field_71466_p.getClass();
        TextButton button = new TextButton(n, n2 - this.id * (int)(9.0 * 1.25), "> " + com.getString(), press);
        this.func_230480_a_((Widget)button);
        ++this.id;
    }

    public void addSubmenu(TextComponent com, String menu) {
        Button.IPressable press = button -> Minecraft.func_71410_x().func_147108_a((Screen)new MonitorScreen(this, menu));
        this.addSubmenu(com, press);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float p_render_3_) {
        this.renderMonitor(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, p_render_3_);
    }

    public boolean func_231178_ax__() {
        return true;
    }

    public void func_231164_f_() {
        super.func_231164_f_();
    }

    public Button addButton(int x, int y, ResourceLocation key) {
        Protocol prot = (Protocol)ProtocolRegistry.PROTOCOL_REGISTRY.get().getValue(key);
        Button.IPressable press = button -> {
            TileEntity te = this.field_230706_i_.field_71441_e.func_175625_s(TardisHelper.TARDIS_POS);
            if (te instanceof ConsoleTile) {
                Network.sendToServer(new ProtocolMessage(prot.getRegistryName()));
                prot.call((World)this.field_230706_i_.field_71441_e, (PlayerEntity)this.field_230706_i_.field_71439_g, (ConsoleTile)te);
            }
        };
        this.field_230706_i_.field_71466_p.getClass();
        TextButton button2 = new TextButton(x, y - this.id * (int)(9.0 * 1.25), "> " + (prot != null ? prot.getDisplayName(this.tile).getString() : "ERROR"), press);
        ++this.id;
        return button2;
    }

    public boolean func_231177_au__() {
        return false;
    }

    private void cancelInteriorChangeScreen() {
        this.getMinecraft().func_147108_a((Screen)new MonitorConfirmScreen(this, this.menu, isCancelling -> {
            if (isCancelling) {
                Network.sendToServer(new ChangeInteriorMessage(this.tile.getNextConsoleRoom().getRegistryName(), true));
                this.field_230706_i_.func_147108_a(null);
            } else {
                this.field_230706_i_.func_147108_a((Screen)this);
            }
        }, new TranslationTextComponent("gui.tardis.interior.change_cancel.warning_message"), new TranslationTextComponent("gui.tardis.interior.cancel_confirm.confirm_message"), TardisConstants.Translations.GUI_CONFIRM, TardisConstants.Translations.GUI_CANCEL));
    }
}

