/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.guis.minigame.wires;

import java.awt.Color;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.util.math.vector.Vector3i;
import net.tardis.mod.helper.Helper;

public class Wire {
    public static final int SIZE_X = 16;
    public static final int SIZE_Y = 14;
    private Type type;
    public Vector3i startPos;
    public Vector3i endPos;
    private boolean selected = false;
    private boolean complete = false;

    public Wire(Type type, int x, int y) {
        this.type = type;
        this.startPos = this.endPos = new Vector3i(x, y, 0);
    }

    public void update(int mouseX, int mouseY) {
        if (this.isSelected()) {
            this.endPos = new Vector3i(mouseX, mouseY, 0);
        }
    }

    public void render(BufferBuilder bb) {
        int size = 5;
        int x = this.startPos.func_177958_n() + 16 - 1;
        int endX = this.endPos.func_177958_n();
        int y = this.startPos.func_177956_o() + 7 - size / 2;
        int endY = this.endPos.func_177956_o();
        float red = (float)this.type.color.getRed() / 255.0f;
        float green = (float)this.type.color.getGreen() / 255.0f;
        float blue = (float)this.type.color.getBlue() / 255.0f;
        bb.func_225582_a_((double)x, (double)y, 0.0).func_227885_a_(red, green, blue, 1.0f).func_181675_d();
        bb.func_225582_a_((double)x, (double)(y + size), 0.0).func_227885_a_(red, green, blue, 1.0f).func_181675_d();
        bb.func_225582_a_((double)(endX + size), (double)(endY + size), 0.0).func_227885_a_(red, green, blue, 1.0f).func_181675_d();
        bb.func_225582_a_((double)(endX + size), (double)endY, 0.0).func_227885_a_(red, green, blue, 1.0f).func_181675_d();
    }

    public void renderPost(BufferBuilder bb) {
        int x = this.startPos.func_177958_n();
        int y = this.startPos.func_177956_o();
        float minU = (float)this.type.getMinU();
        float maxU = (float)this.type.getMaxU();
        float minV = (float)this.type.getMinV();
        float maxV = (float)this.type.getMaxV();
        bb.func_225582_a_((double)x, (double)y, 0.0).func_225583_a_(minU, minV).func_181675_d();
        bb.func_225582_a_((double)x, (double)(y + 14), 0.0).func_225583_a_(minU, maxV).func_181675_d();
        bb.func_225582_a_((double)(x + 16), (double)(y + 14), 0.0).func_225583_a_(maxU, maxV).func_181675_d();
        bb.func_225582_a_((double)(x + 16), (double)y, 0.0).func_225583_a_(maxU, minV).func_181675_d();
    }

    public void unselect() {
        this.endPos = this.startPos;
        this.selected = false;
    }

    public void onClick(int mouseX, int mouseY) {
        if (!this.complete) {
            if (Helper.isInBounds(mouseX, mouseY, this.startPos.func_177958_n(), this.startPos.func_177956_o(), this.startPos.func_177958_n() + 16, this.startPos.func_177956_o() + 14)) {
                this.selected = true;
            } else {
                this.unselect();
            }
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public Type getType() {
        return this.type;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
        this.selected = false;
    }

    public void setEndPos(Vector3i end) {
        this.endPos = end;
    }

    public static enum Type {
        RED(10292006, 2, 240),
        GREEN(8838533, 20, 240),
        BLACK(0, 38, 240),
        BLUE(3767724, 56, 240);

        Color color;
        private double u;
        private double v;

        private Type(int hex, int u, int v) {
            this(new Color(hex), u, v);
        }

        private Type(Color color, int u, int v) {
            this.color = color;
            this.u = u;
            this.v = v;
        }

        public double getMinU() {
            return this.u / 256.0;
        }

        public double getMinV() {
            return this.v / 256.0;
        }

        public double getMaxU() {
            return (this.u + 16.0) / 256.0;
        }

        public double getMaxV() {
            return (this.v + 14.0) / 256.0;
        }
    }
}

