/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.guis.minigame.circuit;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.tardis.mod.client.guis.minigame.circuit.Piece;
import net.tardis.mod.client.guis.minigame.circuit.piece.DiagonalRightPiece;
import net.tardis.mod.helper.Helper;

public class CircuitGame
extends Screen {
    public static final StringTextComponent TITLE = new StringTextComponent("Circuit Minigame");
    public static int GRID_WIDTH = 128;
    public static int GRID_HEIGHT = 66;
    private List<Piece> pieces = Lists.newArrayList();
    private Piece currentPiece = new DiagonalRightPiece(30, 30);
    private int timeLeft = 100;

    public CircuitGame() {
        super((ITextComponent)TITLE);
        this.pieces.add(this.currentPiece);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.timeLeft > 0) {
            --this.timeLeft;
            if (this.timeLeft == 0) {
                this.onPieceExpired();
            }
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230446_a_(matrixStack);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(Helper.createRL("textures/gui/minigame/circuit.png"));
        this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 - 88, this.field_230709_l_ / 2 - 61, 0, 0, 176, 122);
        if (this.currentPiece != null) {
            Vector3i pos = this.getClosestPoint(this.currentPiece, mouseX, mouseY);
            this.currentPiece.x = pos.func_177958_n();
            this.currentPiece.y = pos.func_177956_o();
        }
        BufferBuilder bb = Tessellator.func_178181_a().func_178180_c();
        bb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (Piece p : this.pieces) {
            p.render(bb);
        }
        Tessellator.func_178181_a().func_78381_a();
    }

    private void onPieceExpired() {
        this.timeLeft = 100;
    }

    public static boolean isInBounds(int mouseX, int mouseY) {
        return true;
    }

    public Vector3i getClosestPoint(Piece piece, int mouseX, int mouseY) {
        int x = mouseX;
        int y = mouseY;
        int left = this.field_230708_k_ / 2 - 88 + 25;
        int right = left + 110;
        if (x < left) {
            x = left;
        } else if (x > right) {
            x = right;
        }
        int top = (this.field_230709_l_ - 122) / 2 + 13;
        int bottom = top + 50;
        if (y < top) {
            y = top;
        } else if (y > bottom) {
            y = bottom;
        }
        return new Vector3i(x, y, 0);
    }
}

