/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.guis.minigame;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.tardis.mod.client.guis.minigame.wires.Terminal;
import net.tardis.mod.client.guis.minigame.wires.Wire;
import net.tardis.mod.helper.Helper;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.FailEngineMessage;
import net.tardis.mod.sounds.TSounds;

public class WireGameScreen
extends Screen {
    private static final ResourceLocation TEXTURE = Helper.createRL("textures/gui/minigame/wires.png");
    private static final StringTextComponent TITLE = new StringTextComponent("WIRE");
    private List<Wire> connections = Lists.newArrayList();
    private List<Terminal> terminals = Lists.newArrayList();
    private int slotNumber = 0;
    private Direction panel;
    private boolean completed = false;

    public WireGameScreen(int slot, Direction panel) {
        super((ITextComponent)TITLE);
        this.slotNumber = slot;
        this.panel = panel;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
        this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 - 116, this.field_230709_l_ / 2 - 101, 0, 0, 232, 202);
        for (Wire wire : this.connections) {
            wire.update(mouseX, mouseY);
        }
        BufferBuilder bb = Tessellator.func_178181_a().func_178180_c();
        GlStateManager.func_227621_I_();
        bb.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        for (Wire wire : this.connections) {
            wire.render(bb);
        }
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_227619_H_();
        bb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (Wire wire : this.connections) {
            wire.renderPost(bb);
        }
        for (Terminal term : this.terminals) {
            term.render(bb);
        }
        Tessellator.func_178181_a().func_78381_a();
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.connections.clear();
        this.terminals.clear();
        this.connections.add(new Wire(Wire.Type.RED, this.field_230708_k_ / 2 - 80, this.field_230709_l_ / 2 - 79));
        this.connections.add(new Wire(Wire.Type.GREEN, this.field_230708_k_ / 2 - 105, this.field_230709_l_ / 2 - 39));
        this.connections.add(new Wire(Wire.Type.BLACK, this.field_230708_k_ / 2 - 105, this.field_230709_l_ / 2 + 25));
        this.connections.add(new Wire(Wire.Type.BLUE, this.field_230708_k_ / 2 - 80, this.field_230709_l_ / 2 + 68));
        ArrayList termPos = Lists.newArrayList((Object[])new Vector3i[]{new Vector3i(this.field_230708_k_ / 2 + 63, this.field_230709_l_ / 2 - 79, 0), new Vector3i(this.field_230708_k_ / 2 + 88, this.field_230709_l_ / 2 - 39, 0), new Vector3i(this.field_230708_k_ / 2 + 88, this.field_230709_l_ / 2 + 25, 0), new Vector3i(this.field_230708_k_ / 2 + 63, this.field_230709_l_ / 2 + 68, 0)});
        Random rand = Minecraft.func_71410_x().field_71441_e.field_73012_v;
        for (Wire.Type type : Wire.Type.values()) {
            Vector3i pos = (Vector3i)termPos.get(rand.nextInt(termPos.size()));
            this.terminals.add(new Terminal(type, pos.func_177958_n(), pos.func_177956_o()));
            termPos.remove(pos);
        }
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        boolean finished = true;
        for (Wire wire : this.connections) {
            if (wire.isComplete()) continue;
            finished = false;
            break;
        }
        if (finished) {
            this.field_230706_i_.field_71439_g.func_184185_a((SoundEvent)TSounds.REACHED_DESTINATION.get(), 1.0f, 1.0f);
            this.completed = true;
            Minecraft.func_71410_x().func_147108_a(null);
        }
    }

    public void func_231175_as__() {
        if (!this.completed) {
            this.fail();
        }
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void fail() {
        Minecraft.func_71410_x().func_147108_a((Screen)null);
        this.field_230706_i_.field_71439_g.func_184185_a((SoundEvent)TSounds.SONIC_FAIL.get(), 1.0f, 1.0f);
        Network.sendToServer(new FailEngineMessage(this.panel, this.slotNumber));
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        for (Terminal term : this.terminals) {
            if (term.onClick((int)mouseX, (int)mouseY, this.getSelectedWire())) continue;
            this.fail();
        }
        for (Wire w : this.connections) {
            w.onClick((int)mouseX, (int)mouseY);
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    @Nullable
    public Wire getSelectedWire() {
        for (Wire wire : this.connections) {
            if (!wire.isSelected()) continue;
            return wire;
        }
        return null;
    }
}

