/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.guis.manual.pages;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.tardis.mod.client.guis.manual.Chapter;
import net.tardis.mod.client.guis.manual.ManualScreen;
import net.tardis.mod.client.guis.manual.pages.Page;

public class TOCPage
extends Page {
    private final List<NamedAction> actions = new ArrayList<NamedAction>();
    private final ManualScreen manual;
    private int maxIndex = 0;
    private int minIndex = 0;
    public static final int MAX_LINES = 13;

    public TOCPage(ManualScreen manual, int minIndex, int maxIndex) {
        this.manual = manual;
        this.minIndex = minIndex;
        this.maxIndex = maxIndex;
        this.addButtons(manual);
    }

    public void addButtons(ManualScreen screen) {
        int index = 0;
        if (this.maxIndex < screen.getChapters().size() && this.minIndex < screen.getChapters().size()) {
            int chapterIndex = this.minIndex;
            while (chapterIndex <= this.maxIndex) {
                Chapter chapter = screen.getChapters().get(chapterIndex);
                if (chapter == null) continue;
                if (!chapter.getDisplayName().isEmpty()) {
                    int finalIndex = chapterIndex;
                    String string = chapter.getDisplayName();
                    Runnable runnable = () -> screen.openPage(finalIndex, 0);
                    Minecraft.func_71410_x().field_71466_p.getClass();
                    this.actions.add(new NamedAction(string, runnable, 9 * index));
                    ++index;
                }
                ++chapterIndex;
            }
        }
    }

    @Override
    public void render(MatrixStack stack, FontRenderer font, int globalPage, int x, int y, int width, int height) {
        font.func_243248_b(stack, (ITextComponent)new StringTextComponent("Table of Contents").func_240699_a_(TextFormatting.ITALIC), (float)x, (float)(y - 10), 0);
        for (int i = 0; i < this.actions.size(); ++i) {
            NamedAction action = this.actions.get(i);
            StringTextComponent stringTextComponent = new StringTextComponent(action.name);
            float f = x;
            int n = y + action.y;
            font.getClass();
            font.func_243248_b(stack, (ITextComponent)stringTextComponent, f, (float)(n + 9 - 5), 4600598);
        }
    }

    @Override
    public void onClick(double x, double y) {
        for (NamedAction action : this.actions) {
            int n = (int)Math.floor(y);
            Minecraft.func_71410_x().field_71466_p.getClass();
            if (!action.isInBounds(n, 9)) continue;
            action.act();
            return;
        }
    }

    public static class NamedAction {
        private String name;
        private Runnable action;
        private int y;

        public NamedAction(String name, Runnable action, int y) {
            this.name = name;
            this.action = action;
            this.y = y;
        }

        public String getName() {
            return this.name;
        }

        public void act() {
            this.action.run();
        }

        public boolean isInBounds(int y, int fontHeight) {
            return y > this.y && y < this.y + fontHeight;
        }
    }
}

