/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.guis.manual.pages;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.ResourceLocation;
import net.tardis.mod.Tardis;
import net.tardis.mod.client.guis.manual.pages.serializers.CoverPageSerializer;
import net.tardis.mod.client.guis.manual.pages.serializers.NormalPageSerializer;
import net.tardis.mod.client.guis.manual.pages.serializers.PageSerializer;
import org.apache.logging.log4j.Level;

public class Page {
    private static final List<PageSerializer> SERIALIZERS = Lists.newArrayList();
    public static final int WIDTH = 65;
    public static final int LINES = 10;
    public static final int MAX_LINE_WIDTH = 115;
    protected List<String> lines = Lists.newArrayList();

    public List<String> getLines() {
        return this.lines;
    }

    public String parseString(String page) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        ArrayList words = Lists.newArrayList((Object[])page.split(" "));
        this.lines.clear();
        int currentWidth = 0;
        StringBuilder line = new StringBuilder();
        String prevLineWord = "";
        for (int i = 0; i < words.size(); ++i) {
            String word = (String)words.get(i);
            int width = font.func_78256_a(word);
            int prevLineWidth = font.func_78256_a(line.toString());
            if ((currentWidth += width) < 65 && prevLineWidth < 65) {
                prevLineWord = line.toString();
                line.append(word).append(" ");
            } else {
                int appendedWordWidth = font.func_78256_a(line.toString());
                if (appendedWordWidth > 65) {
                    if (appendedWordWidth >= 115) {
                        String split = line.substring(prevLineWord.length());
                        this.lines.add(prevLineWord);
                        this.lines.add(split);
                        line = new StringBuilder(word + " ");
                        currentWidth = 0;
                    } else {
                        this.lines.add(line.toString());
                        line = new StringBuilder(word + " ");
                        currentWidth = 0;
                    }
                } else {
                    this.lines.add(line.toString());
                    line = new StringBuilder(word + " ");
                    currentWidth = 0;
                }
            }
            if (this.lines.size() < 10) continue;
            StringBuilder build = new StringBuilder();
            for (String s : words.subList(i, words.size())) {
                build.append(s).append(" ");
            }
            return build.toString();
        }
        this.lines.add(line.toString());
        return "";
    }

    public int getNumberOfLines() {
        return this.lines.size();
    }

    public void render(MatrixStack stack, FontRenderer font, int globalPage, int x, int y, int width, int height) {
        int index = 0;
        for (String lines : this.getLines()) {
            float f = x;
            font.getClass();
            font.func_238421_b_(stack, lines, f, (float)(y + (9 + 2) * index), 0);
            ++index;
        }
        font.func_238421_b_(stack, globalPage + "", (float)(x + 32 + font.func_78256_a(globalPage + "") / 2), (float)(y + 120), 0);
    }

    public static List<Page> read(ResourceLocation id) {
        try {
            JsonObject root = new JsonParser().parse((Reader)new InputStreamReader(Minecraft.func_71410_x().func_195551_G().func_199002_a(id).func_199027_b())).getAsJsonObject();
            String type = root.get("type").getAsString();
            for (PageSerializer serializer : SERIALIZERS) {
                if (!serializer.match(type)) continue;
                return serializer.read(root);
            }
        }
        catch (Exception e) {
            Tardis.LOGGER.log(Level.INFO, String.format("Exception in manual page %s!", id.toString()));
            Tardis.LOGGER.catching(Level.INFO, (Throwable)e);
        }
        return null;
    }

    public static ResourceLocation getPageResourceLocation(ResourceLocation loc, String localeCode) {
        return new ResourceLocation(loc.func_110624_b(), "manual/" + localeCode + "/page/" + loc.func_110623_a() + ".json");
    }

    public void onClick(double x, double y) {
    }

    static {
        SERIALIZERS.add(new NormalPageSerializer());
        SERIALIZERS.add(new CoverPageSerializer());
    }
}

