/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.guis.manual;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ChangePageButton;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.tardis.mod.Tardis;
import net.tardis.mod.client.guis.manual.Chapter;
import net.tardis.mod.client.guis.manual.Index;
import net.tardis.mod.client.guis.manual.pages.Page;
import net.tardis.mod.client.guis.manual.pages.TOCPage;
import net.tardis.mod.client.guis.widgets.ChangeChapterButton;
import net.tardis.mod.client.guis.widgets.ReturnToIndexButton;
import net.tardis.mod.contexts.gui.GuiItemContext;
import net.tardis.mod.misc.GuiContext;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.UpdateManualPageMessage;

public class ManualScreen
extends Screen {
    public static final ResourceLocation TEXTURE = new ResourceLocation("tardis", "textures/gui/manual.png");
    private List<Chapter> chapters = Lists.newArrayList();
    private int pageIndex = 0;
    private int chapterIndex = 0;
    private String modid;
    private static final TranslationTextComponent NEXT_PAGE = new TranslationTextComponent("tooltip.tardis.manual.next_page");
    private static final TranslationTextComponent PREV_PAGE = new TranslationTextComponent("tooltip.tardis.manual.previous_page");
    private static final TranslationTextComponent NEXT_CHAPTER = new TranslationTextComponent("tooltip.tardis.manual.next_chapter");
    private static final TranslationTextComponent PREV_CHAPTER = new TranslationTextComponent("tooltip.tardis.manual.previous_chapter");
    private static final TranslationTextComponent LAST_PAGE = new TranslationTextComponent("tooltip.tardis.manual.last_page");
    private static final TranslationTextComponent FIRST_PAGE = new TranslationTextComponent("tooltip.tardis.manual.first_page");
    private ChangePageButton pageForward;
    private ChangePageButton pageBack;
    private ChangeChapterButton chapterForward;
    private ChangeChapterButton chapterBack;
    private ReturnToIndexButton endOfManual;
    private ReturnToIndexButton startOfManual;
    public int pageX = this.field_230708_k_ / 2 - 110;
    public int pageY = this.field_230709_l_ / 2 - 70;
    public int page2X = this.pageX + 120;

    protected ManualScreen(ITextComponent titleIn, String modid) {
        super(titleIn);
        this.modid = modid;
        this.read();
        this.insertTOC();
    }

    public ManualScreen(GuiContext context) {
        this((ITextComponent)new StringTextComponent("Manual"), "tardis");
        ItemStack stack;
        if (context instanceof GuiItemContext && (stack = ((GuiItemContext)context).getItemStack()).func_77942_o()) {
            if (stack.func_77978_p().func_74764_b("page")) {
                this.pageIndex = stack.func_77978_p().func_74762_e("page");
            }
            if (stack.func_77978_p().func_74764_b("chapter")) {
                this.chapterIndex = stack.func_77978_p().func_74762_e("chapter");
            }
        }
    }

    public void func_231175_as__() {
        Network.sendToServer(new UpdateManualPageMessage(this.pageIndex, this.chapterIndex));
        super.func_231175_as__();
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.read();
        this.field_230710_m_.clear();
        this.pageForward = new ChangePageButton(this.field_230708_k_ / 2 + 95, this.field_230709_l_ / 2 + 70, true, button -> this.turnPage(true), true);
        this.func_230480_a_(this.pageForward);
        this.pageBack = new ChangePageButton(this.field_230708_k_ / 2 - 120, this.field_230709_l_ / 2 + 70, false, button -> this.turnPage(false), true);
        this.func_230480_a_(this.pageBack);
        this.chapterForward = new ChangeChapterButton(this.field_230708_k_ / 2 + 25, this.field_230709_l_ / 2 + 70, true, button -> this.turnChapter(true), true);
        this.func_230480_a_(this.chapterForward);
        this.chapterBack = new ChangeChapterButton(this.field_230708_k_ / 2 - 45, this.field_230709_l_ / 2 + 70, false, button -> this.turnChapter(false), true);
        this.func_230480_a_(this.chapterBack);
        this.updatePageWidths();
        this.insertTOC();
        this.endOfManual = new ReturnToIndexButton(this.field_230708_k_ / 2 + 125, this.field_230709_l_ / 2 - 85, true, button -> this.turnToTableOfContents(true), true);
        this.func_230480_a_(this.endOfManual);
        this.startOfManual = new ReturnToIndexButton(this.field_230708_k_ / 2 - 140, this.field_230709_l_ / 2 - 85, false, button -> this.turnToTableOfContents(false), true);
        this.func_230480_a_(this.startOfManual);
    }

    public void openPage(int chapterIndex, int pageIndex) {
        this.chapterIndex = chapterIndex;
        this.pageIndex = pageIndex;
    }

    public void updatePageWidths() {
        this.pageX = this.field_230708_k_ / 2 - 110;
        this.pageY = this.field_230709_l_ / 2 - 70;
        this.page2X = this.pageX + 120;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getTexture());
        this.func_238474_b_(matrixStack, (this.field_230708_k_ - 256) / 2, (this.field_230709_l_ - 187) / 2, 0, 0, 256, 187);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        Pair<Page, Page> pages = this.getPages();
        if (pages.getFirst() != null) {
            ((Page)pages.getFirst()).render(matrixStack, this.field_230712_o_, this.getGlobalPageNumber(), this.pageX, this.pageY, this.field_230708_k_, this.field_230709_l_);
        }
        if (pages.getSecond() != null) {
            ((Page)pages.getSecond()).render(matrixStack, this.field_230712_o_, this.getGlobalPageNumber() + 1, this.page2X, this.pageY, this.field_230708_k_, this.field_230709_l_);
        }
        this.renderTooltips(matrixStack, mouseX, mouseY, partialTicks);
    }

    private void renderTooltips(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.pageForward.func_230449_g_()) {
            this.func_238652_a_(matrixStack, (ITextComponent)NEXT_PAGE, mouseX, mouseY);
        }
        if (this.pageBack.func_230449_g_()) {
            this.func_238652_a_(matrixStack, (ITextComponent)PREV_PAGE, mouseX, mouseY);
        }
        if (this.chapterForward.func_230449_g_()) {
            this.func_238652_a_(matrixStack, (ITextComponent)NEXT_CHAPTER, mouseX, mouseY);
        }
        if (this.chapterBack.func_230449_g_()) {
            this.func_238652_a_(matrixStack, (ITextComponent)PREV_CHAPTER, mouseX, mouseY);
        }
        if (this.endOfManual.func_230449_g_()) {
            this.func_238652_a_(matrixStack, (ITextComponent)LAST_PAGE, mouseX, mouseY);
        }
        if (this.startOfManual.func_230449_g_()) {
            this.func_238652_a_(matrixStack, (ITextComponent)FIRST_PAGE, mouseX, mouseY);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        Pair<Page, Page> pages = this.getPages();
        if (mouseY > (double)this.pageY && mouseY < (double)(this.pageY + 144)) {
            Page page;
            if (mouseX > (double)this.pageX && mouseX < (double)(this.pageX + 115)) {
                Page page2 = (Page)pages.getFirst();
                if (page2 != null) {
                    page2.onClick(mouseX - (double)this.pageX, mouseY - (double)this.pageY);
                }
            } else if (mouseX > (double)this.page2X && mouseX < (double)(this.page2X + 115) && (page = (Page)pages.getSecond()) != null) {
                page.onClick(mouseX - (double)this.pageX, mouseY - (double)this.pageY);
            }
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public void turnPage(boolean forward) {
        Chapter currentChapter = this.getChapter();
        if (currentChapter == null) {
            this.chapterIndex = 0;
            return;
        }
        if (forward) {
            if (this.pageIndex + 2 < currentChapter.getPages().size()) {
                this.pageIndex += 2;
            } else if (this.chapterIndex + 1 < this.chapters.size()) {
                ++this.chapterIndex;
                this.pageIndex = 0;
            }
        } else if (this.pageIndex - 2 >= 0) {
            this.pageIndex -= 2;
        } else if (this.chapterIndex - 1 >= 0) {
            --this.chapterIndex;
            int chapterSize = this.getChapter().getPages().size();
            this.pageIndex = chapterSize % 2 == 0 ? chapterSize - 2 : chapterSize - 1;
        }
    }

    public void insertTOC() {
        Chapter chapter = this.chapters.get(0);
        if (chapter != null) {
            int maxPerPage = 13;
            int maxChapters = this.chapters.size();
            if (maxChapters > 0) {
                int numPages;
                int initialPages = (int)((double)maxChapters / (double)maxPerPage);
                int n = numPages = (int)((double)maxChapters % (double)maxPerPage) == 0 ? initialPages : initialPages + 1;
                if (numPages > 0) {
                    int prevEndIndex = 0;
                    for (int i = 0; i < numPages; ++i) {
                        int endIndex;
                        int startIndex = i * maxPerPage;
                        int n2 = endIndex = startIndex + maxPerPage > maxChapters ? maxChapters - 1 : startIndex + maxPerPage;
                        if (startIndex == prevEndIndex && prevEndIndex > 0) {
                            startIndex = endIndex;
                        }
                        prevEndIndex = endIndex;
                        if (chapter.getPages().get(i) instanceof TOCPage) continue;
                        chapter.insertPage(i, new TOCPage(this, startIndex, endIndex));
                    }
                }
            }
        }
    }

    public void turnChapter(boolean forward) {
        Chapter currentChapter = this.getChapter();
        if (currentChapter == null) {
            this.chapterIndex = 0;
            return;
        }
        if (forward) {
            if (this.chapterIndex + 1 < this.chapters.size()) {
                ++this.chapterIndex;
                this.pageIndex = 0;
            }
        } else if (this.chapterIndex - 1 >= 0) {
            --this.chapterIndex;
            this.pageIndex = 0;
        }
    }

    public void turnToChapter(int chapterIndex) {
        if (chapterIndex < this.chapters.size()) {
            this.chapterIndex = chapterIndex;
            this.pageIndex = 0;
        }
    }

    public void turnToTableOfContents(boolean forward) {
        if (forward) {
            int maxChapter;
            this.chapterIndex = maxChapter = this.chapters.size() - 1;
            this.pageIndex = this.chapters.get(maxChapter).getPages().size() - 1;
        } else {
            this.chapterIndex = 0;
            this.pageIndex = 0;
        }
    }

    public int getGlobalPageNumber() {
        int pages = 0;
        for (int i = 0; i < this.chapterIndex; ++i) {
            pages += this.chapters.get(i).getPages().size();
        }
        return pages + this.pageIndex;
    }

    public Chapter getChapter() {
        if (this.chapterIndex < this.chapters.size()) {
            return this.chapters.get(this.chapterIndex);
        }
        return null;
    }

    public List<Chapter> getChapters() {
        return this.chapters;
    }

    public int getChapterIndex() {
        return this.chapterIndex;
    }

    public Pair<Page, Page> getPages() {
        Chapter chapter = this.getChapter();
        if (chapter != null && this.pageIndex < chapter.getPages().size()) {
            Page page2 = null;
            if (this.pageIndex + 1 < chapter.getPages().size()) {
                page2 = chapter.getPages().get(this.pageIndex + 1);
            }
            return new Pair((Object)this.getChapter().getPages().get(this.pageIndex), (Object)page2);
        }
        return new Pair(null, null);
    }

    public ResourceLocation getTexture() {
        return TEXTURE;
    }

    public <T extends Widget> T func_230480_a_(T button) {
        return (T)super.func_230480_a_(button);
    }

    private void read() {
        String localeCode = Minecraft.func_71410_x().func_135016_M().func_135041_c().getCode();
        ResourceLocation indexLocation = this.getManualIndexResourceLocation(localeCode);
        IResource resource = null;
        try {
            resource = ManualScreen.getManualResourceNullable(indexLocation);
        }
        catch (IOException e) {
            e.printStackTrace();
            Tardis.LOGGER.error("Could not find Manual resources for locale: {}, reverting to contents for locale {}", (Object)Minecraft.func_71410_x().func_135016_M().func_135041_c().getCode(), (Object)"en_us");
            localeCode = "en_us";
            indexLocation = this.getManualIndexResourceLocation(localeCode);
            try {
                resource = ManualScreen.getManualResourceNullable(indexLocation);
            }
            catch (IOException exTwo) {
                exTwo.printStackTrace();
            }
        }
        if (resource != null) {
            JsonObject root = new JsonParser().parse((Reader)new InputStreamReader(resource.func_199027_b())).getAsJsonObject();
            Index index = Index.read(indexLocation, root, localeCode);
            this.chapters.clear();
            this.chapters.addAll(index.getChapters());
        }
    }

    public ResourceLocation getManualIndexResourceLocation(String localeCode) {
        return Index.getIndexResourceLocation(new ResourceLocation(this.modid, "main"), localeCode);
    }

    private static IResource getManualResourceNullable(ResourceLocation rl) throws IOException {
        return Minecraft.func_71410_x().func_195551_G().func_199002_a(rl);
    }
}

