/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.guis.containers;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.tardis.mod.client.guis.widgets.ImageButton;
import net.tardis.mod.client.guis.widgets.WaypointButton;
import net.tardis.mod.containers.WaypointBankContainer;
import net.tardis.mod.helper.Helper;
import net.tardis.mod.items.DataCrystalItem;
import net.tardis.mod.misc.SpaceTimeCoord;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.WaypointScreenMessage;
import net.tardis.mod.tileentities.WaypointBankTile;

public class WaypointContainerScreen
extends ContainerScreen<WaypointBankContainer> {
    public static final ResourceLocation TEXTURE = Helper.createRL("textures/gui/containers/waypoint.png");
    private ImageButton copyButton;
    private ImageButton bankCopyButton;
    private ImageButton deleteButton;
    private ImageButton bankDeleteButton;

    public WaypointContainerScreen(WaypointBankContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)screenContainer, inv, titleIn);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        this.func_230446_a_(matrixStack);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TEXTURE);
        this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 - 88, this.field_230709_l_ / 2 - 111, 0, 0, 176, 230);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
        this.field_230712_o_.func_238421_b_(matrixStack, this.field_230704_d_.getString(), 8.0f, (float)(this.field_147000_g - 188), 0x404040);
        this.field_230712_o_.func_243248_b(matrixStack, this.field_213127_e.func_145748_c_(), (float)this.field_238744_r_, (float)this.field_238745_s_ + 37.0f, 0x404040);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
        if (Helper.isInBounds(mouseX, mouseY, this.field_147003_i, this.field_147009_r - 10, this.field_147003_i + 85, this.field_147009_r + 85)) {
            this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("tooltip.tardis.waypoint_bank.bank_input"), mouseX, mouseY);
        }
        if (Helper.isInBounds(mouseX, mouseY, this.field_147003_i + 90, this.field_147009_r - 10, this.field_147003_i + 170, this.field_147009_r + 85)) {
            this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("tooltip.tardis.waypoint_bank.crystal_output"), mouseX, mouseY);
        }
        if (this.copyButton.func_230449_g_()) {
            this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("tooltip.tardis.waypoint_bank.copy_from_crystal"), mouseX, mouseY);
        }
        if (this.bankCopyButton.func_230449_g_()) {
            this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("tooltip.tardis.waypoint_bank.copy_from_bank"), mouseX, mouseY);
        }
        if (this.deleteButton.func_230449_g_()) {
            this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("tooltip.tardis.waypoint_bank.delete_from_crystal"), mouseX, mouseY);
        }
        if (this.bankDeleteButton.func_230449_g_()) {
            this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("tooltip.tardis.waypoint_bank.delete_from_bank"), mouseX, mouseY);
        }
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.field_230710_m_.clear();
        WaypointBankTile tile = (WaypointBankTile)((WaypointBankContainer)this.func_212873_a_()).getBlockEntity();
        if (tile != null) {
            for (int i = 0; i < tile.getWaypoints().size(); ++i) {
                SpaceTimeCoord coord = tile.getWaypoints().get(i);
                if (SpaceTimeCoord.UNIVERAL_CENTER.equals(coord)) continue;
                this.func_230480_a_(new WaypointButton(this.field_230708_k_ / 2 - 80, this.field_230709_l_ / 2 - 90 + i * 18, 76, 18, new StringTextComponent(coord.getName()), i, true));
            }
        }
        if (((WaypointBankContainer)this.field_147002_h).func_75139_a(0).func_75211_c().func_77973_b() instanceof DataCrystalItem) {
            List<SpaceTimeCoord> itemCoords = DataCrystalItem.getStoredWaypoints(((WaypointBankContainer)this.func_212873_a_()).func_75139_a(0).func_75211_c());
            for (int index = 0; index < itemCoords.size(); ++index) {
                SpaceTimeCoord coord = itemCoords.get(index);
                if (SpaceTimeCoord.UNIVERAL_CENTER.equals(coord)) continue;
                this.func_230480_a_(new WaypointButton(this.field_230708_k_ / 2 + 4, this.field_230709_l_ / 2 - 90 + index * 18, 76, 18, new StringTextComponent(coord.getName()), index, false));
            }
        }
        this.copyButton = new ImageButton(this.field_230708_k_ / 2 - 80, this.field_230709_l_ / 2 + 4, 180, 36, 18, 18, TEXTURE);
        this.copyButton.setPressable(() -> {
            Network.sendToServer(new WaypointScreenMessage(WaypointScreenMessage.Type.COPY_TO_CRYSTAL, ((WaypointBankTile)((WaypointBankContainer)this.field_147002_h).getBlockEntity()).func_174877_v(), this.getSelected(true)));
            this.func_231160_c_();
        });
        this.func_230480_a_(this.copyButton);
        this.bankCopyButton = new ImageButton(this.field_230708_k_ / 2 + 60, this.field_230709_l_ / 2 + 4, 180, 36, 18, 18, TEXTURE);
        this.bankCopyButton.setPressable(() -> {
            Network.sendToServer(new WaypointScreenMessage(WaypointScreenMessage.Type.COPY_TO_BANK, ((WaypointBankTile)((WaypointBankContainer)this.field_147002_h).getBlockEntity()).func_174877_v(), this.getSelected(false)));
            this.func_231160_c_();
        });
        this.func_230480_a_(this.bankCopyButton);
        this.bankDeleteButton = new ImageButton(this.field_230708_k_ / 2 - 60, this.field_230709_l_ / 2 + 4, 198, 36, 18, 18, TEXTURE);
        this.bankDeleteButton.setPressable(() -> {
            Network.sendToServer(new WaypointScreenMessage(WaypointScreenMessage.Type.DELETE_FROM_BANK, ((WaypointBankTile)((WaypointBankContainer)this.field_147002_h).getBlockEntity()).func_174877_v(), this.getSelected(true)));
            this.func_231160_c_();
        });
        this.func_230480_a_(this.bankDeleteButton);
        this.deleteButton = new ImageButton(this.field_230708_k_ / 2 + 40, this.field_230709_l_ / 2 + 4, 198, 36, 18, 18, TEXTURE);
        this.deleteButton.setPressable(() -> {
            Network.sendToServer(new WaypointScreenMessage(WaypointScreenMessage.Type.DELETE_FROM_CRYSTAL, ((WaypointBankTile)((WaypointBankContainer)this.field_147002_h).getBlockEntity()).func_174877_v(), this.getSelected(false)));
            this.func_231160_c_();
        });
        this.func_230480_a_(this.deleteButton);
    }

    public List<Integer> getSelected(boolean useBank) {
        ArrayList list = Lists.newArrayList();
        for (Widget w : this.field_230710_m_) {
            WaypointButton way;
            if (!w.field_230693_o_ || !(w instanceof WaypointButton) || !(way = (WaypointButton)w).getChecked()) continue;
            if (useBank && way.getIsFromBank()) {
                list.add(way.getId());
                continue;
            }
            if (useBank || way.getIsFromBank()) continue;
            list.add(way.getId());
        }
        return list;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int p_mouseClicked_5_) {
        for (Widget w : this.field_230710_m_) {
            WaypointButton way;
            if (!Helper.isInBounds((int)mouseX, (int)mouseY, w.field_230690_l_, w.field_230691_m_, w.field_230690_l_ + w.func_230998_h_(), w.field_230691_m_ + w.func_238483_d_()) || !(w instanceof WaypointButton)) continue;
            way.setChecked(!(way = (WaypointButton)w).getChecked());
        }
        return super.func_231044_a_(mouseX, mouseY, p_mouseClicked_5_);
    }
}

