/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.guis.containers;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.tardis.mod.containers.SpectrometerContainer;
import net.tardis.mod.helper.Helper;
import net.tardis.mod.helper.TextHelper;
import net.tardis.mod.items.SonicItem;
import net.tardis.mod.schematics.Schematic;
import net.tardis.mod.tileentities.machines.NeutronicSpectrometerTile;

public class SpectrometerScreen
extends ContainerScreen<SpectrometerContainer> {
    public static final ResourceLocation TEXTURE = Helper.createRL("textures/gui/containers/spectrometer.png");

    public SpectrometerScreen(SpectrometerContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)screenContainer, inv, titleIn);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
        this.func_230446_a_(matrixStack);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
        this.func_238474_b_(matrixStack, this.field_147003_i, this.field_147009_r, 0, 0, 177, 166);
        this.renderProgressBar(matrixStack, ((SpectrometerContainer)this.field_147002_h).getProgress());
        this.renderDownloadProgress(matrixStack, ((SpectrometerContainer)this.field_147002_h).getDownloadProgress());
        LampColor upperLampColor = LampColor.OFF;
        if (((SpectrometerContainer)this.field_147002_h).getDownloadProgress() > 0.0f) {
            upperLampColor = LampColor.RED;
        } else if (((SpectrometerContainer)this.field_147002_h).hasSchematics()) {
            upperLampColor = LampColor.GREEN;
        }
        this.renderLamp(matrixStack, (this.field_230708_k_ + 29) / 2, (this.field_230709_l_ - 152) / 2, upperLampColor);
        if (((SpectrometerContainer)this.field_147002_h).func_75139_a(1).func_75211_c().func_77973_b() instanceof SonicItem) {
            this.renderLamp(matrixStack, (this.field_230708_k_ + 119) / 2, (this.field_230709_l_ - 112) / 2, ((SpectrometerContainer)this.field_147002_h).getDownloadProgress() > 0.0f ? LampColor.RED : LampColor.GREEN);
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
        SpectrometerScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)this.field_230704_d_.getString(), (int)(this.field_230708_k_ / 2), (int)(this.field_147009_r - 15), (int)0xFFFFFF);
        this.renderCustomTooltips(matrixStack, mouseX, mouseY);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.field_230712_o_.func_238421_b_(matrixStack, this.field_213127_e.func_145748_c_().getString(), 8.0f, (float)(this.field_147000_g - 92), 0x404040);
    }

    protected void renderCustomTooltips(MatrixStack matrixStack, int mouseX, int mouseY) {
        List<Schematic> schematics;
        int maxProgress;
        int progress;
        if (Helper.isInBounds(mouseX, mouseY, this.field_147003_i + 33, this.field_147009_r + 45, this.field_147003_i + 65, this.field_147009_r + 50) || Helper.isInBounds(mouseX, mouseY, this.field_147003_i + 33, this.field_147009_r + 15, this.field_147003_i + 38, this.field_147009_r + 50) || Helper.isInBounds(mouseX, mouseY, this.field_147003_i + 33, this.field_147009_r + 15, this.field_147003_i + 65, this.field_147009_r + 20) || Helper.isInBounds(mouseX, mouseY, this.field_147003_i + 60, this.field_147009_r + 15, this.field_147003_i + 65, this.field_147009_r + 50)) {
            progress = ((NeutronicSpectrometerTile)((Object)((SpectrometerContainer)this.field_147002_h).getBlockEntity())).getProgressTicks();
            maxProgress = ((NeutronicSpectrometerTile)((Object)((SpectrometerContainer)this.field_147002_h).getBlockEntity())).getMaxTicks();
            this.func_243308_b(matrixStack, TextHelper.createProgressBarTooltip(progress, maxProgress), mouseX, mouseY);
        }
        if (Helper.isInBounds(mouseX, mouseY, this.field_147003_i + 105, this.field_147009_r + 20, this.field_147003_i + 140, this.field_147009_r + 60)) {
            progress = ((NeutronicSpectrometerTile)((Object)((SpectrometerContainer)this.field_147002_h).getBlockEntity())).getDownloadTicks();
            maxProgress = ((NeutronicSpectrometerTile)((Object)((SpectrometerContainer)this.field_147002_h).getBlockEntity())).getMaxDownloadTicks();
            this.func_243308_b(matrixStack, TextHelper.createProgressBarTooltip(progress, maxProgress), mouseX, mouseY + 15);
        }
        if (Helper.isInBounds(mouseX, mouseY, this.field_147003_i + 125, this.field_147009_r + 5, this.field_147003_i + 160, this.field_147009_r + 20) && !(schematics = ((NeutronicSpectrometerTile)((Object)((SpectrometerContainer)this.field_147002_h).getBlockEntity())).getSchematics()).isEmpty()) {
            List<ITextComponent> texts = TextHelper.getSchematicsInList(schematics);
            texts.add(0, (ITextComponent)new TranslationTextComponent("tooltip.tardis.stored_schematic"));
            this.func_243308_b(matrixStack, texts, mouseX, mouseY);
        }
    }

    public void renderProgressBar(MatrixStack stack, float percent) {
        int segment = (int)Math.ceil(percent * 8.0f);
        int x = this.field_147003_i + 33;
        int y = this.field_147009_r + 19;
        if (segment > 0) {
            this.func_238474_b_(stack, x + 11, y, 188, 1, 10, 5);
        }
        if (segment > 1) {
            this.func_238474_b_(stack, x + 22, y, 199, 1, 10, 10);
        }
        if (segment > 2) {
            this.func_238474_b_(stack, x + 27, y + 11, 204, 12, 5, 10);
        }
        if (segment > 3) {
            this.func_238474_b_(stack, x + 22, y + 22, 199, 23, 10, 10);
        }
        if (segment > 4) {
            this.func_238474_b_(stack, x + 11, y + 27, 188, 1, 10, 5);
        }
        if (segment > 5) {
            this.func_238474_b_(stack, x, y + 22, 177, 23, 10, 10);
        }
        if (segment > 6) {
            this.func_238474_b_(stack, x, y + 11, 204, 12, 5, 10);
        }
        if (segment > 7) {
            this.func_238474_b_(stack, x, y, 177, 1, 10, 10);
        }
    }

    public void renderDownloadProgress(MatrixStack matrix, float percent) {
        int segments = (int)Math.ceil(percent * 5.0f);
        if (segments > 0) {
            this.func_238474_b_(matrix, this.field_147003_i + 108, this.field_147009_r + 25, 177, 34, 5, 10);
        }
        if (segments > 1) {
            this.func_238474_b_(matrix, this.field_147003_i + 108, this.field_147009_r + 36, 177, 34, 5, 10);
        }
        if (segments > 2) {
            this.func_238474_b_(matrix, this.field_147003_i + 108, this.field_147009_r + 47, 177, 56, 10, 10);
        }
        if (segments > 3) {
            this.func_238474_b_(matrix, this.field_147003_i + 119, this.field_147009_r + 52, 188, 61, 10, 5);
        }
        if (segments > 4) {
            this.func_238474_b_(matrix, this.field_147003_i + 130, this.field_147009_r + 49, 199, 58, 11, 11);
        }
    }

    public void renderLamp(MatrixStack stack, int x, int y, LampColor color) {
        if (color == LampColor.OFF) {
            return;
        }
        int u = 0;
        int v = 1;
        if (color == LampColor.GREEN) {
            u = 227;
        } else if (color == LampColor.RED) {
            u = 210;
        }
        this.func_238474_b_(stack, x, y, u, v, 16, 16);
    }

    public static enum LampColor {
        RED,
        GREEN,
        OFF;

    }
}

