/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.guis.containers;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.tardis.mod.blocks.TBlocks;
import net.tardis.mod.containers.QuantiscopeWeldContainer;
import net.tardis.mod.helper.Helper;
import net.tardis.mod.helper.TextHelper;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.QuantiscopeTabMessage;
import net.tardis.mod.tileentities.machines.QuantiscopeTile;

public class QuantiscopeWeldScreen
extends ContainerScreen<QuantiscopeWeldContainer> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("tardis", "textures/gui/containers/quantiscope/weld.png");
    public static final ResourceLocation TEXTURE_IRON = new ResourceLocation("tardis", "textures/gui/containers/quantiscope/weld_iron.png");
    public static TranslationTextComponent weld_tab = new TranslationTextComponent("gui.quantiscope.mode.weld");
    public static TranslationTextComponent sonic_tab = new TranslationTextComponent("gui.quantiscope.mode.sonic");
    private QuantiscopeTile tile;

    public QuantiscopeWeldScreen(QuantiscopeWeldContainer cont, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)cont, inv, titleIn);
        this.tile = (QuantiscopeTile)((Object)cont.getBlockEntity());
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.addModeButton(-71, 21, 193, 1);
        this.addModeButton(-7, 21, 188, -1);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        this.func_230446_a_(matrixStack);
        int texWidth = 176;
        int textHeight = 166;
        ResourceLocation texture = this.tile.func_195044_w().func_177230_c() == TBlocks.quantiscope_brass.get() ? TEXTURE : TEXTURE_IRON;
        this.field_230706_i_.func_110434_K().func_110577_a(texture);
        this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 - texWidth / 2, this.field_230709_l_ / 2 - textHeight / 2, 0, 0, texWidth, textHeight);
        this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 - 2, this.field_230709_l_ / 2 - 53, 178, 0, (int)(25.0f * this.tile.getProgress()), 17);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
        TranslationTextComponent modeTitle = this.tile.getMode() == QuantiscopeTile.EnumMode.WELD ? weld_tab : sonic_tab;
        QuantiscopeWeldScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (ITextComponent)modeTitle.func_240699_a_(TextFormatting.GREEN), (int)(this.field_230708_k_ / 2 + 42), (int)(this.field_147009_r + 62), (int)0xFFFFFF);
        if (Helper.isInBounds(mouseX, mouseY, this.field_147003_i + 85, this.field_147009_r + 30, this.field_147003_i + 110, this.field_147009_r + 45)) {
            this.func_243308_b(matrixStack, TextHelper.createProgressBarTooltip(this.tile.getCurrentProgress(), this.tile.getMaxProgressTicks()), mouseX, mouseY + 15);
        }
    }

    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
        this.field_230712_o_.func_243248_b(matrixStack, this.field_213127_e.func_145748_c_(), (float)this.field_238744_r_, (float)this.field_238745_s_, 0x404040);
    }

    public void addModeButton(int x, int y, int uOffset, int modIndex) {
        this.func_230480_a_((Widget)new ImageButton(this.field_230708_k_ / 2 - x, this.field_230709_l_ / 2 - y, 4, 8, uOffset, 17, 9, TEXTURE, but -> {
            QuantiscopeTile.EnumMode currentMode = this.tile.getMode();
            int index = currentMode.ordinal() + modIndex;
            if (index < QuantiscopeTile.EnumMode.values().length && index >= 0) {
                currentMode = QuantiscopeTile.EnumMode.values()[index];
            } else if (index < 0) {
                currentMode = QuantiscopeTile.EnumMode.values()[QuantiscopeTile.EnumMode.values().length - 1];
            }
            Network.sendToServer(new QuantiscopeTabMessage(((QuantiscopeTile)((Object)((Object)((QuantiscopeWeldContainer)this.func_212873_a_()).getBlockEntity()))).func_174877_v(), currentMode));
        }));
    }
}

