/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.guis.containers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.tardis.mod.blocks.TBlocks;
import net.tardis.mod.cap.items.sonic.SonicCapability;
import net.tardis.mod.client.guis.containers.QuantiscopeWeldScreen;
import net.tardis.mod.containers.QuantiscopeSonicContainer;
import net.tardis.mod.helper.Helper;
import net.tardis.mod.helper.TRenderHelper;
import net.tardis.mod.items.SonicItem;
import net.tardis.mod.items.TItems;
import net.tardis.mod.items.sonicparts.SonicBasePart;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.QuantiscopeTabMessage;
import net.tardis.mod.network.packets.SonicPartChangeMessage;
import net.tardis.mod.sonic.ISonicPart;
import net.tardis.mod.tileentities.machines.QuantiscopeTile;

public class QuantiscopeSonicScreen
extends ContainerScreen<QuantiscopeSonicContainer> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("tardis", "textures/gui/containers/quantiscope/sonic.png");
    public static final ResourceLocation TEXTURE_IRON = new ResourceLocation("tardis", "textures/gui/containers/quantiscope/sonic_iron.png");
    private ItemStack emitter = new ItemStack((IItemProvider)TItems.SONIC_EMITTER.get());
    private ItemStack activator = new ItemStack((IItemProvider)TItems.SONIC_ACTIVATOR.get());
    private ItemStack handle = new ItemStack((IItemProvider)TItems.SONIC_HANDLE.get());
    private ItemStack end = new ItemStack((IItemProvider)TItems.SONIC_END.get());
    private QuantiscopeTile tile;

    public QuantiscopeSonicScreen(QuantiscopeSonicContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)screenContainer, inv, titleIn);
        this.tile = (QuantiscopeTile)((Object)screenContainer.getBlockEntity());
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.emitter = new ItemStack((IItemProvider)TItems.SONIC_EMITTER.get());
        this.activator = new ItemStack((IItemProvider)TItems.SONIC_ACTIVATOR.get());
        this.handle = new ItemStack((IItemProvider)TItems.SONIC_HANDLE.get());
        this.end = new ItemStack((IItemProvider)TItems.SONIC_END.get());
        this.readFromSlot();
        ((QuantiscopeSonicContainer)this.func_212873_a_()).setSlotChangeAction(() -> this.readFromSlot());
        this.addSonicButton(60, 65, 178, 1, this.emitter);
        this.addSonicButton(22, 65, 178, 1, this.activator);
        this.addSonicButton(-15, 65, 178, 1, this.handle);
        this.addSonicButton(-54, 65, 178, 1, this.end);
        this.addSonicButton(60, 41, 178, -1, this.emitter);
        this.addSonicButton(22, 41, 178, -1, this.activator);
        this.addSonicButton(-15, 41, 178, -1, this.handle);
        this.addSonicButton(-54, 41, 178, -1, this.end);
        this.addModeButton(-71, 21, 193, 1);
        this.addModeButton(-7, 21, 188, -1);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
        this.func_230446_a_(matrixStack);
        int texWidth = 176;
        int textHeight = 166;
        ResourceLocation texture = this.tile.func_195044_w().func_177230_c() == TBlocks.quantiscope_brass.get() ? TEXTURE : TEXTURE_IRON;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 - texWidth / 2, this.field_230709_l_ / 2 - textHeight / 2, 0, 0, texWidth, textHeight);
        matrixStack.func_227860_a_();
        if (this.tile != null && this.tile.getStackInSlot(0).func_190926_b()) {
            matrixStack.func_227861_a_(2.2, 2.25, 0.0);
        } else {
            matrixStack.func_227861_a_(0.0, 0.0, 0.0);
        }
        RenderSystem.enableDepthTest();
        RenderHelper.func_227780_a_();
        this.field_230707_j_.field_77023_b = 10.0f;
        RenderSystem.enableRescaleNormal();
        matrixStack.func_227862_a_(2.0f, 2.0f, 2.0f);
        RenderSystem.disableRescaleNormal();
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
        matrixStack.func_227860_a_();
        RenderSystem.pushMatrix();
        RenderSystem.multMatrix((Matrix4f)matrixStack.func_227866_c_().func_227870_a_());
        TRenderHelper.renderItemOnScreenBackground(matrixStack, this.field_230707_j_, this.emitter, 0.7f, 0.5f, 0.0f);
        RenderSystem.popMatrix();
        matrixStack.func_227865_b_();
        RenderSystem.pushMatrix();
        RenderSystem.multMatrix((Matrix4f)matrixStack.func_227866_c_().func_227870_a_());
        TRenderHelper.renderItemOnScreenBackground(matrixStack, this.field_230707_j_, this.activator, 0.7f, -0.6f, 0.0f);
        RenderSystem.popMatrix();
        RenderSystem.pushMatrix();
        RenderSystem.multMatrix((Matrix4f)matrixStack.func_227866_c_().func_227870_a_());
        TRenderHelper.renderItemOnScreenBackground(matrixStack, this.field_230707_j_, this.handle, 0.7f, -1.75f, 0.0f);
        RenderSystem.popMatrix();
        RenderSystem.pushMatrix();
        RenderSystem.multMatrix((Matrix4f)matrixStack.func_227866_c_().func_227870_a_());
        TRenderHelper.renderItemOnScreenBackground(matrixStack, this.field_230707_j_, this.end, 0.7f, -2.95f, 0.0f);
        RenderSystem.popMatrix();
        RenderHelper.func_74518_a();
        RenderSystem.disableDepthTest();
        matrixStack.func_227865_b_();
    }

    public void readFromSlot() {
        if (((QuantiscopeSonicContainer)this.func_212873_a_()).func_75139_a(0).func_75211_c().func_77973_b() instanceof SonicItem) {
            SonicCapability.getForStack(((QuantiscopeSonicContainer)this.func_212873_a_()).func_75139_a(0).func_75211_c()).ifPresent(cap -> {
                SonicBasePart.setType(this.emitter, cap.getSonicPart(ISonicPart.SonicPart.EMITTER));
                SonicBasePart.setType(this.activator, cap.getSonicPart(ISonicPart.SonicPart.ACTIVATOR));
                SonicBasePart.setType(this.handle, cap.getSonicPart(ISonicPart.SonicPart.HANDLE));
                SonicBasePart.setType(this.end, cap.getSonicPart(ISonicPart.SonicPart.END));
            });
        }
    }

    public void addSonicButton(int x, int y, int u, int mod, ItemStack stack) {
        this.func_230480_a_((Widget)new ImageButton(this.field_230708_k_ / 2 - x, this.field_230709_l_ / 2 - y, 6, 6, u, 1, 7, TEXTURE, but -> {
            int id = SonicBasePart.getType(stack) + mod;
            SonicBasePart.SonicComponentTypes type = SonicBasePart.SonicComponentTypes.values()[0];
            if (id < SonicBasePart.SonicComponentTypes.values().length && id >= 0) {
                type = SonicBasePart.SonicComponentTypes.values()[id];
            } else if (id < 0) {
                type = SonicBasePart.SonicComponentTypes.values()[SonicBasePart.SonicComponentTypes.values().length - 1];
            }
            this.update(stack, type);
        }));
    }

    public void update(ItemStack part, SonicBasePart.SonicComponentTypes type) {
        SonicBasePart.setType(part, type);
        Network.sendToServer(new SonicPartChangeMessage(part, 0, ((QuantiscopeSonicContainer)this.func_212873_a_()).pos));
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        matrixStack.func_227860_a_();
        this.func_230459_a_(matrixStack, mouseX, mouseY);
        if (Helper.isInBounds(mouseX, mouseY, this.field_147003_i + 10, this.field_147009_r + 24, this.field_147003_i + 50, this.field_147009_r + 39)) {
            this.func_230457_a_(matrixStack, this.emitter, mouseX, mouseY);
        }
        if (Helper.isInBounds(mouseX, mouseY, this.field_147003_i + 52, this.field_147009_r + 24, this.field_147003_i + 85, this.field_147009_r + 39)) {
            this.func_230457_a_(matrixStack, this.activator, mouseX, mouseY);
        }
        if (Helper.isInBounds(mouseX, mouseY, this.field_147003_i + 92, this.field_147009_r + 24, this.field_147003_i + 125, this.field_147009_r + 39)) {
            this.func_230457_a_(matrixStack, this.handle, mouseX, mouseY);
        }
        if (Helper.isInBounds(mouseX, mouseY, this.field_147003_i + 130, this.field_147009_r + 24, this.field_147003_i + 160, this.field_147009_r + 39)) {
            this.func_230457_a_(matrixStack, this.end, mouseX, mouseY);
        }
        TranslationTextComponent modeTitle = this.tile.getMode() == QuantiscopeTile.EnumMode.WELD ? QuantiscopeWeldScreen.weld_tab : QuantiscopeWeldScreen.sonic_tab;
        QuantiscopeSonicScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (ITextComponent)modeTitle.func_240699_a_(TextFormatting.GREEN), (int)(this.field_230708_k_ / 2 + 42), (int)(this.field_147009_r + 62), (int)0xFFFFFF);
        matrixStack.func_227865_b_();
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.field_230712_o_.func_243248_b(matrixStack, this.field_213127_e.func_145748_c_(), (float)this.field_238744_r_, (float)this.field_238745_s_, 0x404040);
    }

    public void addModeButton(int x, int y, int uOffset, int modIndex) {
        this.func_230480_a_((Widget)new ImageButton(this.field_230708_k_ / 2 - x, this.field_230709_l_ / 2 - y, 4, 8, uOffset, 17, 9, TEXTURE, but -> {
            QuantiscopeTile.EnumMode currentMode = this.tile.getMode();
            int index = currentMode.ordinal() + modIndex;
            if (index < QuantiscopeTile.EnumMode.values().length && index >= 0) {
                currentMode = QuantiscopeTile.EnumMode.values()[index];
            } else if (index < 0) {
                currentMode = QuantiscopeTile.EnumMode.values()[QuantiscopeTile.EnumMode.values().length - 1];
            } else if (index == QuantiscopeTile.EnumMode.values().length) {
                index = 0;
                currentMode = QuantiscopeTile.EnumMode.values()[index];
            }
            Network.sendToServer(new QuantiscopeTabMessage(((QuantiscopeTile)((Object)((Object)((QuantiscopeSonicContainer)this.func_212873_a_()).getBlockEntity()))).func_174877_v(), currentMode));
        }));
    }
}

