/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.guis.containers;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.RegistryObject;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.client.guis.INeedSyncing;
import net.tardis.mod.client.guis.minigame.WireGameScreen;
import net.tardis.mod.client.guis.widgets.ImageToggleButton;
import net.tardis.mod.containers.EngineContainer;
import net.tardis.mod.containers.slot.EngineSlot;
import net.tardis.mod.helper.Helper;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.helper.TextHelper;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.SubsystemToggleMessage;
import net.tardis.mod.registries.SubsystemRegistry;
import net.tardis.mod.registries.UpgradeRegistry;
import net.tardis.mod.subsystem.SubsystemEntry;
import net.tardis.mod.upgrades.UpgradeEntry;

public class EngineContainerScreen
extends ContainerScreen<EngineContainer>
implements INeedSyncing {
    public static final ResourceLocation TEXTURE = new ResourceLocation("textures/gui/container/generic_54.png");
    public static final ResourceLocation UPGRADES = Helper.createRL("textures/gui/engine/upgrade.png");
    public static final ResourceLocation SUBSYSTEM = Helper.createRL("textures/gui/engine/subsystem.png");
    public static final ResourceLocation CAPACITOR = Helper.createRL("textures/gui/engine/capacitor.png");
    public static final ResourceLocation ATTUNEMENT = Helper.createRL("textures/gui/engine/attunement.png");
    private Minecraft mc;
    public Map<ResourceLocation, ImageToggleButton> SUBSYSTEM_SLIDER_BUTTONS = new HashMap<ResourceLocation, ImageToggleButton>();
    public Map<Integer, ImageToggleButton> UPGRADE_SLIDER_BUTTONS = new HashMap<Integer, ImageToggleButton>();
    public Map<Integer, Boolean> UPGRADE_SLIDER_STATES = new HashMap<Integer, Boolean>();

    public EngineContainerScreen(EngineContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)screenContainer, inv, titleIn);
        this.field_146999_f = 176;
        this.field_147000_g = 132;
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        this.func_230446_a_(matrixStack);
        if (((EngineContainer)this.func_212873_a_()).getPanelDirection() == Direction.SOUTH) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(UPGRADES);
            this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 - 88, this.field_230709_l_ / 2 - 83, 0, 0, 176, 166);
        } else if (((EngineContainer)this.func_212873_a_()).getPanelDirection() == Direction.NORTH) {
            this.mc.field_71446_o.func_110577_a(SUBSYSTEM);
            this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 - 88, this.field_230709_l_ / 2 - 83, 0, 0, 176, 166);
        } else if (((EngineContainer)this.func_212873_a_()).getPanelDirection() == Direction.WEST) {
            this.mc.field_71446_o.func_110577_a(CAPACITOR);
            this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 - 88, this.field_230709_l_ / 2 - 83, 0, 0, 176, 166);
        } else if (((EngineContainer)this.func_212873_a_()).getPanelDirection() == Direction.EAST) {
            this.mc.field_71446_o.func_110577_a(ATTUNEMENT);
            this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 - 88, this.field_230709_l_ / 2 - 83, 0, 0, 176, 166);
            this.mc.field_71441_e.getCapability(Capabilities.TARDIS_DATA).ifPresent(data -> {
                float progress = data.getAttunementHandler().getClientAttunementProgress();
                int amtToDraw = (int)Math.floor(progress * 8.1f);
                if (amtToDraw >= 1) {
                    this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 + 45, this.field_230709_l_ / 2 - 64, 199, 1, 10, 10);
                }
                if (amtToDraw >= 2) {
                    this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 + 50, this.field_230709_l_ / 2 - 53, 204, 12, 5, 10);
                }
                if (amtToDraw >= 3) {
                    this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 + 45, this.field_230709_l_ / 2 - 42, 199, 23, 10, 10);
                }
                if (amtToDraw >= 4) {
                    this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 + 34, this.field_230709_l_ / 2 - 37, 188, 28, 10, 5);
                }
                if (amtToDraw >= 5) {
                    this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 + 23, this.field_230709_l_ / 2 - 42, 177, 23, 10, 10);
                }
                if (amtToDraw >= 6) {
                    this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 + 23, this.field_230709_l_ / 2 - 53, 177, 12, 5, 10);
                }
                if (amtToDraw >= 7) {
                    this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 + 23, this.field_230709_l_ / 2 - 64, 177, 1, 10, 10);
                }
                if (amtToDraw >= 8) {
                    this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 + 34, this.field_230709_l_ / 2 - 64, 188, 1, 10, 5);
                }
            });
        } else {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
            int y = this.field_230709_l_ / 2 - 35;
            this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 - this.field_146999_f / 2, y, 0, 125, this.field_146999_f, 97);
            this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 - this.field_146999_f / 2, y - 35, 0, 0, this.field_146999_f, 35);
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
        EngineContainerScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)this.field_230704_d_.getString(), (int)(this.field_230708_k_ / 2), (int)(this.field_147009_r - 30), (int)0x404040);
        if (((EngineContainer)this.func_212873_a_()).getPanelDirection() == Direction.EAST) {
            this.mc.field_71441_e.getCapability(Capabilities.TARDIS_DATA).ifPresent(cap -> {
                if (Helper.isInBounds(mouseX, mouseY, this.field_230708_k_ / 2 + 20, this.field_147009_r - 5, this.field_230708_k_ / 2 + 50, this.field_147009_r + 5) || Helper.isInBounds(mouseX, mouseY, this.field_230708_k_ / 2 + 47, this.field_147009_r - 5, this.field_230708_k_ / 2 + 52, this.field_147009_r + 35) || Helper.isInBounds(mouseX, mouseY, this.field_230708_k_ / 2 + 20, this.field_147009_r + 27, this.field_230708_k_ / 2 + 50, this.field_147009_r + 33) || Helper.isInBounds(mouseX, mouseY, this.field_230708_k_ / 2 + 20, this.field_147009_r - 5, this.field_230708_k_ / 2 + 30, this.field_147009_r + 30)) {
                    float progress = cap.getAttunementHandler().getClientAttunementProgress();
                    this.func_243308_b(matrixStack, TextHelper.createProgressBarTooltipPercentage(progress), mouseX, mouseY + 15);
                }
            });
        }
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.field_230712_o_.func_238421_b_(matrixStack, this.field_213127_e.func_145748_c_().getString(), 8.0f, (float)(this.field_147000_g - 76), 0x404040);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.mc = Minecraft.func_71410_x();
        this.field_230710_m_.clear();
        if (((EngineContainer)this.func_212873_a_()).getPanelDirection() == Direction.NORTH) {
            this.addEngineSlider(SubsystemRegistry.FLIGHT, this.field_230708_k_ / 2 - 71, this.field_230709_l_ / 2 - 75);
            this.addEngineSlider(SubsystemRegistry.NAV_COM, this.field_230708_k_ / 2 - 29, this.field_230709_l_ / 2 - 75);
            this.addEngineSlider(SubsystemRegistry.CHAMELEON, this.field_230708_k_ / 2 + 13, this.field_230709_l_ / 2 - 75);
            this.addEngineSlider(SubsystemRegistry.TEMPORAL_GRACE, this.field_230708_k_ / 2 + 55, this.field_230709_l_ / 2 - 75);
            this.addEngineSlider(SubsystemRegistry.FLUID_LINKS, this.field_230708_k_ / 2 - 71, this.field_230709_l_ / 2 - 25);
            this.addEngineSlider(SubsystemRegistry.STABILIZERS, this.field_230708_k_ / 2 - 29, this.field_230709_l_ / 2 - 25);
            this.addEngineSlider(SubsystemRegistry.ANTENNA, this.field_230708_k_ / 2 + 13, this.field_230709_l_ / 2 - 25);
            this.addEngineSlider(SubsystemRegistry.SHIELD_GENERATOR, this.field_230708_k_ / 2 + 55, this.field_230709_l_ / 2 - 25);
        }
        if (((EngineContainer)this.func_212873_a_()).getPanelDirection() == Direction.SOUTH) {
            this.addUpgradeSlider(0, this.field_230708_k_ / 2 - 73, this.field_230709_l_ / 2 - 75);
            this.addUpgradeSlider(2, this.field_230708_k_ / 2 - 73 + 33, this.field_230709_l_ / 2 - 75);
            this.addUpgradeSlider(4, this.field_230708_k_ / 2 - 73 + 65, this.field_230709_l_ / 2 - 75);
            this.addUpgradeSlider(6, this.field_230708_k_ / 2 - 73 + 98, this.field_230709_l_ / 2 - 75);
            this.addUpgradeSlider(8, this.field_230708_k_ / 2 - 73 + 130, this.field_230709_l_ / 2 - 75);
            this.addUpgradeSlider(1, this.field_230708_k_ / 2 - 73, this.field_230709_l_ / 2 - 25);
            this.addUpgradeSlider(3, this.field_230708_k_ / 2 - 73 + 33, this.field_230709_l_ / 2 - 25);
            this.addUpgradeSlider(5, this.field_230708_k_ / 2 - 73 + 65, this.field_230709_l_ / 2 - 25);
            this.addUpgradeSlider(7, this.field_230708_k_ / 2 - 73 + 98, this.field_230709_l_ / 2 - 25);
            this.addUpgradeSlider(9, this.field_230708_k_ / 2 - 73 + 130, this.field_230709_l_ / 2 - 25);
        }
    }

    private <T extends SubsystemEntry> void addEngineSlider(RegistryObject<T> sys, int x, int y) {
        ImageToggleButton button = (ImageToggleButton)this.func_230480_a_((Widget)new ImageToggleButton(x, y, 177, 2, 18, 7, but -> {
            ImageToggleButton img;
            img.setChecked(!(img = (ImageToggleButton)but).isChecked());
            Network.sendToServer(new SubsystemToggleMessage(((SubsystemEntry)sys.get()).getRegistryName(), true, img.isChecked()));
            TardisHelper.getConsoleInWorld((World)this.mc.field_71441_e).ifPresent(tile -> tile.getSubsystem(((SubsystemEntry)sys.get()).getRegistryName()).ifPresent(system -> system.setActivated(img.isChecked())));
        }));
        TardisHelper.getConsoleInWorld((World)this.mc.field_71441_e).ifPresent(tile -> tile.getSubsystem(((SubsystemEntry)sys.get()).getRegistryName()).ifPresent(system -> button.setChecked(system.isActivated())));
    }

    private <T extends UpgradeEntry> void addUpgradeSlider(int slotID, int x, int y) {
        ImageToggleButton button = (ImageToggleButton)this.func_230480_a_((Widget)new ImageToggleButton(x, y, 177, 2, 18, 7, but -> {
            UpgradeEntry entry = UpgradeRegistry.getUpgradeFromItem(((EngineContainer)this.func_212873_a_()).func_75139_a(slotID).func_75211_c().func_77973_b());
            if (entry != null) {
                TardisHelper.getConsoleInWorld((World)this.mc.field_71441_e).ifPresent(tile -> tile.getUpgrade(entry.getRegistryName()).ifPresent(upgrade -> {
                    boolean active = !upgrade.isActivated();
                    upgrade.setActivated(active);
                    ((ImageToggleButton)but).setChecked(active);
                    Network.sendToServer(new SubsystemToggleMessage(entry.getRegistryName(), false, active));
                }));
            }
        }));
        this.UPGRADE_SLIDER_BUTTONS.put(slotID, button);
        TardisHelper.getConsoleInWorld((World)this.mc.field_71441_e).ifPresent(tile -> {
            UpgradeEntry entry = UpgradeRegistry.getUpgradeFromItem(((EngineContainer)this.func_212873_a_()).func_75139_a(slotID).func_75211_c().func_77973_b());
            if (entry != null) {
                tile.getUpgrade(entry.getRegistryName()).ifPresent(upgrade -> button.setChecked(upgrade.isActivated()));
            }
        });
    }

    protected void func_184098_a(Slot slotIn, int slotId, int mouseButton, ClickType type) {
        ItemStack held = this.field_213127_e.func_70445_o();
        if (!held.func_190926_b() && slotIn instanceof EngineSlot && slotIn.func_75214_a(held)) {
            Minecraft.func_71410_x().func_212871_a_(() -> Minecraft.func_71410_x().func_147108_a((Screen)new WireGameScreen(slotId, ((EngineContainer)this.field_147002_h).getPanelDirection())));
        }
        super.func_184098_a(slotIn, slotId, mouseButton, type);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            return super.func_231046_a_(keyCode, scanCode, modifiers);
        }
        return false;
    }

    @Override
    public void setStatesFromServer(Map<Integer, Boolean> upgradeStates) {
        for (Map.Entry<Integer, Boolean> entry : upgradeStates.entrySet()) {
            this.UPGRADE_SLIDER_STATES.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Integer, Boolean> entry : this.UPGRADE_SLIDER_STATES.entrySet()) {
            ImageToggleButton button = this.UPGRADE_SLIDER_BUTTONS.get(entry.getKey());
            button.setChecked(entry.getValue());
        }
    }
}

