/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.guis.containers;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.containers.AlembicContainer;
import net.tardis.mod.helper.Helper;
import net.tardis.mod.helper.TextHelper;
import net.tardis.mod.tileentities.machines.AlembicTile;

public class AlembicScreen
extends ContainerScreen<AlembicContainer> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("tardis", "textures/gui/containers/alembic.png");
    private final TranslationTextComponent title = new TranslationTextComponent("container.tardis.alembic");
    private AlembicTile tile;

    public AlembicScreen(AlembicContainer cont, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)cont, inv, titleIn);
        this.tile = (AlembicTile)((Object)cont.getBlockEntity());
        this.field_146999_f = 176;
        this.field_147000_g = 166;
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
        this.func_230446_a_(matrixStack);
        this.field_230706_i_.field_71446_o.func_110577_a(TEXTURE);
        this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 - this.field_146999_f / 2, this.field_230709_l_ / 2 - this.field_147000_g / 2, 0, 0, this.field_146999_f, this.field_147000_g);
        int waterScaled = (int)(53.0f * (1.0f - this.tile.getWaterPercentage()));
        int offsetWaterBlit = 53 - (53 - waterScaled);
        this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 - 42, this.field_230709_l_ / 2 - 73 + offsetWaterBlit, 193, 19 + offsetWaterBlit, 10, 53 - offsetWaterBlit);
        int nonWaterScaled = (int)(53.0f * (1.0f - this.tile.getNonWaterPercentage()));
        int offsetNonWaterFluidBlit = 53 - (53 - nonWaterScaled);
        this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 + 31, this.field_230709_l_ / 2 - 73 + offsetNonWaterFluidBlit, 207, 19 + offsetNonWaterFluidBlit, 10, 53 - offsetNonWaterFluidBlit);
        if (this.tile.getMaxBurnTime() > 0) {
            int fireScaled = (int)(13.0f * (1.0f - this.tile.getBurnTimePercent()));
            this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 - 25, this.field_230709_l_ / 2 - 53 + fireScaled, 203, 1 + fireScaled, 13, 13 - fireScaled);
        }
        this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 + 2, this.field_230709_l_ / 2 - 52, 178, 1, (int)(23.0f * this.tile.getProgressPercent()), 18);
        this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 - 39, this.field_230709_l_ / 2 - 71, 182, 21, 7, 49);
        this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 + 34, this.field_230709_l_ / 2 - 71, 182, 21, 7, 49);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
        this.field_230712_o_.func_243248_b(matrixStack, this.field_213127_e.func_145748_c_(), (float)this.field_238744_r_, (float)this.field_238745_s_, 0x404040);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
        AlembicScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)this.title.getString(), (int)(this.field_230708_k_ / 2), (int)(this.field_147009_r - 13), (int)0xFFFFFF);
        this.renderCustomToolTips(matrixStack, mouseX, mouseY);
    }

    protected void renderCustomToolTips(MatrixStack matrixStack, int mouseX, int mouseY) {
        if (Helper.isInBounds(mouseX, mouseY, this.field_147003_i + 45, this.field_147009_r, this.field_147003_i + 55, this.field_147009_r + 60)) {
            this.func_243308_b(matrixStack, TextHelper.createFluidTankToolTip(this.tile.getWaterTank()), mouseX, mouseY);
        }
        if (Helper.isInBounds(mouseX, mouseY, this.field_147003_i + 90, this.field_147009_r + 29, this.field_147003_i + 110, this.field_147009_r + 45)) {
            this.func_243308_b(matrixStack, TextHelper.createProgressBarTooltip(this.tile.getProgress(), this.tile.getMaxProgress()), mouseX, mouseY + 15);
        }
        if (Helper.isInBounds(mouseX, mouseY, this.field_147003_i + 115, this.field_147009_r, this.field_147003_i + 125, this.field_147009_r + 60)) {
            this.func_243308_b(matrixStack, TextHelper.createSpecialCaseFluidTankToolTip(this.tile.getNonWaterFluidAmount(), this.tile.getMaxNonWaterFluidCapacity(), TardisConstants.ContainerComponentTranslations.MERCURY), mouseX, mouseY);
        }
    }
}

