/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.guis;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.biome.Biome;
import net.tardis.mod.client.guis.IGetStructures;
import net.tardis.mod.client.guis.widgets.TextButton;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.misc.Partition;
import net.tardis.mod.misc.TelepathicUtils;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.TelepathicMessage;

public class TelepathicScreen
extends Screen
implements IGetStructures {
    private static final TranslationTextComponent TITLE = new TranslationTextComponent("gui.tardis.telepathic.title");
    private static final TranslationTextComponent SEARCH = new TranslationTextComponent("gui.tardis.telepathic.search_suggestion");
    private static final int MAX_ELEM_PER_PAGE = 10;
    private final List<TelepathicUtils.Search> searchNames = new ArrayList<TelepathicUtils.Search>();
    private final List<TelepathicUtils.Search> structureNames = new ArrayList<TelepathicUtils.Search>();
    private List<List<TelepathicUtils.Search>> searchPages = Partition.ofSize(this.searchNames, 10);
    private int page = 0;
    private TextFieldWidget textFieldWidget = null;
    private String searchTerm = "";

    public TelepathicScreen() {
        super((ITextComponent)TITLE);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.textFieldWidget = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 100, 50, 200, 20, this.textFieldWidget, (ITextComponent)new StringTextComponent(""));
        this.field_230705_e_.add(this.textFieldWidget);
        for (Widget b : this.field_230710_m_) {
            b.field_230693_o_ = false;
        }
        this.field_230710_m_.clear();
        this.createFilteredList(this.searchTerm, true);
        this.textFieldWidget.func_146184_c(true);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.textFieldWidget.func_146178_a();
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        TelepathicScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (ITextComponent)TITLE, (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 - 90), (int)0xFFFFFF);
        for (Widget w : this.field_230710_m_) {
            w.func_230431_b_(matrixStack, mouseX, mouseY, partialTicks);
        }
        this.textFieldWidget.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.textFieldWidget.func_230999_j_()) {
            this.textFieldWidget.func_195612_c("");
        } else if (this.textFieldWidget.func_146179_b().isEmpty()) {
            this.textFieldWidget.func_195612_c(SEARCH.getString());
        }
    }

    public void createFilteredList(String searchTerm, boolean addBackButtons) {
        for (Widget w : this.field_230710_m_) {
            w.field_230693_o_ = false;
        }
        this.field_230710_m_.clear();
        this.searchNames.clear();
        this.searchNames.add(new TelepathicUtils.Search((ITextComponent)new TranslationTextComponent("message.tardis.world_spawn"), "", TelepathicUtils.SearchType.SPAWN));
        Minecraft.func_71410_x().func_147114_u().func_195514_j().func_241828_r().func_243612_b(Registry.field_239720_u_).func_239659_c_().stream().forEach(biome -> this.searchNames.add(new TelepathicUtils.Search((ITextComponent)new StringTextComponent(WorldHelper.formatBiomeKey((RegistryKey<Biome>)((RegistryKey)biome.getKey()))), ((RegistryKey)biome.getKey()).func_240901_a_().toString(), TelepathicUtils.SearchType.BIOME)));
        this.searchNames.addAll(this.structureNames);
        this.searchNames.sort((one, two) -> one.trans.getString().compareToIgnoreCase(two.trans.getString()));
        int index = 0;
        if (!searchTerm.isEmpty()) {
            this.searchNames.removeIf(biome -> !biome.trans.getString().toLowerCase().contains(searchTerm.toLowerCase()));
        }
        this.searchPages = Partition.ofSize(this.searchNames, 10);
        if (!this.searchNames.isEmpty()) {
            for (TelepathicUtils.Search searchResult : this.searchPages.get(this.page)) {
                int n = this.field_230708_k_ / 2 - 50;
                int n2 = this.field_230709_l_ / 2 + 50;
                this.field_230712_o_.getClass();
                this.func_230480_a_((Widget)new TextButton(n, n2 - (index * 9 + 2), searchResult.trans.getString(), but -> {
                    Network.sendToServer(new TelepathicMessage(searchResult.type, searchResult.key));
                    Minecraft.func_71410_x().func_147108_a(null);
                }));
                ++index;
            }
        }
        if (addBackButtons) {
            this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 50, this.field_230709_l_ / 2 + 75, 20, 20, (ITextComponent)new StringTextComponent(">"), but -> this.mod(1)));
            this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 80, this.field_230709_l_ / 2 + 75, 20, 20, (ITextComponent)new StringTextComponent("<"), but -> this.mod(-1)));
        }
    }

    public void mod(int m) {
        int pages = this.searchPages.size();
        if (this.page + m >= 0 && this.page + m < pages) {
            this.page += m;
        }
        this.func_231160_c_();
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        if (this.textFieldWidget.func_230999_j_()) {
            this.page = 0;
            this.searchTerm = this.textFieldWidget.func_146179_b();
            this.createFilteredList(this.searchTerm, true);
            boolean pressed = this.textFieldWidget.func_231046_a_(keyCode, scanCode, modifiers);
            return pressed;
        }
        return super.func_223281_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        this.textFieldWidget.func_231044_a_(mouseX, mouseY, button);
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231042_a_(char codePoint, int modifiers) {
        return this.textFieldWidget.func_231042_a_(codePoint, modifiers);
    }

    @Override
    public void setTelepathicStructureNamesFromServer(List<TelepathicUtils.Search> searches) {
        this.structureNames.clear();
        this.structureNames.addAll(searches);
        this.func_231160_c_();
    }
}

