/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.guis;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.tardis.mod.client.guis.widgets.ImageAndTextButton;
import net.tardis.mod.contexts.gui.EntityContext;
import net.tardis.mod.contexts.gui.GuiContextBlock;
import net.tardis.mod.controls.AbstractControl;
import net.tardis.mod.entity.ControlEntity;
import net.tardis.mod.misc.GuiContext;
import net.tardis.mod.misc.IMonitor;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.MonitorRemoteMessage;
import net.tardis.mod.tileentities.monitors.MonitorTile;
import net.tardis.mod.tileentities.monitors.RotateMonitorTile;

public class MonitorRemoteGui
extends Screen {
    public static final ResourceLocation TEXTURE = new ResourceLocation("tardis", "textures/gui/monitor_remote.png");
    public static DecimalFormat FORMAT = new DecimalFormat("####");
    private TranslationTextComponent updateExtendTooltip = new TranslationTextComponent("tooltip.gui.monitor_remote.update_arm_length");
    private TranslationTextComponent updateExtendInputTooltip = new TranslationTextComponent("tooltip.gui.monitor_remote.set_arm_length");
    private TranslationTextComponent monitorModeTooltip = new TranslationTextComponent("tooltip.gui.monitor_remote.monitor_mode");
    private TranslationTextComponent updateExtendButtonText = new TranslationTextComponent("gui.tardis.monitor_remote.arm_length_button");
    private TranslationTextComponent northWestButton = new TranslationTextComponent("gui.tardis.remote.view.north_west");
    private TranslationTextComponent southEastButton = new TranslationTextComponent("gui.tardis.remote.view.south_east");
    private TranslationTextComponent orbitButton = new TranslationTextComponent("gui.tardis.remote.view.orbit");
    private TextFieldWidget extendInput;
    private Button updateExtend;
    private IMonitor tile;
    private float monitorviewExtension = 0.0f;
    private MonitorTile.MonitorView view = MonitorTile.MonitorView.PANORAMIC;

    public MonitorRemoteGui(GuiContext context) {
        super((ITextComponent)new StringTextComponent(""));
        if (context instanceof GuiContextBlock) {
            TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(((GuiContextBlock)context).pos);
            if (te instanceof IMonitor) {
                this.tile = (IMonitor)te;
            } else {
                Minecraft.func_71410_x().func_147108_a(null);
            }
        } else if (context instanceof EntityContext) {
            EntityContext ent = (EntityContext)context;
            if (ent.entity instanceof ControlEntity && ((ControlEntity)ent.entity).getControl() instanceof IMonitor) {
                this.tile = (IMonitor)((Object)((ControlEntity)ent.entity).getControl());
            } else {
                Minecraft.func_71410_x().func_147108_a(null);
            }
        } else {
            Minecraft.func_71410_x().func_147108_a(null);
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
        int width = 233;
        int height = 163;
        this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 - width / 2, this.field_230709_l_ / 2 - height / 2, 0, 0, width, height);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        MonitorRemoteGui.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.tardis.monitor_remote.arm_length_title"), (int)(this.field_230708_k_ / 2 + 3), (int)(this.field_230709_l_ / 2 - 8), (int)0xFFFFFF);
        if (this.extendInput.func_230999_j_() || !this.extendInput.func_146179_b().isEmpty()) {
            this.extendInput.func_195612_c("");
        } else if (this.extendInput.func_146179_b().isEmpty() && !this.extendInput.func_230999_j_()) {
            this.extendInput.func_195612_c(this.updateExtendInputTooltip.getString());
        }
        if (this.updateExtend.func_230449_g_()) {
            this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent(this.updateExtendTooltip.getString()), mouseX, mouseY);
        }
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.field_230710_m_.clear();
        this.addExtensionArrowButton(62, -3, 39, -1.0f, 0.0f, 1.0f);
        this.addExtensionArrowButton(-45, -3, 64, 1.0f, 0.0f, 1.0f);
        int n = this.field_230708_k_ / 2 - 32;
        int n2 = this.field_230709_l_ / 2 + 7;
        this.field_230712_o_.getClass();
        this.extendInput = new TextFieldWidget(this.field_230712_o_, n, n2, 70, 9 + 14, (ITextComponent)new TranslationTextComponent(""));
        this.func_230480_a_((Widget)this.extendInput);
        int n3 = this.field_230708_k_ / 2 - 43;
        int n4 = this.field_230709_l_ / 2 + 32;
        this.field_230712_o_.getClass();
        this.updateExtend = new Button(n3, n4, 100, 9 + 11, (ITextComponent)this.updateExtendButtonText, but -> {
            this.monitorviewExtension = MathHelper.func_76131_a((float)(this.getNumber(this.extendInput.func_146179_b()) / 10.0f), (float)0.0f, (float)1.0f);
            this.sendPacket();
            this.func_231175_as__();
        });
        this.func_230480_a_((Widget)this.updateExtend);
        this.view = this.tile.getView();
        if (this.tile instanceof RotateMonitorTile) {
            float amt = ((RotateMonitorTile)this.tile).extendAmount;
            this.extendInput.func_146180_a(FORMAT.format((double)amt * 10.0) + "");
            this.monitorviewExtension = amt;
        }
    }

    public float getNumber(String s) {
        try {
            float f = Float.parseFloat(s);
            return f;
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    public void addModeButton(int x, int y, int u, TranslationTextComponent text, int textColour, MonitorTile.MonitorView viewType) {
        this.func_230480_a_((Widget)new ImageAndTextButton(this.field_230708_k_ / 2 - x, this.field_230709_l_ / 2 - y, 33, 31, u, 166, 31, TEXTURE, text, textColour, but -> {
            this.view = viewType;
            this.sendPacket();
            this.func_231175_as__();
        }));
    }

    public void addExtensionArrowButton(int x, int y, int u, float mod, float min, float max) {
        this.func_230480_a_((Widget)new ImageButton(this.field_230708_k_ / 2 - x, this.field_230709_l_ / 2 - y, 23, 29, u, 168, 30, TEXTURE, but -> {
            float num = this.getNumber(this.extendInput.func_146179_b()) + mod;
            num = MathHelper.func_76131_a((float)num, (float)0.0f, (float)10.0f);
            this.extendInput.func_146180_a(FORMAT.format(num));
            this.extendInput.func_146196_d();
        }));
    }

    public void sendPacket() {
        if (this.tile instanceof TileEntity) {
            Network.sendToServer(new MonitorRemoteMessage(((TileEntity)this.tile).func_174877_v(), this.view, this.monitorviewExtension));
        } else if (this.tile instanceof AbstractControl) {
            Network.sendToServer(new MonitorRemoteMessage(((AbstractControl)((Object)this.tile)).getEntity().func_145782_y(), this.view, this.monitorviewExtension));
        }
    }
}

