/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.guis;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.tardis.mod.client.guis.widgets.TextButton;
import net.tardis.mod.contexts.gui.GuiContextDiagnostic;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.misc.SpaceTimeCoord;
import net.tardis.mod.network.packets.DiagnosticMessage;
import net.tardis.mod.subsystem.SubsystemInfo;

public class DiagnosticGui
extends Screen {
    public static final ResourceLocation TEXTURE = new ResourceLocation("tardis", "textures/gui/diagnostic.png");
    public static DecimalFormat FORMAT = new DecimalFormat("###");
    List<SubsystemInfo> list;
    public Window SUBSYSTEM = matrixStack -> {
        int i = 0;
        int x = this.field_230708_k_ / 2 - 70;
        int y = this.field_230709_l_ / 2 - 80;
        RenderHelper.func_227783_c_();
        TranslationTextComponent subsystem_title = new TranslationTextComponent("overlay.tardis.system_title");
        DiagnosticGui.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)subsystem_title, (int)(x - 20), (int)(y + 10), (int)0xFFFFFF);
        for (SubsystemInfo info : this.list) {
            int n = this.field_230709_l_ / 2 - 55;
            this.field_230712_o_.getClass();
            y = n + i * (9 + 2);
            float percent = info.health * 100.0f;
            TextFormatting color = TextFormatting.GREEN;
            if (percent <= 100.0f) {
                color = TextFormatting.DARK_GREEN;
                if (percent <= 75.0f) {
                    color = TextFormatting.GREEN;
                    if (percent <= 50.0f) {
                        color = TextFormatting.YELLOW;
                        if (percent <= 25.0f) {
                            color = TextFormatting.DARK_RED;
                        }
                    }
                }
            }
            StringTextComponent percentToString = new StringTextComponent(FORMAT.format(percent) + "%");
            DiagnosticGui.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)(new TranslationTextComponent(info.translationKey).getString() + ": " + percentToString.func_240699_a_(color).getString()), (int)x, (int)y, (int)0xFFFFFF);
            Minecraft.func_71410_x().func_175599_af().func_180450_b(new ItemStack((IItemProvider)info.key), x - 16, y - 4);
            ++i;
        }
        RenderHelper.func_74518_a();
    };
    private Window window = null;
    private SpaceTimeCoord location;
    private List<DiagnosticMessage.ArtronUseInfo> artronInfos;
    private DiagnosticMessage.ForgeEnergyInfo energyInfo;

    public DiagnosticGui(GuiContextDiagnostic cont) {
        super((ITextComponent)new StringTextComponent(""));
        this.list = cont.infos;
        this.location = cont.location;
        this.artronInfos = cont.artronInfo;
        this.energyInfo = cont.energy;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
        int width = 255;
        int height = 182;
        this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 - width / 2, this.field_230709_l_ / 2 - height / 2, 0, 0, width, height);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.window != null) {
            this.window.render(matrixStack);
        }
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        if (this.window != null) {
            return;
        }
        int x = this.field_230708_k_ / 2 - 95;
        int y = this.field_230709_l_ / 2;
        this.field_230712_o_.getClass();
        this.func_230480_a_((Widget)new TextButton(x, y - (9 + 2) * 0, new TranslationTextComponent("gui.tardis.diagnostic.menu.subsystem"), but -> this.setWindow(this.SUBSYSTEM)));
        this.field_230712_o_.getClass();
        this.func_230480_a_((Widget)new TextButton(x, y - (9 + 2) * 1, new TranslationTextComponent("gui.tardis.diagnostic.menu.location"), but -> this.setWindow(matrixStack -> {
            int locX = this.field_230708_k_ / 2;
            int locY = this.field_230709_l_ / 2 - 70;
            DiagnosticGui.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.tardis.diagnostic.title.location"), (int)locX, (int)locY, (int)0xFFFFFF);
            TranslationTextComponent translationTextComponent = new TranslationTextComponent("gui.tardis.diagnostic.location", new Object[]{WorldHelper.formatBlockPos(this.location.getPos()), WorldHelper.formatDimName(this.location.getDim())});
            this.field_230712_o_.getClass();
            DiagnosticGui.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)translationTextComponent, (int)locX, (int)(locY + 9 + 6), (int)0xFFFFFF);
        })));
        this.field_230712_o_.getClass();
        this.func_230480_a_((Widget)new TextButton(x, y - (9 + 2) * 2, new TranslationTextComponent("gui.tardis.diagnostic.menu.artron_use"), but -> this.setWindow(matrixStack -> {
            int locX = this.field_230708_k_ / 2;
            int locY = this.field_230709_l_ / 2 - 70;
            DiagnosticGui.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.tardis.diagnostic.artron_use"), (int)locX, (int)locY, (int)0xFFFFFF);
            int index = 0;
            for (DiagnosticMessage.ArtronUseInfo info : this.artronInfos) {
                DecimalFormat FORMAT = new DecimalFormat("#.##");
                String string = info.key.getString() + " " + FORMAT.format(info.use * 20.0f) + "AU/s";
                this.field_230712_o_.getClass();
                DiagnosticGui.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)string, (int)locX, (int)(locY + 20 + index * (9 + 2)), (int)0xFFFFFF);
                ++index;
            }
        })));
        this.field_230712_o_.getClass();
        this.func_230480_a_((Widget)new TextButton(x, y - (9 + 2) * 3, new TranslationTextComponent("gui.tardis.diagnostic.menu.forge_energy"), but -> this.setWindow(matrixStack -> {
            int locX = this.field_230708_k_ / 2;
            int locY = this.field_230709_l_ / 2 - 70;
            DiagnosticGui.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.tardis.diagnostic.title.forge_energy"), (int)locX, (int)locY, (int)0xFFFFFF);
            TranslationTextComponent translationTextComponent = new TranslationTextComponent("gui.tardis.diagnostic.forge_energy", new Object[]{this.energyInfo.currentEnergyStored, this.energyInfo.maxEnergyCapacity});
            this.field_230712_o_.getClass();
            DiagnosticGui.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)translationTextComponent, (int)locX, (int)(locY + 9 + 6), (int)0xFFFFFF);
        })));
    }

    public void setWindow(Window win) {
        this.window = win;
        for (Widget w : this.field_230710_m_) {
            w.field_230693_o_ = false;
        }
        this.field_230710_m_.clear();
    }

    public boolean func_231177_au__() {
        return false;
    }

    public static interface Window {
        public void render(MatrixStack var1);
    }
}

