/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.guis;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.tardis.mod.ars.ARSPiece;
import net.tardis.mod.ars.ARSPieceCategory;
import net.tardis.mod.client.guis.ARSTabletCategoryScreen;
import net.tardis.mod.client.guis.ars.ARSCategoryButton;
import net.tardis.mod.client.guis.widgets.TextButton;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.misc.GuiContext;
import net.tardis.mod.sounds.TSounds;

public class ARSTabletScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("tardis", "textures/gui/ars_tablet.png");
    private List<ARSPieceCategory> categories = Lists.newArrayList();
    protected ARSPieceCategory openCategory = null;
    private int index = 0;

    public ARSTabletScreen() {
        super((ITextComponent)new StringTextComponent(""));
    }

    public ARSTabletScreen(GuiContext cont) {
        this();
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.addButtons(this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 2 - 20);
    }

    public void addButtons(int x, int y) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)((SoundEvent)TSounds.SCREEN_BEEP_SINGLE.get()), (float)1.0f));
        this.categories.clear();
        for (ResourceLocation loc : ARSPiece.getRegistry().keySet()) {
            String[] path = loc.func_110623_a().split("/");
            ARSPieceCategory last = null;
            for (int i = 0; i < path.length - 1; ++i) {
                String name = path[i];
                last = last == null ? this.getOrCreateCategories(name, loc.func_110624_b()) : last.add(name, loc.func_110624_b());
            }
            if (last == null) continue;
            last.addPieceToList(ARSPiece.getRegistry().get(loc));
        }
        int i = 0;
        for (ARSPieceCategory cat : this.categories) {
            this.field_230712_o_.getClass();
            this.func_230480_a_((Widget)new ARSCategoryButton(x, y + i * (9 + 2), cat, this));
            ++i;
        }
    }

    public ARSPieceCategory getOrCreateCategories(String name, String modid) {
        for (ARSPieceCategory cat : this.categories) {
            if (!cat.categoryMatches(name, modid)) continue;
            return cat;
        }
        ARSPieceCategory cat = new ARSPieceCategory(name, modid);
        this.categories.add(cat);
        return cat;
    }

    public void modIndex(int mod, int size) {
        this.index = this.index + mod > size ? 0 : (this.index + mod < 0 ? size : (this.index += mod));
        this.func_231160_c_();
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
        int width = 256;
        int height = 173;
        this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 - width / 2, this.field_230709_l_ / 2 - height / 2, 0, 0, width, height);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        ARSTabletScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)new TranslationTextComponent("gui.tardis.ars_tablet.gui_title").getString(), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 - (height / 2 - 30)), (int)0xFFFFFF);
        ARSTabletScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)new TranslationTextComponent("gui.tardis.ars_tablet.gui_info").getString(), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 - (height / 2 - 50)), (int)0xFFFFFF);
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void openCategory(ARSPieceCategory cate) {
        this.openCategory = cate;
        Minecraft.func_71410_x().func_147108_a((Screen)new ARSTabletCategoryScreen(this.openCategory));
    }

    protected void addDefaultButtons(int x, int maxIndex) {
        this.func_230480_a_((Widget)new TextButton(x, this.field_230709_l_ / 2 + 45, TardisConstants.Translations.GUI_NEXT.getString(), but -> this.modIndex(1, maxIndex)));
        this.func_230480_a_((Widget)new TextButton(x, this.field_230709_l_ / 2 + 55, TardisConstants.Translations.GUI_PREV.getString(), but -> this.modIndex(-1, maxIndex)));
    }
}

