/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.guis;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.widget.Widget;
import net.tardis.mod.ars.ARSPiece;
import net.tardis.mod.ars.ARSPieceCategory;
import net.tardis.mod.client.guis.ARSTabletScreen;
import net.tardis.mod.client.guis.ars.ARSCategoryButton;
import net.tardis.mod.client.guis.ars.ARSPieceButton;

public class ARSTabletCategoryScreen
extends ARSTabletScreen {
    private static final int MAX_PER_PAGE = 6;
    private int index = 0;
    private ARSPieceCategory category;

    public ARSTabletCategoryScreen() {
    }

    public ARSTabletCategoryScreen(ARSPieceCategory category) {
        this();
        this.category = category;
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.addButtons(this.category);
    }

    public void addButtons(ARSPieceCategory category) {
        for (Widget w : this.field_230710_m_) {
            w.field_230694_p_ = false;
            w.field_230693_o_ = false;
            w.func_231049_c__(false);
        }
        this.field_230710_m_.clear();
        int x = this.field_230708_k_ / 2 - 100;
        int y = this.field_230709_l_ / 2 - 20;
        int maxPageIndex = this.calculateMaxPageIndex(category);
        this.addDefaultButtons(x, maxPageIndex);
        this.addSubCategoriesAndOrPieces(category, x, y);
    }

    @Override
    public void modIndex(int mod, int size) {
        this.index = this.index + mod > size ? 0 : (this.index + mod < 0 ? size : (this.index += mod));
        this.func_231160_c_();
    }

    private int calculateMaxPageIndex(ARSPieceCategory category) {
        int mergedNoPages;
        int maxPageIndex = 0;
        maxPageIndex = !category.getChildren().isEmpty() && category.getPieces().isEmpty() ? (category.getChildren().size() % 6 == 0 ? category.getChildren().size() / 6 - 1 : category.getChildren().size() / 6) : (!category.getPieces().isEmpty() && category.getChildren().isEmpty() ? (category.getPieces().size() % 6 == 0 ? category.getPieces().size() / 6 - 1 : category.getPieces().size() / 6) : ((mergedNoPages = category.getChildren().size() + category.getPieces().size()) % 6 == 0 ? mergedNoPages / 6 - 1 : mergedNoPages / 6));
        return maxPageIndex;
    }

    private void addSubCategoriesAndOrPieces(ARSPieceCategory category, int x, int y) {
        int startIndex = this.index * 6;
        if (!category.getChildren().isEmpty() && category.getPieces().isEmpty()) {
            this.addCategories(category, startIndex, x, y);
        } else if (!category.getPieces().isEmpty() && category.getChildren().isEmpty()) {
            this.addPieces(category, startIndex, x, y);
        } else {
            this.mergeAndAddCategoriesAndPieces(category, startIndex, x, y);
        }
    }

    private void addCategories(ARSPieceCategory category, int startIndex, int x, int y) {
        int textSpacing = 0;
        ArrayList allCategories = Lists.newArrayList(category.getChildren());
        if (startIndex < allCategories.size()) {
            int lastIndex = startIndex + 6;
            lastIndex = lastIndex >= allCategories.size() ? allCategories.size() : lastIndex;
            List categoryPage = allCategories.subList(startIndex, lastIndex);
            for (ARSPieceCategory cat : categoryPage) {
                this.field_230712_o_.getClass();
                this.func_230480_a_((Widget)new ARSCategoryButton(x, y + textSpacing * (9 + 2), cat, this));
                ++textSpacing;
            }
        } else {
            this.index = 0;
        }
    }

    private void addPieces(ARSPieceCategory category, int startIndex, int x, int y) {
        int textSpacing = 0;
        ArrayList all = Lists.newArrayList(category.getPieces());
        all.sort((one, two) -> one.getRegistryName().func_110623_a().compareToIgnoreCase(two.getRegistryName().func_110623_a()));
        if (startIndex < all.size()) {
            int lastIndex = startIndex + 6;
            lastIndex = lastIndex >= all.size() ? all.size() : lastIndex;
            List page = all.subList(startIndex, lastIndex);
            for (ARSPiece piece : page) {
                if (piece != null) {
                    this.field_230712_o_.getClass();
                    this.func_230480_a_((Widget)new ARSPieceButton(x, y + textSpacing * (9 + 2), piece));
                }
                ++textSpacing;
            }
        } else {
            this.index = 0;
        }
    }

    private void mergeAndAddCategoriesAndPieces(ARSPieceCategory category, int startIndex, int x, int y) {
        int textSpacing = 0;
        int totalSize = category.getChildren().size() + category.getPieces().size();
        if (startIndex < totalSize) {
            int lastIndex = startIndex + 6;
            ArrayList allPieces = Lists.newArrayList(category.getPieces());
            ArrayList allCategories = Lists.newArrayList(category.getChildren());
            lastIndex = lastIndex >= allCategories.size() ? allCategories.size() : lastIndex;
            List subCategoryList = Lists.newArrayList();
            if (startIndex < lastIndex) {
                subCategoryList = allCategories.subList(startIndex, lastIndex);
            }
            int lastPieceIndex = startIndex + 6 - (startIndex >= 6 ? 0 : lastIndex);
            lastPieceIndex = lastPieceIndex >= allPieces.size() ? allPieces.size() : lastPieceIndex;
            List pieceList = Lists.newArrayList();
            if (startIndex < lastPieceIndex) {
                pieceList = allPieces.subList(startIndex, lastPieceIndex);
            }
            for (ARSPieceCategory cat : subCategoryList) {
                this.field_230712_o_.getClass();
                this.func_230480_a_((Widget)new ARSCategoryButton(x, y + textSpacing * (9 + 2), cat, this));
                ++textSpacing;
            }
            for (ARSPiece piece : pieceList) {
                if (piece != null) {
                    this.field_230712_o_.getClass();
                    this.func_230480_a_((Widget)new ARSPieceButton(x, y + textSpacing * (9 + 2), piece));
                }
                ++textSpacing;
            }
        }
    }
}

