/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.animation;

import net.minecraft.util.math.MathHelper;
import net.tardis.mod.client.animation.ExteriorAnimation;
import net.tardis.mod.client.animation.ExteriorAnimationEntry;
import net.tardis.mod.enums.EnumMatterState;
import net.tardis.mod.tileentities.exteriors.ExteriorTile;

public class NewWhoExteriorAnimation
extends ExteriorAnimation {
    private float alpha = 1.0f;
    private int pulseTime = 20;
    private int pulses = 0;

    public NewWhoExteriorAnimation(ExteriorAnimationEntry entry, ExteriorTile exterior) {
        super(entry, exterior);
    }

    @Override
    public void tick(int timeLeft) {
        if (this.exterior.getMatterState() == EnumMatterState.DEMAT) {
            this.setAlpha(1.0f - this.animateRemat(timeLeft));
        } else {
            this.setAlpha(this.animateRemat(timeLeft));
        }
    }

    public float animateRemat(int timeLeft) {
        if (timeLeft != this.getMaxTime() && timeLeft % this.pulseTime == 0) {
            ++this.pulses;
        }
        float pulseAmount = (float)this.pulses / (float)this.calcMaxPulses();
        return pulseAmount + this.pulseWithIntensity(0.4f, (float)timeLeft * 0.175f);
    }

    public void setAlpha(float alpha) {
        this.alpha = MathHelper.func_76131_a((float)alpha, (float)0.0f, (float)1.0f);
    }

    public int calcMaxPulses() {
        return (int)Math.floor((double)this.getMaxTime() / (double)this.pulseTime);
    }

    public float pulseWithIntensity(float intensity, float frequency) {
        return (float)Math.cos(frequency) * intensity;
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public void reset() {
        this.alpha = 0.0f;
        this.pulses = 0;
    }
}

